/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.anno;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.DeclarationVisitors;
import com.sun.mirror.util.SimpleDeclarationVisitor;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.nb.CompatVersion;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.util.CodegenUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationBinder
implements AnnotationProcessorFactory {
    private static final Collection<String> supportedAnnotations = Collections.unmodifiableCollection(Arrays.asList("org.jruby.nb.anno.JRubyMethod", "org.jruby.nb.anno.JRubyClass"));
    private static final Collection<String> supportedOptions = Collections.emptySet();

    public Collection<String> supportedAnnotationTypes() {
        return supportedAnnotations;
    }

    public Collection<String> supportedOptions() {
        return supportedOptions;
    }

    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> set, AnnotationProcessorEnvironment annotationProcessorEnvironment) {
        return new AnnotationBindingProcessor(annotationProcessorEnvironment);
    }

    private static class AnnotationBindingProcessor
    implements AnnotationProcessor {
        private final AnnotationProcessorEnvironment env;
        private final List<String> classNames = new ArrayList<String>();

        AnnotationBindingProcessor(AnnotationProcessorEnvironment annotationProcessorEnvironment) {
            this.env = annotationProcessorEnvironment;
        }

        public void process() {
            for (Object object : this.env.getSpecifiedTypeDeclarations()) {
                object.accept(DeclarationVisitors.getDeclarationScanner((DeclarationVisitor)new RubyClassVisitor(), (DeclarationVisitor)DeclarationVisitors.NO_OP));
            }
            try {
                FileWriter fileWriter = new FileWriter("src_gen/annotated_classes.txt");
                for (String string : this.classNames) {
                    fileWriter.write(string);
                    fileWriter.write(10);
                }
                fileWriter.close();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public static int getArityValue(JRubyMethod jRubyMethod, int n) {
            if (jRubyMethod.optional() > 0 || jRubyMethod.rest()) {
                return -(n + 1);
            }
            return n;
        }

        public static String getCallConfigNameByAnno(JRubyMethod jRubyMethod) {
            return AnnotationBindingProcessor.getCallConfigName(jRubyMethod.frame(), jRubyMethod.scope(), jRubyMethod.backtrace());
        }

        public static String getCallConfigName(boolean bl, boolean bl2, boolean bl3) {
            if (bl) {
                if (bl2) {
                    return "FRAME_AND_SCOPE";
                }
                return "FRAME_ONLY";
            }
            if (bl2) {
                if (bl3) {
                    return "BACKTRACE_AND_SCOPE";
                }
                return "SCOPE_ONLY";
            }
            if (bl3) {
                return "BACKTRACE_ONLY";
            }
            return "NO_FRAME_NO_SCOPE";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class RubyClassVisitor
        extends SimpleDeclarationVisitor {
            private PrintStream out;
            private static final boolean DEBUG = false;

            private RubyClassVisitor() {
            }

            public void visitClassDeclaration(ClassDeclaration classDeclaration) {
                try {
                    String string = classDeclaration.getQualifiedName().replace('.', '$');
                    if (!string.contains("org$jruby")) {
                        return;
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                    this.out = new PrintStream(byteArrayOutputStream);
                    this.out.println("/* THIS FILE IS GENERATED. DO NOT EDIT */");
                    this.out.println("package org.jruby.nb.gen;");
                    this.out.println("import org.jruby.nb.RubyModule;");
                    this.out.println("import org.jruby.nb.RubyClass;");
                    this.out.println("import org.jruby.nb.CompatVersion;");
                    this.out.println("import org.jruby.nb.anno.TypePopulator;");
                    this.out.println("import org.jruby.nb.internal.runtime.methods.CallConfiguration;");
                    this.out.println("import org.jruby.nb.internal.runtime.methods.JavaMethod;");
                    this.out.println("import org.jruby.nb.internal.runtime.methods.DynamicMethod;");
                    this.out.println("import org.jruby.nb.runtime.Arity;");
                    this.out.println("import org.jruby.nb.runtime.Visibility;");
                    this.out.println("import org.jruby.nb.compiler.ASTInspector;");
                    this.out.println("public class " + string + "$Populator extends TypePopulator {");
                    this.out.println("    public void populate(RubyModule cls, Class clazz) {");
                    this.out.println("        JavaMethod javaMethod;");
                    this.out.println("        DynamicMethod moduleMethod;");
                    this.out.println("        RubyClass metaClass = cls.getMetaClass();");
                    this.out.println("        RubyModule singletonClass;");
                    this.out.println("        CompatVersion compatVersion = cls.getRuntime().getInstanceConfig().getCompatVersion();");
                    HashMap<String, List<MethodDeclaration>> hashMap = new HashMap<String, List<MethodDeclaration>>();
                    HashMap<String, List<MethodDeclaration>> hashMap2 = new HashMap<String, List<MethodDeclaration>>();
                    HashMap<String, List<MethodDeclaration>> hashMap3 = new HashMap<String, List<MethodDeclaration>>();
                    HashMap<String, List<MethodDeclaration>> hashMap4 = new HashMap<String, List<MethodDeclaration>>();
                    HashMap<String, List<MethodDeclaration>> hashMap5 = new HashMap<String, List<MethodDeclaration>>();
                    HashMap<String, List<MethodDeclaration>> hashMap6 = new HashMap<String, List<MethodDeclaration>>();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    int n = 0;
                    for (MethodDeclaration object : classDeclaration.getMethods()) {
                        JRubyMethod jRubyMethod = (JRubyMethod)object.getAnnotation(JRubyMethod.class);
                        if (jRubyMethod == null) continue;
                        ++n;
                        String string2 = jRubyMethod.name().length == 0 ? object.getSimpleName() : jRubyMethod.name()[0];
                        HashMap<String, List<MethodDeclaration>> hashMap7 = null;
                        hashMap7 = object.getModifiers().contains(Modifier.STATIC) ? (jRubyMethod.compat() == CompatVersion.RUBY1_8 ? hashMap4 : (jRubyMethod.compat() == CompatVersion.RUBY1_9 ? hashMap6 : hashMap2)) : (jRubyMethod.compat() == CompatVersion.RUBY1_8 ? hashMap3 : (jRubyMethod.compat() == CompatVersion.RUBY1_9 ? hashMap5 : hashMap));
                        ArrayList<MethodDeclaration> arrayList2 = (ArrayList<MethodDeclaration>)hashMap7.get(string2);
                        if (arrayList2 == null) {
                            arrayList2 = new ArrayList<MethodDeclaration>();
                            hashMap7.put(string2, arrayList2);
                        }
                        arrayList2.add(object);
                        if (!jRubyMethod.frame() && (jRubyMethod.reads() == null || jRubyMethod.reads().length < 1) && (jRubyMethod.writes() == null || jRubyMethod.writes().length < 1)) continue;
                        arrayList.add(string2);
                    }
                    if (n == 0) {
                        return;
                    }
                    AnnotationBindingProcessor.this.classNames.add(this.getActualQualifiedName((TypeDeclaration)classDeclaration));
                    this.processMethodDeclarations(hashMap2);
                    if (!hashMap4.isEmpty()) {
                        this.out.println("        if (compatVersion == CompatVersion.RUBY1_8 || compatVersion == CompatVersion.BOTH) {");
                        this.processMethodDeclarations(hashMap4);
                        this.out.println("        }");
                    }
                    if (!hashMap6.isEmpty()) {
                        this.out.println("        if (compatVersion == CompatVersion.RUBY1_9 || compatVersion == CompatVersion.BOTH) {");
                        this.processMethodDeclarations(hashMap6);
                        this.out.println("        }");
                    }
                    this.processMethodDeclarations(hashMap);
                    if (!hashMap3.isEmpty()) {
                        this.out.println("        if (compatVersion == CompatVersion.RUBY1_8 || compatVersion == CompatVersion.BOTH) {");
                        this.processMethodDeclarations(hashMap3);
                        this.out.println("        }");
                    }
                    if (!hashMap5.isEmpty()) {
                        this.out.println("        if (compatVersion == CompatVersion.RUBY1_9 || compatVersion == CompatVersion.BOTH) {");
                        this.processMethodDeclarations(hashMap5);
                        this.out.println("        }");
                    }
                    for (String string3 : arrayList) {
                        this.out.println("        ASTInspector.FRAME_AWARE_METHODS.add(\"" + string3 + "\");");
                    }
                    this.out.println("    }");
                    this.out.println("}");
                    this.out.close();
                    this.out = null;
                    FileOutputStream fileOutputStream = new FileOutputStream("src_gen/" + string + "$Populator.java");
                    fileOutputStream.write(byteArrayOutputStream.toByteArray());
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    System.err.println("FAILED TO GENERATE:");
                    iOException.printStackTrace();
                    System.exit(1);
                }
            }

            public void processMethodDeclarations(Map<String, List<MethodDeclaration>> map) {
                for (Map.Entry<String, List<MethodDeclaration>> entry : map.entrySet()) {
                    List<MethodDeclaration> list = entry.getValue();
                    if (list.size() == 1) {
                        this.processMethodDeclaration(list.get(0));
                        continue;
                    }
                    this.processMethodDeclarationMulti(list.get(0));
                }
            }

            public void processMethodDeclaration(MethodDeclaration methodDeclaration) {
                JRubyMethod jRubyMethod = (JRubyMethod)methodDeclaration.getAnnotation(JRubyMethod.class);
                if (jRubyMethod != null && this.out != null) {
                    Object object2;
                    boolean bl = methodDeclaration.getModifiers().contains(Modifier.STATIC);
                    String string = this.getActualQualifiedName(methodDeclaration.getDeclaringType());
                    boolean bl2 = false;
                    boolean bl3 = false;
                    for (Object object2 : methodDeclaration.getParameters()) {
                        bl2 |= object2.getType().toString().equals("org.jruby.nb.runtime.ThreadContext");
                        bl3 |= object2.getType().toString().equals("org.jruby.nb.runtime.Block");
                    }
                    int n = this.calculateActualRequired(methodDeclaration.getParameters().size(), jRubyMethod.optional(), jRubyMethod.rest(), bl, bl2, bl3);
                    object2 = CodegenUtils.getAnnotatedBindingClassName(methodDeclaration.getSimpleName(), string, bl, n, jRubyMethod.optional(), false, jRubyMethod.frame());
                    String string2 = jRubyMethod.meta() ? "metaClass" : "cls";
                    this.out.println("        javaMethod = new " + (String)object2 + "(" + string2 + ", Visibility." + (Object)((Object)jRubyMethod.visibility()) + ");");
                    this.out.println("        populateMethod(javaMethod, " + AnnotationBindingProcessor.getArityValue(jRubyMethod, n) + ", \"" + methodDeclaration.getSimpleName() + "\", " + bl + ", " + "CallConfiguration." + AnnotationBindingProcessor.getCallConfigNameByAnno(jRubyMethod) + ");");
                    this.generateMethodAddCalls(methodDeclaration, jRubyMethod);
                }
            }

            public void processMethodDeclarationMulti(MethodDeclaration methodDeclaration) {
                JRubyMethod jRubyMethod = (JRubyMethod)methodDeclaration.getAnnotation(JRubyMethod.class);
                if (jRubyMethod != null && this.out != null) {
                    Object object2;
                    boolean bl = methodDeclaration.getModifiers().contains(Modifier.STATIC);
                    String string = this.getActualQualifiedName(methodDeclaration.getDeclaringType());
                    boolean bl2 = false;
                    boolean bl3 = false;
                    for (Object object2 : methodDeclaration.getParameters()) {
                        bl2 |= object2.getType().toString().equals("org.jruby.nb.runtime.ThreadContext");
                        bl3 |= object2.getType().toString().equals("org.jruby.nb.runtime.Block");
                    }
                    int n = this.calculateActualRequired(methodDeclaration.getParameters().size(), jRubyMethod.optional(), jRubyMethod.rest(), bl, bl2, bl3);
                    object2 = CodegenUtils.getAnnotatedBindingClassName(methodDeclaration.getSimpleName(), string, bl, n, jRubyMethod.optional(), true, jRubyMethod.frame());
                    String string2 = jRubyMethod.meta() ? "metaClass" : "cls";
                    this.out.println("        javaMethod = new " + (String)object2 + "(" + string2 + ", Visibility." + (Object)((Object)jRubyMethod.visibility()) + ");");
                    this.out.println("        populateMethod(javaMethod, -1, \"" + methodDeclaration.getSimpleName() + "\", " + bl + ", " + "CallConfiguration." + AnnotationBindingProcessor.getCallConfigNameByAnno(jRubyMethod) + ");");
                    this.generateMethodAddCalls(methodDeclaration, jRubyMethod);
                }
            }

            private String getActualQualifiedName(TypeDeclaration typeDeclaration) {
                String string = typeDeclaration.getDeclaringType() != null ? (typeDeclaration.getDeclaringType().getDeclaringType() != null ? typeDeclaration.getDeclaringType().getDeclaringType().getQualifiedName() + "$" + typeDeclaration.getDeclaringType().getSimpleName() + "$" + typeDeclaration.getSimpleName() : typeDeclaration.getDeclaringType().getQualifiedName() + "$" + typeDeclaration.getSimpleName()) : typeDeclaration.getQualifiedName();
                return string;
            }

            private boolean tryClass(String string) {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                return clazz != null;
            }

            private int calculateActualRequired(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
                int n3;
                if (n2 == 0 && !bl) {
                    int n4 = n;
                    if (n4 == 0) {
                        n3 = 0;
                    } else {
                        if (bl2) {
                            --n4;
                        }
                        if (bl3) {
                            --n4;
                        }
                        if (bl4) {
                            --n4;
                        }
                        n3 = n4;
                    }
                } else {
                    int n5 = n;
                    if (n5 == 0) {
                        n3 = 0;
                    } else {
                        if (bl2) {
                            --n5;
                        }
                        if (bl3) {
                            --n5;
                        }
                        if (bl4) {
                            --n5;
                        }
                        n3 = --n5;
                    }
                    if (n3 != 0) {
                        throw new RuntimeException("Combining specific args with IRubyObject[] is not yet supported");
                    }
                }
                return n3;
            }

            /*
             * WARNING - void declaration
             */
            public void generateMethodAddCalls(MethodDeclaration methodDeclaration, JRubyMethod jRubyMethod) {
                block18: {
                    block17: {
                        if (jRubyMethod.frame()) {
                            for (String string : jRubyMethod.name()) {
                                this.out.println("        ASTInspector.FRAME_AWARE_METHODS.add(\"" + string + "\");");
                            }
                        }
                        if (!jRubyMethod.meta()) break block17;
                        if (jRubyMethod.name().length == 0) {
                            String string = methodDeclaration.getSimpleName();
                            this.out.println("        metaClass.addMethod(\"" + string + "\", javaMethod);");
                        } else {
                            String string = jRubyMethod.name()[0];
                            for (String string2 : jRubyMethod.name()) {
                                this.out.println("        metaClass.addMethod(\"" + string2 + "\", javaMethod);");
                            }
                        }
                        if (jRubyMethod.alias().length <= 0) break block18;
                        for (String string2 : jRubyMethod.alias()) {
                            void var3_6;
                            this.out.println("        metaClass.defineAlias(\"" + string2 + "\", \"" + (String)var3_6 + "\");");
                        }
                        break block18;
                    }
                    if (jRubyMethod.name().length == 0) {
                        String string = methodDeclaration.getSimpleName();
                        this.out.println("        cls.addMethod(\"" + string + "\", javaMethod);");
                    } else {
                        String string = jRubyMethod.name()[0];
                        for (String string3 : jRubyMethod.name()) {
                            this.out.println("        cls.addMethod(\"" + string3 + "\", javaMethod);");
                        }
                    }
                    if (jRubyMethod.alias().length > 0) {
                        for (String string3 : jRubyMethod.alias()) {
                            void var3_9;
                            this.out.println("        cls.defineAlias(\"" + string3 + "\", \"" + (String)var3_9 + "\");");
                        }
                    }
                    if (jRubyMethod.module()) {
                        this.out.println("        moduleMethod = populateModuleMethod(cls, javaMethod);");
                        this.out.println("        singletonClass = moduleMethod.getImplementationClass();");
                        if (jRubyMethod.name().length == 0) {
                            String string = methodDeclaration.getSimpleName();
                            this.out.println("        singletonClass.addMethod(\"" + string + "\", moduleMethod);");
                        } else {
                            String string = jRubyMethod.name()[0];
                            for (String string3 : jRubyMethod.name()) {
                                this.out.println("        singletonClass.addMethod(\"" + string3 + "\", moduleMethod);");
                            }
                        }
                        if (jRubyMethod.alias().length > 0) {
                            for (String string3 : jRubyMethod.alias()) {
                                void var3_12;
                                this.out.println("        singletonClass.defineAlias(\"" + string3 + "\", \"" + (String)var3_12 + "\");");
                            }
                        }
                    }
                }
            }
        }
    }
}

