/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.api.gsf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.spi.editor.completion.CompletionItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HtmlExtension {
    private static final Map<String, Collection<HtmlExtension>> EXTENSIONS = new HashMap<String, Collection<HtmlExtension>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(String string, HtmlExtension htmlExtension) {
        Map<String, Collection<HtmlExtension>> map = EXTENSIONS;
        synchronized (map) {
            Collection<HtmlExtension> collection = EXTENSIONS.get(string);
            if (collection == null) {
                collection = new ArrayList<HtmlExtension>();
                EXTENSIONS.put(string, collection);
            }
            collection.add(htmlExtension);
        }
    }

    public static Collection<HtmlExtension> getRegisteredExtensions(String string) {
        Collection<HtmlExtension> collection = EXTENSIONS.get(string);
        return collection != null ? collection : Collections.emptyList();
    }

    public abstract Map<OffsetRange, Set<ColoringAttributes>> getHighlights(HtmlParserResult var1, SchedulerEvent var2);

    public abstract List<CompletionItem> completeOpenTags(CompletionContext var1);

    public abstract List<CompletionItem> completeAttributes(CompletionContext var1);

    public abstract List<CompletionItem> completeAttributeValue(CompletionContext var1);

    public abstract OffsetRange getReferenceSpan(Document var1, int var2);

    public abstract DeclarationFinder.DeclarationLocation findDeclaration(ParserResult var1, int var2);

    public abstract void computeErrors(HintsProvider.HintsManager var1, RuleContext var2, List<Hint> var3, List<Error> var4);

    public static class CompletionContext {
        private HtmlParserResult result;
        private int originalOffset;
        private int ccItemStartOffset;
        private int astoffset;
        private String preText;
        private String itemText;
        private AstNode currentNode;
        private String attributeName;
        private boolean valueQuoted;

        public CompletionContext(HtmlParserResult htmlParserResult, int n, int n2, int n3, String string, String string2) {
            this(htmlParserResult, n, n2, n3, string, string2, null);
        }

        public CompletionContext(HtmlParserResult htmlParserResult, int n, int n2, int n3, String string, String string2, AstNode astNode) {
            this(htmlParserResult, n, n2, n3, string, string2, astNode, null, false);
        }

        public CompletionContext(HtmlParserResult htmlParserResult, int n, int n2, int n3, String string, String string2, AstNode astNode, String string3, boolean bl) {
            this.result = htmlParserResult;
            this.originalOffset = n;
            this.astoffset = n2;
            this.preText = string;
            this.ccItemStartOffset = n3;
            this.currentNode = astNode;
            this.itemText = string2;
            this.attributeName = string3;
            this.valueQuoted = bl;
        }

        public String getPrefix() {
            return this.preText;
        }

        public String getItemText() {
            return this.itemText;
        }

        public int getAstoffset() {
            return this.astoffset;
        }

        public int getOriginalOffset() {
            return this.originalOffset;
        }

        public int getCCItemStartOffset() {
            return this.ccItemStartOffset;
        }

        public HtmlParserResult getResult() {
            return this.result;
        }

        public AstNode getCurrentNode() {
            return this.currentNode;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public boolean isValueQuoted() {
            return this.valueQuoted;
        }
    }
}

