/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.util.Collections;
import java.util.List;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.modules.html.editor.api.Utils;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.BracesMatcherFactory;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;
import org.openide.util.Exceptions;

public class HtmlBracesMatching
implements BracesMatcher,
BracesMatcherFactory {
    private MatcherContext context;
    private static final String BLOCK_COMMENT_START = "<!--";
    private static final String BLOCK_COMMENT_END = "-->";
    static boolean testMode = false;

    public HtmlBracesMatching() {
        this(null);
    }

    private HtmlBracesMatching(MatcherContext matcherContext) {
        this.context = matcherContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findOrigin() throws InterruptedException, BadLocationException {
        int n = this.context.isSearchingBackward() ? this.context.getSearchOffset() : this.context.getSearchOffset() + 1;
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            Token token;
            if (!testMode && MatcherContext.isTaskCanceled()) {
                int[] nArray = null;
                return nArray;
            }
            TokenSequence<HTMLTokenId> tokenSequence = Utils.getJoinedHtmlSequence(this.context.getDocument(), n);
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.context.getDocument());
            if (tokenSequence.language() == HTMLTokenId.language()) {
                tokenSequence.move(n);
                if (this.context.isSearchingBackward() ? tokenSequence.movePrevious() : tokenSequence.moveNext()) {
                    if (this.context.isSearchingBackward() && tokenSequence.offset() + tokenSequence.token().length() < n) {
                        int[] nArray = null;
                        return nArray;
                    }
                    token = tokenSequence.token();
                    if (this.tokenInTag(token)) {
                        do {
                            Token token2;
                            if (!this.tokenInTag(token2 = tokenSequence.token())) {
                                int[] nArray = null;
                                return nArray;
                            }
                            if (token2.id() != HTMLTokenId.TAG_OPEN_SYMBOL) continue;
                            int n2 = -1;
                            while (tokenSequence.moveNext()) {
                                Token token3 = tokenSequence.token();
                                if (!this.tokenInTag(token3) || token3.id() == HTMLTokenId.TAG_OPEN_SYMBOL) {
                                    int[] nArray = null;
                                    return nArray;
                                }
                                if (token3.id() == HTMLTokenId.TAG_CLOSE_SYMBOL) {
                                    if ("/>".equals(((Object)token3.text()).toString())) {
                                        int[] nArray = null;
                                        return nArray;
                                    }
                                    int n3 = token2.offset(tokenHierarchy);
                                    int n4 = token3.offset(tokenHierarchy) + token3.length();
                                    if (n2 != -1) {
                                        int[] nArray = new int[]{n3, n4, n3, n2, n4 - 1, n4};
                                        return nArray;
                                    }
                                    int[] nArray = new int[]{n3, n4};
                                    return nArray;
                                }
                                if (token3.id() != HTMLTokenId.TAG_OPEN && token3.id() != HTMLTokenId.TAG_CLOSE) continue;
                                n2 = token3.offset(tokenHierarchy) + token3.length();
                            }
                            break;
                        } while (tokenSequence.movePrevious());
                    } else if (token.id() == HTMLTokenId.BLOCK_COMMENT) {
                        String string = ((Object)token.text()).toString();
                        if (string.startsWith(BLOCK_COMMENT_START) && this.context.getSearchOffset() < token.offset(tokenHierarchy) + BLOCK_COMMENT_START.length()) {
                            int[] nArray = new int[]{token.offset(tokenHierarchy), token.offset(tokenHierarchy) + BLOCK_COMMENT_START.length()};
                            return nArray;
                        }
                        if (string.endsWith(BLOCK_COMMENT_END) && this.context.getSearchOffset() >= token.offset(tokenHierarchy) + string.length() - BLOCK_COMMENT_END.length()) {
                            int[] nArray = new int[]{token.offset(tokenHierarchy) + token.length() - BLOCK_COMMENT_END.length(), token.offset(tokenHierarchy) + token.length()};
                            return nArray;
                        }
                    }
                }
            }
            token = null;
            return token;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    private boolean tokenInTag(Token token) {
        return token.id() == HTMLTokenId.TAG_CLOSE_SYMBOL || token.id() == HTMLTokenId.TAG_OPEN_SYMBOL || token.id() == HTMLTokenId.TAG_OPEN || token.id() == HTMLTokenId.TAG_CLOSE || token.id() == HTMLTokenId.WS || token.id() == HTMLTokenId.ARGUMENT || token.id() == HTMLTokenId.VALUE || token.id() == HTMLTokenId.VALUE_CSS || token.id() == HTMLTokenId.VALUE_JAVASCRIPT || token.id() == HTMLTokenId.OPERATOR || token.id() == HTMLTokenId.EOL;
    }

    public int[] findMatches() throws InterruptedException, BadLocationException {
        if (!testMode && MatcherContext.isTaskCanceled()) {
            return null;
        }
        final int n = this.context.isSearchingBackward() ? this.context.getSearchOffset() : this.context.getSearchOffset() + 1;
        final Source source = Source.create((Document)this.context.getDocument());
        if (source == null) {
            return null;
        }
        final int[][] nArrayArray = new int[1][];
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    if (!testMode && MatcherContext.isTaskCanceled()) {
                        return;
                    }
                    if (!source.getMimeType().equals("text/html")) {
                        resultIterator = Utils.getResultIterator(resultIterator, "text/html");
                    }
                    if (resultIterator == null) {
                        nArrayArray[0] = new int[]{n, n};
                        return;
                    }
                    HtmlParserResult htmlParserResult = (HtmlParserResult)resultIterator.getParserResult();
                    if (htmlParserResult == null) {
                        return;
                    }
                    int n6 = htmlParserResult.getSnapshot().getEmbeddedOffset(n);
                    AstNode astNode = htmlParserResult.findLeafTag(n6, false, !HtmlBracesMatching.this.context.isSearchingBackward());
                    if (astNode != null) {
                        if (astNode.type() == AstNode.NodeType.OPEN_TAG || astNode.type() == AstNode.NodeType.ENDTAG) {
                            if (astNode == null) {
                                nArrayArray[0] = null;
                            } else {
                                AstNode astNode2 = astNode.getMatchingTag();
                                if (astNode2 == null) {
                                    nArrayArray[0] = (int[])(astNode.needsToHaveMatchingTag() ? null : new int[]{n, n});
                                } else if (astNode2.type() == AstNode.NodeType.OPEN_TAG) {
                                    int n2 = astNode2.startOffset();
                                    int n3 = n2 + astNode2.name().length() + 1;
                                    int n4 = astNode2.endOffset() - 1;
                                    int n5 = astNode2.endOffset();
                                    nArrayArray[0] = HtmlBracesMatching.this.translate(new int[]{n2, n3, n4, n5}, (Parser.Result)htmlParserResult);
                                } else {
                                    nArrayArray[0] = HtmlBracesMatching.this.translate(new int[]{astNode2.startOffset(), astNode2.endOffset()}, (Parser.Result)htmlParserResult);
                                }
                            }
                        } else if (astNode.type() == AstNode.NodeType.COMMENT) {
                            if (n6 >= astNode.startOffset() && n6 <= astNode.startOffset() + HtmlBracesMatching.BLOCK_COMMENT_START.length()) {
                                nArrayArray[0] = HtmlBracesMatching.this.translate(new int[]{astNode.endOffset() - HtmlBracesMatching.BLOCK_COMMENT_END.length(), astNode.endOffset()}, (Parser.Result)htmlParserResult);
                            } else if (n6 >= astNode.endOffset() - HtmlBracesMatching.BLOCK_COMMENT_END.length() && n6 <= astNode.endOffset()) {
                                nArrayArray[0] = HtmlBracesMatching.this.translate(new int[]{astNode.startOffset(), astNode.startOffset() + HtmlBracesMatching.BLOCK_COMMENT_START.length()}, (Parser.Result)htmlParserResult);
                            }
                        }
                    }
                }
            });
        }
        catch (ParseException parseException) {
            Exceptions.printStackTrace((Throwable)parseException);
        }
        return nArrayArray[0];
    }

    private int[] translate(int[] nArray, Parser.Result result) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = result.getSnapshot().getOriginalOffset(nArray[i]);
        }
        return nArray2;
    }

    public BracesMatcher createMatcher(final MatcherContext matcherContext) {
        final HtmlBracesMatching[] htmlBracesMatchingArray = new HtmlBracesMatching[]{null};
        matcherContext.getDocument().render(new Runnable(){

            public void run() {
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)matcherContext.getDocument());
                if (tokenHierarchy.tokenSequence().language() == HTMLTokenId.language()) {
                    htmlBracesMatchingArray[0] = new HtmlBracesMatching(matcherContext);
                    return;
                }
                List list = tokenHierarchy.embeddedTokenSequences(matcherContext.getSearchOffset(), matcherContext.isSearchingBackward());
                for (TokenSequence tokenSequence : list) {
                    Language language = tokenSequence.language();
                    if (language != HTMLTokenId.language()) continue;
                    htmlBracesMatchingArray[0] = new HtmlBracesMatching(matcherContext);
                    return;
                }
            }
        });
        return htmlBracesMatchingArray[0];
    }
}

