/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.projectimport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.actions.CMakeAction;
import org.netbeans.modules.cnd.actions.MakeAction;
import org.netbeans.modules.cnd.actions.QMakeAction;
import org.netbeans.modules.cnd.actions.ShellRunAction;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.execution.ExecutionListener;
import org.netbeans.modules.cnd.builds.ImportUtils;
import org.netbeans.modules.cnd.execution.ShellExecSupport;
import org.netbeans.modules.cnd.execution41.org.openide.loaders.ExecutionSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;
import org.openide.windows.InputOutput;

public class ReconfigureProject {
    private static boolean TRACE = Boolean.getBoolean("cnd.discovery.trace.projectimport");
    private Logger logger = Logger.getLogger("org.netbeans.modules.cnd.discovery.projectimport.ImportProject");
    private final Project makeProject;
    private final ConfigurationDescriptorProvider pdp;
    private final boolean isSunCompiler;
    private CompilerSet compilerSet;
    private DataObject configure;
    private DataObject cmake;
    private DataObject qmake;
    private DataObject make;
    private String cFlags;
    private String cxxFlags;
    private String linkerFlags;
    private AtomicBoolean canceled = new AtomicBoolean(false);
    private Future<Integer> lastTask;
    private Set<ExecutionListener> listeners = new WeakSet();
    private InputOutput tab;

    public ReconfigureProject(Project project) {
        if (TRACE) {
            this.logger.setLevel(Level.ALL);
        }
        this.makeProject = project;
        this.pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        assert (this.pdp != null && this.pdp.gotDescriptor());
        MakeConfiguration makeConfiguration = this.pdp.getConfigurationDescriptor().getActiveConfiguration();
        assert (makeConfiguration != null && makeConfiguration.getConfigurationType().getValue() == 0);
        CompilerSet2Configuration compilerSet2Configuration = makeConfiguration.getCompilerSet();
        this.compilerSet = compilerSet2Configuration.getCompilerSet();
        assert (this.compilerSet != null);
        this.isSunCompiler = this.compilerSet.isSunCompiler();
        Folder folder = this.pdp.getConfigurationDescriptor().getExternalFileItems();
        for (Item item : folder.getAllItemsAsArray()) {
            DataObject dataObject = item.getDataObject();
            if (dataObject == null) continue;
            String string = dataObject.getPrimaryFile().getMIMEType();
            if ("text/sh".equals(string)) {
                if (!"configure".equals(dataObject.getPrimaryFile().getName())) continue;
                this.configure = dataObject;
                continue;
            }
            if ("text/x-cmake".equals(string)) {
                this.cmake = dataObject;
                continue;
            }
            if ("text/x-qtproject".equals(string)) {
                this.qmake = dataObject;
                continue;
            }
            if (!"text/x-make".equals(string)) continue;
            if (dataObject.getPrimaryFile().hasExt("mk")) {
                if (this.make != null) continue;
                this.make = dataObject;
                continue;
            }
            this.make = dataObject;
        }
    }

    public void addExecutionListener(ExecutionListener executionListener) {
        this.listeners.add(executionListener);
    }

    public void removeExecutionListener(ExecutionListener executionListener) {
        this.listeners.remove(executionListener);
    }

    private String escapeFlags(String string) {
        if (!(string.indexOf(32) <= 0 && string.indexOf(61) <= 0 || string.startsWith("\""))) {
            string = "\"" + string + "\"";
        }
        return string;
    }

    public void reconfigure(final String string, final String string2, final String string3, final InputOutput inputOutput) {
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    ReconfigureProject.this.reconfigure(string, string2, string3, ReconfigureProject.this.getRestOptions(), true, inputOutput);
                }
            });
        } else {
            this.reconfigure(string, string2, string3, this.getRestOptions(), true, inputOutput);
        }
    }

    public void reconfigure(String string, String string2, String string3, String string4, boolean bl, InputOutput inputOutput) {
        this.tab = inputOutput;
        if (bl) {
            final AtomicInteger atomicInteger = new AtomicInteger();
            final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            ExecutionListener executionListener = new ExecutionListener(){

                public void executionStarted(int n) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void executionFinished(int n) {
                    atomicInteger.set(n);
                    atomicBoolean.set(true);
                    AtomicBoolean atomicBoolean2 = atomicBoolean;
                    synchronized (atomicBoolean2) {
                        atomicBoolean.notifyAll();
                    }
                }
            };
            this.addExecutionListener(executionListener);
            this._reconfigure(string, string2, string3, string4);
            AtomicBoolean atomicBoolean2 = atomicBoolean;
            synchronized (atomicBoolean2) {
                while (true) {
                    try {
                        do {
                            atomicBoolean.wait();
                        } while (!atomicBoolean.get());
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        Exceptions.printStackTrace((Throwable)interruptedException);
                        continue;
                    }
                    break;
                }
            }
        }
        this._reconfigure(string, string2, string3, string4);
    }

    private void _reconfigure(String string, String string2, String string3, String string4) {
        string = this.escapeFlags(string);
        string2 = this.escapeFlags(string2);
        string3 = this.escapeFlags(string3);
        this.cFlags = string;
        this.cxxFlags = string2;
        this.linkerFlags = string3;
        if (this.cmake != null && this.make != null) {
            Object object;
            String string5 = this.getConfigureArguments(this.cmake.getPrimaryFile().getPath(), string4, string, string2, string3, this.isSunCompiler());
            ExecutionSupport executionSupport = (ExecutionSupport)this.cmake.getNodeDelegate().getCookie(ExecutionSupport.class);
            if (executionSupport != null) {
                try {
                    object = ImportUtils.parseEnvironment((String)string5);
                    for (String string6 : ImportUtils.quoteList((List)object)) {
                        int n = string5.indexOf(string6);
                        if (n < 0) continue;
                        string5 = string5.substring(0, n) + string5.substring(n + string6.length());
                    }
                    executionSupport.setArguments(new String[]{string5});
                    executionSupport.setEnvironmentVariables(object.toArray(new String[object.size()]));
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            object = new ExecutionListener(){

                public void executionStarted(int n) {
                    for (ExecutionListener executionListener : ReconfigureProject.this.listeners) {
                        executionListener.executionStarted(n);
                    }
                }

                public void executionFinished(int n) {
                    if (n == 0) {
                        ReconfigureProject.this.postClean(false);
                    } else {
                        for (ExecutionListener executionListener : ReconfigureProject.this.listeners) {
                            executionListener.executionFinished(n);
                        }
                    }
                }
            };
            if (TRACE) {
                this.logger.log(Level.INFO, "#" + this.cmake.getPrimaryFile().getPath() + " " + string5);
            }
            if (this.canceled.get()) {
                object.executionFinished(-1);
            } else {
                this.lastTask = CMakeAction.performAction((Node)this.cmake.getNodeDelegate(), (ExecutionListener)object, null, (Project)this.makeProject, (InputOutput)this.tab);
            }
        } else if (this.qmake != null && this.make != null) {
            String string7 = this.getConfigureArguments(this.qmake.getPrimaryFile().getPath(), string4, string, string2, string3, this.isSunCompiler());
            ExecutionSupport executionSupport = (ExecutionSupport)this.qmake.getNodeDelegate().getCookie(ExecutionSupport.class);
            if (executionSupport != null) {
                try {
                    executionSupport.setArguments(new String[]{string7});
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            ExecutionListener executionListener = new ExecutionListener(){

                public void executionStarted(int n) {
                    for (ExecutionListener executionListener : ReconfigureProject.this.listeners) {
                        executionListener.executionStarted(n);
                    }
                }

                public void executionFinished(int n) {
                    if (n == 0) {
                        ReconfigureProject.this.postClean(false);
                    } else {
                        for (ExecutionListener executionListener : ReconfigureProject.this.listeners) {
                            executionListener.executionFinished(n);
                        }
                    }
                }
            };
            if (TRACE) {
                this.logger.log(Level.INFO, "#" + this.qmake.getPrimaryFile().getPath() + " " + string7);
            }
            if (this.canceled.get()) {
                executionListener.executionFinished(-1);
            } else {
                this.lastTask = QMakeAction.performAction((Node)this.qmake.getNodeDelegate(), (ExecutionListener)executionListener, null, (Project)this.makeProject, (InputOutput)this.tab);
            }
        } else if (this.configure != null && this.make != null) {
            Object object;
            String string8 = this.getConfigureArguments(this.configure.getPrimaryFile().getPath(), string4, string, string2, string3, this.isSunCompiler());
            ShellExecSupport shellExecSupport = (ShellExecSupport)this.configure.getNodeDelegate().getCookie(ShellExecSupport.class);
            if (shellExecSupport != null) {
                try {
                    shellExecSupport.setArguments(new String[]{string8});
                    object = ImportUtils.parseEnvironment((String)string8);
                    shellExecSupport.setEnvironmentVariables(object.toArray(new String[object.size()]));
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            object = new ExecutionListener(){

                public void executionStarted(int n) {
                    for (ExecutionListener executionListener : ReconfigureProject.this.listeners) {
                        executionListener.executionStarted(n);
                    }
                }

                public void executionFinished(int n) {
                    if (n == 0) {
                        ReconfigureProject.this.postClean(false);
                    } else {
                        for (ExecutionListener executionListener : ReconfigureProject.this.listeners) {
                            executionListener.executionFinished(n);
                        }
                    }
                }
            };
            if (TRACE) {
                this.logger.log(Level.INFO, "#" + this.configure.getPrimaryFile().getPath() + " " + string8);
            }
            if (this.canceled.get()) {
                object.executionFinished(-1);
            } else {
                this.lastTask = ShellRunAction.performAction((Node)this.configure.getNodeDelegate(), (ExecutionListener)object, null, (Project)this.makeProject, (InputOutput)this.tab);
            }
        } else if (this.make != null) {
            this.postClean(true);
        } else assert (false);
    }

    private void postClean(final boolean bl) {
        ExecutionListener executionListener = new ExecutionListener(){

            public void executionStarted(int n) {
                if (bl) {
                    for (ExecutionListener executionListener : ReconfigureProject.this.listeners) {
                        executionListener.executionStarted(n);
                    }
                }
            }

            public void executionFinished(int n) {
                ReconfigureProject.this.postMake();
            }
        };
        if (TRACE) {
            this.logger.log(Level.INFO, "#make -f " + this.make.getPrimaryFile().getPath() + " clean");
        }
        if (this.canceled.get()) {
            executionListener.executionFinished(-1);
        } else {
            this.lastTask = MakeAction.execute((Node)this.make.getNodeDelegate(), (String)"clean", (ExecutionListener)executionListener, null, (Project)this.makeProject, null, (InputOutput)this.tab);
        }
    }

    private void postMake() {
        String string = this.getConfigureArguments(this.make.getPrimaryFile().getPath(), null, this.cFlags, this.cxxFlags, this.linkerFlags, this.isSunCompiler());
        if (TRACE) {
            this.logger.log(Level.INFO, "#make -f " + this.make.getPrimaryFile().getPath());
        }
        Node node = this.make.getNodeDelegate();
        ExecutionSupport executionSupport = (ExecutionSupport)node.getCookie(ExecutionSupport.class);
        List list = ImportUtils.parseEnvironment((String)string);
        if (executionSupport != null) {
            try {
                executionSupport.setEnvironmentVariables(list.toArray(new String[list.size()]));
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        ExecutionListener executionListener = new ExecutionListener(){

            public void executionStarted(int n) {
            }

            public void executionFinished(int n) {
                for (ExecutionListener executionListener : ReconfigureProject.this.listeners) {
                    executionListener.executionFinished(n);
                }
            }
        };
        if (this.canceled.get()) {
            executionListener.executionFinished(-1);
        } else {
            this.lastTask = MakeAction.execute((Node)node, (String)"", (ExecutionListener)executionListener, null, (Project)this.makeProject, (List)list, (InputOutput)this.tab);
        }
    }

    public void cancel() {
        this.canceled.set(true);
        Future<Integer> future = this.lastTask;
        if (future != null) {
            future.cancel(true);
        }
    }

    private String getConfigureArguments(String string, String string2, String string3, String string4, String string5, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null && string2.length() > 0) {
            stringBuilder.append(string2);
            stringBuilder.append(' ');
        }
        if (string.endsWith("CMakeLists.txt")) {
            stringBuilder.append(" -G \"Unix Makefiles\"");
            stringBuilder.append(" -DCMAKE_BUILD_TYPE=Debug");
            stringBuilder.append(" -DCMAKE_C_COMPILER=" + this.getCCompilerName());
            stringBuilder.append(" -DCMAKE_CXX_COMPILER=" + this.getCppCompilerName());
            stringBuilder.append(" -DCMAKE_C_FLAGS_DEBUG=" + string3);
            stringBuilder.append(" -DCMAKE_CXX_FLAGS_DEBUG=" + string4);
            stringBuilder.append(" -DCMAKE_EXE_LINKER_FLAGS_DEBUG=" + string5);
        } else if (string.endsWith(".pro")) {
            if (bl && Utilities.getOperatingSystem() == 8) {
                stringBuilder.append(" -spec solaris-cc");
            }
            stringBuilder.append(" QMAKE_CC=" + this.getCCompilerName());
            stringBuilder.append(" QMAKE_CXX=" + this.getCppCompilerName());
            stringBuilder.append(" QMAKE_CFLAGS=" + string3);
            stringBuilder.append(" QMAKE_CXXFLAGS=" + string4);
            stringBuilder.append(" QMAKE_LDFLAGS=" + string5);
        } else {
            stringBuilder.append(" CC=" + this.getCCompilerName());
            stringBuilder.append(" CXX=" + this.getCppCompilerName());
            stringBuilder.append(" CFLAGS=" + string3);
            stringBuilder.append(" CXXFLAGS=" + string4);
            stringBuilder.append(" LDFLAGS=" + string5);
        }
        return stringBuilder.toString();
    }

    public CompilerOptions getLastCompilerOptions() {
        String string = this.getLastFlags();
        if (string == null) {
            return null;
        }
        DataObject dataObject = this.getImportant();
        if (dataObject == null) {
            return null;
        }
        String string2 = dataObject.getPrimaryFile().getMIMEType();
        CompilerOptions compilerOptions = new CompilerOptions();
        if ("text/sh".equals(string2)) {
            compilerOptions.CFlags = this.getFlags(string, "CFLAGS=");
            compilerOptions.CppFlags = this.getFlags(string, "CXXFLAGS=");
            compilerOptions.CCompiler = this.getFlags(string, "CC=");
            compilerOptions.CppCompiler = this.getFlags(string, "CXX=");
            compilerOptions.LinkerFlags = this.getFlags(string, "LDFLAGS=");
        } else if ("text/x-cmake".equals(string2)) {
            compilerOptions.CFlags = this.getFlags(string, "-DCMAKE_C_FLAGS_DEBUG=");
            compilerOptions.CppFlags = this.getFlags(string, "-DCMAKE_CXX_FLAGS_DEBUG=");
            compilerOptions.CCompiler = this.getFlags(string, "-DCMAKE_C_COMPILER=");
            compilerOptions.CppCompiler = this.getFlags(string, "-DCMAKE_CXX_COMPILER=");
            compilerOptions.LinkerFlags = this.getFlags(string, "-DCMAKE_EXE_LINKER_FLAGS_DEBUG=");
        } else if ("text/x-qtproject".equals(string2)) {
            compilerOptions.CFlags = this.getFlags(string, "QMAKE_CFLAGS=");
            compilerOptions.CppFlags = this.getFlags(string, "QMAKE_CXXFLAGS=");
            compilerOptions.CCompiler = this.getFlags(string, "QMAKE_CC=");
            compilerOptions.CppCompiler = this.getFlags(string, "QMAKE_CXX=");
            compilerOptions.LinkerFlags = this.getFlags(string, "QMAKE_LDFLAGS=");
        } else if ("text/x-make".equals(string2)) {
            compilerOptions.CFlags = this.getFlags(string, "CFLAGS=");
            compilerOptions.CppFlags = this.getFlags(string, "CXXFLAGS=");
            compilerOptions.CCompiler = this.getFlags(string, "CC=");
            compilerOptions.CppCompiler = this.getFlags(string, "CXX=");
            compilerOptions.LinkerFlags = this.getFlags(string, "LDFLAGS=");
        }
        return compilerOptions;
    }

    public String getRestOptions() {
        String string = this.getLastFlags();
        if (string == null) {
            return "";
        }
        DataObject dataObject = this.getImportant();
        if (dataObject == null) {
            return "";
        }
        String string2 = dataObject.getPrimaryFile().getMIMEType();
        if ("text/sh".equals(string2)) {
            string = this.removeFlag(string, "CFLAGS=", false);
            string = this.removeFlag(string, "CXXFLAGS=", false);
            string = this.removeFlag(string, "CC=", false);
            string = this.removeFlag(string, "CXX=", false);
            string = this.removeFlag(string, "LDFLAGS=", false);
        } else if ("text/x-cmake".equals(string2)) {
            string = this.removeFlag(string, "-DCMAKE_BUILD_TYPE=", false);
            string = this.removeFlag(string, "-DCMAKE_C_FLAGS_DEBUG=", false);
            string = this.removeFlag(string, "-DCMAKE_CXX_FLAGS_DEBUG=", false);
            string = this.removeFlag(string, "-DCMAKE_C_COMPILER=", false);
            string = this.removeFlag(string, "-DCMAKE_CXX_COMPILER=", false);
            string = this.removeFlag(string, "-DCMAKE_EXE_LINKER_FLAGS_DEBUG=", false);
            string = this.removeFlag(string, "-G", false);
        } else if ("text/x-qtproject".equals(string2)) {
            string = this.removeFlag(string, "QMAKE_CFLAGS=", false);
            string = this.removeFlag(string, "QMAKE_CXXFLAGS=", false);
            string = this.removeFlag(string, "QMAKE_CC=", false);
            string = this.removeFlag(string, "QMAKE_CXX=", false);
            string = this.removeFlag(string, "QMAKE_LDFLAGS=", false);
            string = this.removeFlag(string, "-spec solaris-cc", true);
        } else if ("text/x-make".equals(string2)) {
            return "";
        }
        return string.trim();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String removeFlag(String string, String string2, boolean bl) {
        int n = string.indexOf(string2);
        if (n < 0) return string.trim();
        if (string2.charAt(string2.length() - 1) == '=') {
            String string3 = string.substring(n + string2.length());
            if (string3.startsWith("\"")) {
                int n2 = string3.indexOf(34, 1);
                if (n2 <= 0) return string.trim();
                return string.substring(0, n) + string3.substring(n2 + 1);
            }
            int n3 = string3.indexOf(32, 1);
            if (n3 <= 0) return string.substring(0, n);
            return string.substring(0, n) + string3.substring(n3 + 1);
        }
        String string4 = string.substring(n + string2.length());
        if (string4.startsWith(" ")) {
            if (bl) {
                return string.substring(0, n) + string4;
            }
            if ((string4 = string4.substring(1)).startsWith("\"")) {
                int n4 = string4.indexOf(34, 1);
                if (n4 <= 0) return string.trim();
                return string.substring(0, n) + string4.substring(n4 + 1);
            }
            int n5 = string4.indexOf(32, 1);
            if (n5 <= 0) return string.substring(0, n);
            return string.substring(0, n) + string4.substring(n5 + 1);
        }
        if (string4.length() != 0) return string.trim();
        return string.substring(0, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getFlags(String string, String string2) {
        int n = string.indexOf(string2);
        if (n < 0) return null;
        if (string2.charAt(string2.length() - 1) == '=') {
            String string3 = string.substring(n + string2.length());
            if (string3.startsWith("\"")) {
                int n2 = string3.indexOf(34, 1);
                if (n2 <= 0) return null;
                return string3.substring(1, n2);
            }
            int n3 = string3.indexOf(32, 1);
            if (n3 <= 0) return string3;
            return string3.substring(0, n3);
        }
        String string4 = string.substring(n + string2.length());
        if (string4.startsWith(" ")) {
            if ((string4 = string4.substring(1)).startsWith("\"")) {
                int n4 = string4.indexOf(34, 1);
                if (n4 <= 0) return null;
                return string4.substring(1, n4);
            }
            int n5 = string4.indexOf(32, 1);
            if (n5 <= 0) return string4;
            return string4.substring(0, n5);
        }
        if (string4.length() != 0) return null;
        return "";
    }

    public boolean isSunCompiler() {
        return this.isSunCompiler;
    }

    public CompilerSet getCompilerSet() {
        return this.compilerSet;
    }

    private String getCCompilerName() {
        String string = this.getToolPath(0);
        if (string == null) {
            if (this.isSunCompiler()) {
                return "cc";
            }
            return "gcc";
        }
        return string;
    }

    private String getCppCompilerName() {
        String string = this.getToolPath(1);
        if (string == null) {
            if (this.isSunCompiler()) {
                return "CC";
            }
            return "g++";
        }
        return string;
    }

    private String getToolPath(int n) {
        Tool tool = this.compilerSet.findTool(n);
        if (tool == null) {
            return null;
        }
        return this.escapeFlags(tool.getPath());
    }

    public DataObject getImportant() {
        if (this.cmake != null && this.make != null) {
            return this.cmake;
        }
        if (this.qmake != null && this.make != null) {
            return this.qmake;
        }
        if (this.configure != null && this.make != null) {
            return this.configure;
        }
        if (this.make != null) {
            return this.make;
        }
        return null;
    }

    public String getLastFlags() {
        String[] stringArray;
        ExecutionSupport executionSupport;
        if (this.cmake != null && this.make != null) {
            String[] stringArray2;
            ExecutionSupport executionSupport2 = (ExecutionSupport)this.cmake.getNodeDelegate().getCookie(ExecutionSupport.class);
            if (executionSupport2 != null && (stringArray2 = executionSupport2.getArguments()) != null && stringArray2.length > 0) {
                return stringArray2[0];
            }
        } else if (this.qmake != null && this.make != null) {
            String[] stringArray3;
            ExecutionSupport executionSupport3 = (ExecutionSupport)this.qmake.getNodeDelegate().getCookie(ExecutionSupport.class);
            if (executionSupport3 != null && (stringArray3 = executionSupport3.getArguments()) != null && stringArray3.length > 0) {
                return stringArray3[0];
            }
        } else if (this.configure != null && this.make != null) {
            String[] stringArray4;
            ShellExecSupport shellExecSupport = (ShellExecSupport)this.configure.getNodeDelegate().getCookie(ShellExecSupport.class);
            if (shellExecSupport != null && (stringArray4 = shellExecSupport.getArguments()) != null && stringArray4.length > 0) {
                return stringArray4[0];
            }
        } else if (this.make != null && (executionSupport = (ExecutionSupport)this.make.getNodeDelegate().getCookie(ExecutionSupport.class)) != null && (stringArray = executionSupport.getEnvironmentVariables()) != null && stringArray.length > 0) {
            List list = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                list.add(stringArray[i]);
            }
            list = ImportUtils.quoteList(list);
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : list) {
                stringBuilder.append(string).append(' ');
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static final class CompilerOptions {
        public String CFlags;
        public String CppFlags;
        public String CCompiler;
        public String CppCompiler;
        public String LinkerFlags;
    }
}

