/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.project;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.api.Configuration;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.api.KnownProject;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectImpl;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.discovery.project.PathCache;
import org.netbeans.modules.cnd.discovery.project.ProjectCreator;
import org.netbeans.modules.cnd.discovery.project.SolarisLogReader;
import org.netbeans.modules.cnd.discovery.wizard.SelectConfigurationPanel;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.api.ProjectConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.tree.ConfigurationFactory;
import org.netbeans.modules.cnd.discovery.wizard.tree.ProjectConfigurationImpl;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSolaris
extends KnownProject {
    private static final boolean TRACE = true;
    static final boolean READ_MAP_FILE_VERS = false;
    public static final String PROJECT_NAME = "open-solaris";
    public static final String LOG_FILE = "nightly-log";
    public static final String BUILD_SCRIPT = "build-script";
    private String root;
    private String nb_root;
    private String nightly_log;
    private String buildScript;
    private List<SourceFileProperties> sources;
    private List<SolarisLogReader.InstallLine> copyHeader;
    TreeMap<String, Set<String>> mapFiles;
    TreeMap<String, Set<String>> libraries;
    Map<String, String> secondLevel = new HashMap<String, String>();

    public OpenSolaris() {
        this.secondLevel.put("lib/gss_mechs/", "os.lib.gss_mechs.");
        this.secondLevel.put("lib/fm/", "os.lib.fm.");
        this.secondLevel.put("lib/hal/", "os.lib.hal.");
        this.secondLevel.put("lib/lvm/", "os.lib.lvm.");
        this.secondLevel.put("lib/libkfm/", "os.lib.libkfm.");
        this.secondLevel.put("lib/openssl/", "os.lib.openssl.");
        this.secondLevel.put("lib/policykit/", "os.lib.policykit.");
        this.secondLevel.put("lib/print/", "os.lib.print.");
        this.secondLevel.put("lib/scsi/", "os.lib.scsi.");
        this.secondLevel.put("lib/smbsrv/", "os.lib.smbsrv.");
        this.secondLevel.put("lib/udapl/", "os.lib.udapl.");
        this.secondLevel.put("cmd/sgs/", "os.cmd.sgs.");
        this.secondLevel.put("cmd/perl/", "os.cmd.perl.");
        this.secondLevel.put("cmd/ssh/", "os.cmd.ssh.");
        this.secondLevel.put("cmd/xntpd/", "os.cmd.xntpd.");
    }

    @Override
    public boolean canCreate(Map<String, String> map) {
        if (!PROJECT_NAME.equals(map.get("project"))) {
            return false;
        }
        this.root = map.get("root");
        if (this.root == null) {
            return false;
        }
        this.nb_root = map.get("netbeans-project");
        if (this.nb_root == null) {
            return false;
        }
        this.nightly_log = map.get(LOG_FILE);
        if (this.nightly_log == null) {
            this.nightly_log = this.findMakeLog(this.root);
            if (this.nightly_log == null) {
                return false;
            }
        } else {
            File file = new File(this.nightly_log);
            if (!file.exists() || file.isDirectory()) {
                return false;
            }
        }
        this.buildScript = map.get(BUILD_SCRIPT);
        if (this.buildScript == null) {
            this.buildScript = "opensolaris.sh";
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean create(Map<String, String> map) {
        try {
            System.out.println(NbBundle.getMessage(OpenSolaris.class, (String)"CREATE_PROJECT"));
            System.out.println("project=open-solaris");
            System.out.println("root=" + this.root);
            System.out.println("netbeans-project=" + this.nb_root);
            System.out.println("nightly-log=" + this.nightly_log);
            System.out.println("build-script=" + this.buildScript);
            System.out.println(NbBundle.getMessage(OpenSolaris.class, (String)"SCANNING_LOG"));
            this.sources = this.scan(this.nightly_log, this.root);
            if (this.sources == null || this.sources.size() == 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.createImpl();
            return bl;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            PathCache.dispose();
        }
    }

    private void createFolders(Map<String, ProjectSources> map) throws IOException {
        FileObject fileObject = ProjectCreator.createProjectDir(new File(this.nb_root));
        for (Map.Entry<String, ProjectSources> entry : map.entrySet()) {
            StringTokenizer stringTokenizer = new StringTokenizer(entry.getKey(), "/");
            FileObject fileObject2 = fileObject;
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                boolean bl = false;
                for (FileObject fileObject3 : fileObject2.getChildren()) {
                    if (!string.equals(fileObject3.getNameExt())) continue;
                    fileObject2 = fileObject3;
                    bl = true;
                    break;
                }
                if (bl) continue;
                fileObject2 = fileObject2.createFolder(string);
            }
        }
    }

    private String getSecondlevel(String string) {
        for (String string2 : this.secondLevel.keySet()) {
            if (!string.startsWith(string2)) continue;
            return string2;
        }
        return null;
    }

    private boolean createImpl() throws IOException {
        String string;
        File file = new File(this.root + "/proto");
        if (!file.exists()) {
            System.out.println(NbBundle.getMessage(OpenSolaris.class, (String)"INSTALLING_PROTO"));
            for (SolarisLogReader.InstallLine object2 : this.copyHeader) {
                object2.install();
            }
        }
        String string2 = this.root + "/usr/src/";
        TreeMap<String, ProjectSources> treeMap = new TreeMap<String, ProjectSources>();
        for (SourceFileProperties sourceFileProperties : this.sources) {
            String string3 = sourceFileProperties.getCompilePath();
            if (!string3.startsWith(string2)) continue;
            String string4 = string3.substring(string2.length());
            if (this.getSecondlevel(string4) != null) {
                String string5 = this.getSecondlevel(string4);
                string = string4.substring(string5.length());
                int n = string.indexOf(47);
                if (n > 0) {
                    this.addFolder(treeMap, string5 + string.substring(0, n), string.substring(0, n), sourceFileProperties);
                    continue;
                }
                if (string.length() <= 0) continue;
                this.addFolder(treeMap, string5 + string, string, sourceFileProperties);
                continue;
            }
            if (string4.startsWith("cmd/")) {
                String string6 = string4.substring(4);
                int n = string6.indexOf(47);
                if (n > 0) {
                    this.addFolder(treeMap, "cmd/" + string6.substring(0, n), string6.substring(0, n), sourceFileProperties);
                    continue;
                }
                if (string6.length() <= 0) continue;
                this.addFolder(treeMap, "cmd/" + string6, string6, sourceFileProperties);
                continue;
            }
            if (string4.startsWith("lib/")) {
                String string7 = string4.substring(4);
                int n = string7.indexOf(47);
                if (n > 0) {
                    this.addFolder(treeMap, "lib/" + string7.substring(0, n), string7.substring(0, n), sourceFileProperties);
                    continue;
                }
                if (string7.length() <= 0) continue;
                this.addFolder(treeMap, "lib/" + string7, string7, sourceFileProperties);
                continue;
            }
            int n = string4.indexOf(47);
            if (n > 0) {
                this.addFolder(treeMap, string4.substring(0, n), string4.substring(0, n), sourceFileProperties);
                continue;
            }
            this.addFolder(treeMap, string4, string4, sourceFileProperties);
        }
        this.createFolders(treeMap);
        Set set = treeMap.keySet();
        for (Map.Entry entry : treeMap.entrySet()) {
            String string8 = (String)string2 + (String)entry.getKey();
            string = this.nb_root + "/" + (String)entry.getKey();
            String string9 = ((ProjectSources)entry.getValue()).name;
            String string10 = ((ProjectSources)entry.getValue()).name;
            if (this.getSecondlevel((String)entry.getKey()) != null) {
                String string11 = this.getSecondlevel((String)entry.getKey());
                string10 = this.secondLevel.get(string11) + string10;
            } else {
                string10 = ((String)entry.getKey()).startsWith("cmd/") ? "os.cmd." + string10 : (((String)entry.getKey()).startsWith("lib/") ? "os.lib." + string10 : "os." + string10);
            }
            System.out.println(NbBundle.getMessage(OpenSolaris.class, (String)"CREATING_PROJECT", (Object)string));
            this.createImpl(string8, string, string9, string10, set, ((ProjectSources)entry.getValue()).myFileProperties);
        }
        System.out.println(NbBundle.getMessage(OpenSolaris.class, (String)"CREATING_COMMANDS", (Object)this.nb_root));
        this.createImpl((String)string2 + "cmd", this.nb_root + "/commands", "commands", "os.commands", set, this.sources);
        System.out.println(NbBundle.getMessage(OpenSolaris.class, (String)"CREATING_LIBRARIES", (Object)this.nb_root));
        this.createImpl((String)string2 + "lib", this.nb_root + "/libraries", "libraries", "os.libraries", set, this.sources);
        System.out.println(NbBundle.getMessage(OpenSolaris.class, (String)"CREATING_SOURCES", (Object)this.nb_root));
        this.createImpl(this.root + "/usr/src", this.nb_root + "/sources", "sources", "os.sources", set, this.sources);
        return true;
    }

    private void addFolder(Map<String, ProjectSources> map, String string, String string2, SourceFileProperties sourceFileProperties) {
        ProjectSources projectSources = map.get(string);
        if (projectSources == null) {
            projectSources = new ProjectSources(string2);
            map.put(string, projectSources);
        }
        projectSources.myFileProperties.add(sourceFileProperties);
    }

    private boolean createImpl(String string, String string2, String string3, String string4, Set<String> set, List<SourceFileProperties> list) {
        DiscoveryProviderImpl discoveryProviderImpl = new DiscoveryProviderImpl(list, string);
        DiscoveryDescriptorImpl discoveryDescriptorImpl = new DiscoveryDescriptorImpl(null, discoveryProviderImpl, string);
        ProjectCreator projectCreator = new ProjectCreator(discoveryDescriptorImpl);
        projectCreator.init(string2, string, string + "/Makefile", this.buildScript);
        try {
            projectCreator.createProject(string3, string4, set, this.getLibraries(string4, string, string2));
            this.createGlobalList(string, string2, list);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
        return true;
    }

    private Set<String> getLibraries(String string, String string2, String string3) {
        HashSet<String> hashSet = new HashSet<String>();
        if (string.indexOf(".sources") > 0 || string.indexOf(".libraries") > 0 || string.indexOf(".uts") > 0 || string.indexOf(".commands") > 0) {
            return hashSet;
        }
        SortedMap<String, Set<String>> sortedMap = this.libraries.subMap(string2, string2 + "/z");
        for (Map.Entry<String, Set<String>> entry : sortedMap.entrySet()) {
            for (String string4 : entry.getValue()) {
                hashSet.add(string4);
            }
        }
        if (hashSet.size() > 0) {
            System.out.println(NbBundle.getMessage(OpenSolaris.class, (String)"REQUIRED_PROJECTS", (Object)("" + hashSet)));
        }
        return hashSet;
    }

    private void createGlobalList(String string, String string2, List<SourceFileProperties> list) {
        if (this.mapFiles != null) {
            Properties properties = new Properties();
            SortedMap<String, Set<String>> sortedMap = this.mapFiles.subMap(string, string + "/z");
            for (Map.Entry<String, Set<String>> entry : sortedMap.entrySet()) {
                for (String string3 : entry.getValue()) {
                    properties.put(string3, "");
                }
            }
            if (properties.size() == 0) {
                return;
            }
            try {
                System.out.println(NbBundle.getMessage(OpenSolaris.class, (String)"WRITING_GLOBALS", (Object)("" + properties.size())));
                this.grepDefinitions(properties, list);
                FileOutputStream fileOutputStream = new FileOutputStream(string2 + "/nbproject/private/globals.xml");
                properties.storeToXML(fileOutputStream, "Globals");
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private void grepDefinitions(Properties properties, List<SourceFileProperties> list) {
        for (SourceFileProperties sourceFileProperties : list) {
            String string = sourceFileProperties.getItemPath();
            File file = new File(string);
            if (!file.exists() || !file.canRead() || file.isDirectory()) continue;
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                int n = 0;
                while ((string2 = bufferedReader.readLine()) != null) {
                    String string3;
                    int n2;
                    char c;
                    ++n;
                    if (string2.length() == 0 || !Character.isLetter(c = string2.charAt(0)) && c != '_' || (n2 = string2.indexOf(40)) < 0 || !properties.containsKey(string3 = string2.substring(0, n2).trim())) continue;
                    properties.put(string3, string + ":" + n);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private List<SourceFileProperties> scan(String string, String string2) {
        SolarisLogReader solarisLogReader = new SolarisLogReader(string, string2);
        List<SourceFileProperties> list = solarisLogReader.getResults();
        this.copyHeader = solarisLogReader.getInstalls();
        this.libraries = solarisLogReader.getLibraries();
        return list;
    }

    private String findMakeLog(String string) {
        String string2 = null;
        String string3 = string + "/log";
        File file = new File(string3);
        if (file.exists() && file.isDirectory() && file.canRead()) {
            block0: for (File file2 : file.listFiles()) {
                if (!file2.exists() || !file2.isDirectory() || !file2.canRead()) continue;
                for (File file3 : file2.listFiles()) {
                    String string4;
                    String string5 = file3.getAbsolutePath();
                    if (!string5.endsWith("/nightly.log")) continue;
                    if (string2 == null) {
                        string2 = string5;
                        continue block0;
                    }
                    String string6 = string2.substring(0, string2.lastIndexOf("/nightly.log"));
                    if (string6.compareTo(string4 = string5.substring(0, string5.lastIndexOf("/nightly.log"))) >= 0) continue block0;
                    string2 = string5;
                    continue block0;
                }
            }
            return string2;
        }
        return null;
    }

    public static class ProjectSources {
        private List<SourceFileProperties> myFileProperties = new ArrayList<SourceFileProperties>();
        private String name;

        private ProjectSources(String string) {
            this.name = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DiscoveryProviderImpl
    implements DiscoveryProvider {
        private List<SourceFileProperties> sources;
        private String root;

        public DiscoveryProviderImpl(List<SourceFileProperties> list, String string) {
            this.sources = list;
            this.root = string;
        }

        @Override
        public String getID() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> getPropertyKeys() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public ProviderProperty getProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void clean() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isApplicable(ProjectProxy projectProxy) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int canAnalyze(ProjectProxy projectProxy) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<Configuration> analyze(ProjectProxy projectProxy, Progress progress) {
            ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
            Configuration configuration = new Configuration(){
                private List<SourceFileProperties> myFileProperties;
                private List<String> myIncludedFiles;

                @Override
                public List<ProjectProperties> getProjectConfiguration() {
                    return ProjectImpl.divideByLanguage(this.getSourcesConfiguration());
                }

                private List<SourceFileProperties> getSourceFileProperties() {
                    ArrayList<SourceFileProperties> arrayList = new ArrayList<SourceFileProperties>();
                    HashSet<String> hashSet = new HashSet<String>();
                    for (SourceFileProperties sourceFileProperties : DiscoveryProviderImpl.this.sources) {
                        File file;
                        String string;
                        if (!sourceFileProperties.getCompilePath().startsWith(DiscoveryProviderImpl.this.root) || hashSet.contains(string = CndFileUtils.normalizeFile((File)(file = new File(sourceFileProperties.getItemPath()))).getAbsolutePath())) continue;
                        arrayList.add(sourceFileProperties);
                        hashSet.add(string);
                    }
                    return arrayList;
                }

                @Override
                public List<Configuration> getDependencies() {
                    return null;
                }

                @Override
                public List<SourceFileProperties> getSourcesConfiguration() {
                    if (this.myFileProperties == null) {
                        this.myFileProperties = this.getSourceFileProperties();
                    }
                    return this.myFileProperties;
                }

                @Override
                public List<String> getIncludedFiles() {
                    if (this.myIncludedFiles == null) {
                        HashSet<String> hashSet = new HashSet<String>();
                        for (SourceFileProperties object : this.getSourcesConfiguration()) {
                            hashSet.add(object.getItemPath());
                        }
                        HashSet hashSet2 = new HashSet();
                        for (String string : hashSet) {
                            File file = new File(string);
                            if (!CndFileUtils.exists((File)file)) continue;
                            hashSet2.add(CndFileUtils.normalizeFile((File)file).getAbsolutePath());
                        }
                        this.myIncludedFiles = new ArrayList<String>(hashSet2);
                    }
                    return this.myIncludedFiles;
                }
            };
            arrayList.add(configuration);
            return arrayList;
        }

        @Override
        public void stop() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DiscoveryDescriptorImpl
    implements DiscoveryDescriptor {
        private Project project;
        private DiscoveryProvider provider;
        private List<Configuration> configurations;
        private List<ProjectConfiguration> projectConfigurations;
        private List<String> includedFiles;
        private String root;

        private DiscoveryDescriptorImpl(Project project, DiscoveryProvider discoveryProvider, String string) {
            this.project = project;
            this.provider = discoveryProvider;
            this.root = string;
            this.configurations = discoveryProvider.analyze(null, null);
        }

        @Override
        public Project getProject() {
            return this.project;
        }

        @Override
        public void setProject(Project project) {
            this.project = project;
        }

        @Override
        public DiscoveryProvider getProvider() {
            return this.provider;
        }

        @Override
        public String getProviderID() {
            return this.provider.getID();
        }

        @Override
        public void setProvider(DiscoveryProvider discoveryProvider) {
            this.provider = discoveryProvider;
        }

        @Override
        public String getRootFolder() {
            return this.root;
        }

        @Override
        public void setRootFolder(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getBuildResult() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setBuildResult(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getAditionalLibraries() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setAditionalLibraries(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getBuildLog() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setBuildLog(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getLevel() {
            return "file";
        }

        @Override
        public void setLevel(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<ProjectConfiguration> getConfigurations() {
            if (this.projectConfigurations == null) {
                this.provider.analyze(null, null);
                this.projectConfigurations = new ArrayList<ProjectConfiguration>();
                for (Configuration configuration : this.configurations) {
                    List<ProjectProperties> list = configuration.getProjectConfiguration();
                    for (ProjectProperties projectProperties : list) {
                        ProjectConfigurationImpl projectConfigurationImpl = ConfigurationFactory.makeRoot(projectProperties, this.getRootFolder());
                        SelectConfigurationPanel.consolidateModel(projectConfigurationImpl, this.getLevel());
                        this.projectConfigurations.add(projectConfigurationImpl);
                    }
                }
            }
            return this.projectConfigurations;
        }

        @Override
        public void setConfigurations(List<ProjectConfiguration> list) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<String> getIncludedFiles() {
            if (this.includedFiles == null) {
                this.includedFiles = new ArrayList<String>();
                for (Configuration configuration : this.configurations) {
                    this.includedFiles.addAll(configuration.getIncludedFiles());
                }
            }
            return this.includedFiles;
        }

        @Override
        public void setIncludedFiles(List<String> list) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isInvokeProvider() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setInvokeProvider(boolean bl) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isSimpleMode() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setSimpleMode(boolean bl) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setMessage(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void clean() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

