/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seproject.ui.FoldersListSettings;
import org.netbeans.modules.java.j2seproject.ui.wizards.NewJ2SEProjectWizardIterator;
import org.netbeans.modules.java.j2seproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.java.j2seproject.ui.wizards.PanelSourceFolders;
import org.netbeans.modules.java.j2seproject.ui.wizards.SettingsPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class PanelProjectLocationVisual
extends SettingsPanel
implements DocumentListener {
    public static final String PROP_PROJECT_NAME = "projectName";
    public static final String PROP_PROJECT_LOCATION = "projectLocation";
    private PanelConfigureProject panel;
    private NewJ2SEProjectWizardIterator.WizardType type;
    private JButton browseButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;

    public PanelProjectLocationVisual(PanelConfigureProject panelConfigureProject, NewJ2SEProjectWizardIterator.WizardType wizardType) {
        this.initComponents();
        this.panel = panelConfigureProject;
        this.type = wizardType;
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
    }

    public String getProjectName() {
        return this.projectNameTextField.getText();
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.projectNameLabel, gridBagConstraints);
        this.projectNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelProjectLocationVisual.class).getString("ACSN_projectNameLabel"));
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelProjectLocationVisual.class).getString("ACSD_projectNameLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 12, 0);
        this.add((Component)this.projectNameTextField, gridBagConstraints);
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_ProjectLocation_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.projectLocationLabel, gridBagConstraints);
        this.projectLocationLabel.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelProjectLocationVisual.class).getString("ACSN_projectLocationLabel"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelProjectLocationVisual.class).getString("ACSD_projectLocationLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 5, 0);
        this.add((Component)this.projectLocationTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_BrowseLocation_Button"));
        this.browseButton.setActionCommand("BROWSE");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PanelProjectLocationVisual.this.browseLocationAction(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelProjectLocationVisual.class).getString("ACSN_browseButton"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelProjectLocationVisual.class).getString("ACSD_browseButton"));
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_CreatedProjectFolder_Lablel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.createdFolderLabel, gridBagConstraints);
        this.createdFolderLabel.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelProjectLocationVisual.class).getString("ACSN_createdFolderLabel"));
        this.createdFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelProjectLocationVisual.class).getString("ACSD_createdFolderLabel"));
        this.createdFolderTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.createdFolderTextField, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACSN_PanelProjectLocationVisual"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"ACSD_PanelProjectLocationVisual"));
    }

    private void browseLocationAction(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("BROWSE".equals(string)) {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
            jFileChooser.setDialogTitle(NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_NWP1_SelectProjectLocation"));
            jFileChooser.setFileSelectionMode(1);
            String string2 = this.projectLocationTextField.getText();
            if (string2.length() > 0 && (file = new File(string2)).exists()) {
                jFileChooser.setSelectedFile(file);
            }
            if (0 == jFileChooser.showOpenDialog(this)) {
                file = jFileChooser.getSelectedFile();
                this.projectLocationTextField.setText(FileUtil.normalizeFile((File)file).getAbsolutePath());
            }
            this.panel.fireChangeEvent();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        File file;
        if (this.projectNameTextField.getText().length() == 0 || this.projectNameTextField.getText().indexOf(47) >= 0 || this.projectNameTextField.getText().indexOf(92) >= 0 || this.projectNameTextField.getText().indexOf(58) >= 0 || this.projectNameTextField.getText().indexOf("\"") >= 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectName"));
            return false;
        }
        File file2 = new File(this.projectLocationTextField.getText()).getAbsoluteFile();
        if (PanelProjectLocationVisual.getCanonicalFile(file2) == null) {
            String string = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectLocation");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
            return false;
        }
        File file3 = PanelProjectLocationVisual.getCanonicalFile(new File(this.createdFolderTextField.getText()));
        if (Utilities.isUnix() && file3 != null && file3.getParentFile().getParent() == null) {
            String string = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectInRootNotSupported");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
            return false;
        }
        File file4 = new File(this.createdFolderTextField.getText()).getAbsoluteFile();
        if (PanelProjectLocationVisual.getCanonicalFile(file4) == null) {
            String string = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectLocation");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
            return false;
        }
        for (file = FileUtil.normalizeFile((File)file4); file != null && !file.exists(); file = file.getParentFile()) {
        }
        if (file == null || !file.canWrite()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectFolderReadOnly"));
            return false;
        }
        if (FileUtil.toFileObject((File)file) == null) {
            String string = NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectLocation");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
            return false;
        }
        File[] fileArray = file4.listFiles();
        if (file4.exists() && fileArray != null && fileArray.length > 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectFolderExists"));
            return false;
        }
        Project project = null;
        boolean bl = false;
        try {
            project = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file4)));
        }
        catch (IOException iOException) {
            bl = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (project != null || bl) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"MSG_ProjectMightAlreadyExists"));
            return false;
        }
        return true;
    }

    void store(WizardDescriptor wizardDescriptor) {
        String string = this.projectNameTextField.getText().trim();
        String string2 = this.projectLocationTextField.getText().trim();
        String string3 = this.createdFolderTextField.getText().trim();
        wizardDescriptor.putProperty("projdir", (Object)new File(string3));
        wizardDescriptor.putProperty("name", (Object)string);
    }

    void read(WizardDescriptor wizardDescriptor) {
        File file = (File)wizardDescriptor.getProperty("projdir");
        file = file == null || file.getParentFile() == null || !file.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : file.getParentFile();
        this.projectLocationTextField.setText(file.getAbsolutePath());
        String string = (String)wizardDescriptor.getProperty("name");
        if (string == null) {
            switch (this.type) {
                case APP: {
                    int n = FoldersListSettings.getDefault().getNewApplicationCount() + 1;
                    String string2 = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_JavaApplication");
                    while ((string = this.validFreeProjectName(file, string2, n)) == null) {
                        ++n;
                    }
                    wizardDescriptor.putProperty("nameIndex", (Object)new Integer(n));
                    break;
                }
                default: {
                    int n = FoldersListSettings.getDefault().getNewLibraryCount() + 1;
                    String string3 = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_JavaLibrary");
                    while ((string = this.validFreeProjectName(file, string3, n)) == null) {
                        ++n;
                    }
                    wizardDescriptor.putProperty("nameIndex", (Object)new Integer(n));
                }
            }
        }
        this.projectNameTextField.setText(string);
        this.projectNameTextField.selectAll();
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
    }

    private static JFileChooser createChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setName("Select Project Directory");
        return jFileChooser;
    }

    private String validFreeProjectName(File file, String string, int n) {
        String string2 = MessageFormat.format(string, new Integer(n));
        File file2 = new File(file, string2);
        return file2.exists() ? null : string2;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
        if (this.projectLocationTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_LOCATION, null, this.projectLocationTextField.getText());
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
        if (this.projectLocationTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_LOCATION, null, this.projectLocationTextField.getText());
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
        if (this.projectLocationTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_LOCATION, null, this.projectLocationTextField.getText());
        }
    }

    private void updateTexts(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this.projectNameTextField.getDocument() || document == this.projectLocationTextField.getDocument()) {
            String string = this.projectNameTextField.getText();
            String string2 = this.projectLocationTextField.getText();
            String string3 = FileUtil.normalizeFile((File)new File(string2)).getAbsolutePath();
            if (string3.endsWith(File.separator)) {
                this.createdFolderTextField.setText(string3 + string);
            } else {
                this.createdFolderTextField.setText(string3 + File.separator + string);
            }
        }
        this.panel.fireChangeEvent();
    }

    static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

