/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.ui.customizer.MainClassChooser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2SEProjectUtil {
    private J2SEProjectUtil() {
    }

    public static Object getEvaluatedProperty(Project project, String string) {
        if (string == null) {
            return null;
        }
        J2SEProject j2SEProject = (J2SEProject)project.getLookup().lookup(J2SEProject.class);
        if (j2SEProject != null) {
            return j2SEProject.evaluator().evaluate(string);
        }
        return null;
    }

    public static boolean hasMainMethod(FileObject fileObject) {
        if (MainClassChooser.unitTestingSupport_hasMainMethodResult != null) {
            return MainClassChooser.unitTestingSupport_hasMainMethodResult;
        }
        if (fileObject == null) {
            return false;
        }
        return !SourceUtils.getMainClasses((FileObject)fileObject).isEmpty();
    }

    public static Collection<ElementHandle<TypeElement>> getMainMethods(FileObject fileObject) {
        if (fileObject == null || MainClassChooser.unitTestingSupport_hasMainMethodResult != null) {
            return Collections.emptySet();
        }
        return SourceUtils.getMainClasses((FileObject)fileObject);
    }

    public static boolean isMainClass(String string, ClassPath classPath, ClassPath classPath2, ClassPath classPath3) {
        ClasspathInfo classpathInfo = ClasspathInfo.create((ClassPath)classPath, (ClassPath)classPath2, (ClassPath)classPath3);
        return SourceUtils.isMainClass((String)string, (ClasspathInfo)classpathInfo);
    }

    public static URL getRootURL(File file, String string) throws MalformedURLException {
        URL uRL = FileUtil.urlForArchiveOrDir((File)file);
        if (uRL == null) {
            throw new IllegalArgumentException(file.getAbsolutePath());
        }
        if (string != null) {
            assert (string.endsWith("/"));
            uRL = new URL(uRL.toExternalForm() + string);
        }
        return uRL;
    }

    public static JavaPlatform getActivePlatform(String string) {
        JavaPlatform[] javaPlatformArray;
        JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
        if (string == null) {
            return javaPlatformManager.getDefaultPlatform();
        }
        for (JavaPlatform javaPlatform : javaPlatformArray = javaPlatformManager.getPlatforms(null, new Specification("j2se", null))) {
            String string2 = (String)javaPlatform.getProperties().get("platform.ant.name");
            if (string2 == null || !string2.equals(string)) continue;
            return javaPlatform;
        }
        return null;
    }

    public static String getBuildXmlName(J2SEProject j2SEProject) {
        assert (j2SEProject != null);
        String string = j2SEProject.evaluator().getProperty("buildfile");
        if (string == null) {
            string = "build.xml";
        }
        return string;
    }

    public static FileObject getBuildXml(J2SEProject j2SEProject) {
        return j2SEProject.getProjectDirectory().getFileObject(J2SEProjectUtil.getBuildXmlName(j2SEProject));
    }

    public static boolean isCompileOnSaveSupported(J2SEProject j2SEProject) {
        for (Map.Entry entry : j2SEProject.evaluator().getProperties().entrySet()) {
            if (!((String)entry.getKey()).startsWith("compile.on.save.unsupported") || entry.getValue() == null || !Boolean.valueOf((String)entry.getValue()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static boolean isCompileOnSaveEnabled(J2SEProject j2SEProject) {
        String string = j2SEProject.evaluator().getProperty("compile.on.save");
        return string != null && Boolean.valueOf(string) != false && J2SEProjectUtil.isCompileOnSaveSupported(j2SEProject);
    }
}

