/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.elements;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.elements.AstElement;
import org.netbeans.modules.groovy.editor.api.elements.CommentElement;
import org.netbeans.modules.groovy.editor.api.elements.GroovyElement;
import org.netbeans.modules.groovy.editor.api.elements.IndexedElement;
import org.netbeans.modules.groovy.editor.api.elements.KeywordElement;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementHandleSupport {
    public static ElementHandle createHandle(ParserResult parserResult, GroovyElement groovyElement) {
        if (groovyElement instanceof KeywordElement || groovyElement instanceof CommentElement) {
            return new GroovyElementHandle(null, groovyElement, parserResult.getSnapshot().getSource().getFileObject());
        }
        if (groovyElement instanceof IndexedElement) {
            return new GroovyElementHandle(null, groovyElement, ((IndexedElement)groovyElement).getFileObject());
        }
        if (!(groovyElement instanceof AstElement)) {
            return null;
        }
        if (parserResult == null) {
            return null;
        }
        GroovyParserResult groovyParserResult = AstUtilities.getParseResult((Parser.Result)parserResult);
        if (groovyParserResult == null) {
            return null;
        }
        ModuleNode moduleNode = AstUtilities.getRoot(parserResult);
        return new GroovyElementHandle(moduleNode, groovyElement, parserResult.getSnapshot().getSource().getFileObject());
    }

    public static ElementHandle createHandle(ParserResult parserResult, AstElement astElement) {
        ModuleNode moduleNode = AstUtilities.getRoot(parserResult);
        return new GroovyElementHandle(moduleNode, astElement, parserResult.getSnapshot().getSource().getFileObject());
    }

    public static GroovyElement resolveHandle(ParserResult parserResult, ElementHandle elementHandle) {
        GroovyElementHandle groovyElementHandle = (GroovyElementHandle)elementHandle;
        ASTNode aSTNode = groovyElementHandle.root;
        if (groovyElementHandle.object instanceof KeywordElement || groovyElementHandle.object instanceof IndexedElement || groovyElementHandle.object instanceof CommentElement) {
            return groovyElementHandle.object;
        }
        if (!(groovyElementHandle.object instanceof AstElement)) {
            return null;
        }
        ASTNode aSTNode2 = ((AstElement)groovyElementHandle.object).getNode();
        ModuleNode moduleNode = AstUtilities.getRoot(parserResult);
        if (moduleNode == null) {
            return null;
        }
        ASTNode aSTNode3 = ElementHandleSupport.find(aSTNode, aSTNode2, moduleNode);
        if (aSTNode3 != null) {
            AstElement astElement = AstElement.create(AstUtilities.getParseResult((Parser.Result)parserResult), aSTNode3);
            return astElement;
        }
        return null;
    }

    public static ElementHandle createHandle(String string, String string2, ElementKind elementKind, Set<Modifier> set) {
        return new SimpleElementHandle(string, string2, elementKind, set);
    }

    private static ASTNode find(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) {
        List<ASTNode> list = AstUtilities.children(aSTNode);
        List<ASTNode> list2 = AstUtilities.children(aSTNode3);
        Iterator<ASTNode> iterator = list.iterator();
        Iterator<ASTNode> iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            if (!iterator2.hasNext()) {
                return null;
            }
            ASTNode aSTNode4 = iterator.next();
            ASTNode aSTNode5 = iterator2.next();
            if (aSTNode4 == aSTNode2) {
                return aSTNode5;
            }
            ASTNode aSTNode6 = ElementHandleSupport.find(aSTNode4, aSTNode2, aSTNode5);
            if (aSTNode6 == null) continue;
            return aSTNode6;
        }
        if (iterator2.hasNext()) {
            return null;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleElementHandle
    implements ElementHandle {
        private final String className;
        private final String elementName;
        private final ElementKind kind;
        private final Set<Modifier> modifiers;

        public SimpleElementHandle(String string, String string2, ElementKind elementKind, Set<Modifier> set) {
            this.className = string;
            this.elementName = string2;
            this.kind = elementKind;
            this.modifiers = set;
        }

        public FileObject getFileObject() {
            return null;
        }

        public String getIn() {
            return this.className;
        }

        public ElementKind getKind() {
            return this.kind;
        }

        public String getMimeType() {
            return "text/x-groovy";
        }

        public Set<Modifier> getModifiers() {
            return this.modifiers;
        }

        public String getName() {
            return this.elementName;
        }

        public boolean signatureEquals(ElementHandle elementHandle) {
            return false;
        }

        public OffsetRange getOffsetRange(ParserResult parserResult) {
            return OffsetRange.NONE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GroovyElementHandle
    implements ElementHandle {
        private final ASTNode root;
        private final GroovyElement object;
        private final FileObject fileObject;

        private GroovyElementHandle(ASTNode aSTNode, GroovyElement groovyElement, FileObject fileObject) {
            this.root = aSTNode;
            this.object = groovyElement;
            this.fileObject = fileObject;
        }

        public boolean signatureEquals(ElementHandle elementHandle) {
            return false;
        }

        public FileObject getFileObject() {
            if (this.object instanceof IndexedElement) {
                return ((IndexedElement)this.object).getFileObject();
            }
            return this.fileObject;
        }

        public String getMimeType() {
            return "text/x-groovy";
        }

        public String getName() {
            return this.object.getName();
        }

        public String getIn() {
            return this.object.getIn();
        }

        public ElementKind getKind() {
            return this.object.getKind();
        }

        public Set<Modifier> getModifiers() {
            return this.object.getModifiers();
        }

        public OffsetRange getOffsetRange(ParserResult parserResult) {
            return OffsetRange.NONE;
        }
    }
}

