/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.modules.groovy.editor.api.elements.IndexedClass;
import org.netbeans.modules.groovy.editor.api.elements.IndexedElement;
import org.netbeans.modules.groovy.editor.api.elements.IndexedField;
import org.netbeans.modules.groovy.editor.api.elements.IndexedMethod;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GroovyIndex {
    private static final Logger LOG = Logger.getLogger(GroovyIndex.class.getName());
    private static final GroovyIndex EMPTY = new GroovyIndex(null);
    private static final String CLUSTER_URL = "cluster:";
    private static String clusterUrl = null;
    private final QuerySupport querySupport;

    private GroovyIndex(QuerySupport querySupport) {
        this.querySupport = querySupport;
    }

    public static GroovyIndex get(Collection<FileObject> collection) {
        try {
            return new GroovyIndex(QuerySupport.forRoots((String)"groovy", (int)8, (FileObject[])collection.toArray(new FileObject[collection.size()])));
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
            return EMPTY;
        }
    }

    public Set<IndexedClass> getClasses(String string, QuerySupport.Kind kind, boolean bl, boolean bl2, boolean bl3) {
        return this.getClasses(string, kind, bl, bl2, bl3, null);
    }

    public Set<IndexedClass> getClasses(String string, QuerySupport.Kind kind, boolean bl, boolean bl2, boolean bl3, Set<String> set) {
        String string2;
        String string3 = null;
        if (string != null && string.endsWith(".")) {
            string3 = string.substring(0, string.length() - 1);
            string = "";
        }
        HashSet<IndexResult> hashSet = new HashSet<IndexResult>();
        switch (kind) {
            case EXACT: {
                string2 = "fqn";
                break;
            }
            case PREFIX: 
            case CAMEL_CASE: 
            case REGEXP: {
                string2 = "class";
                break;
            }
            case CASE_INSENSITIVE_PREFIX: 
            case CASE_INSENSITIVE_REGEXP: {
                string2 = "class-ig";
                break;
            }
            default: {
                throw new UnsupportedOperationException(kind.toString());
            }
        }
        this.search(string2, string, kind, hashSet);
        if (bl) {
            set = null;
        } else if (set == null) {
            set = new HashSet<String>();
        }
        HashSet<IndexedClass> hashSet2 = new HashSet<IndexedClass>();
        for (IndexResult indexResult : hashSet) {
            int n;
            String string4;
            String string5 = indexResult.getValue("class");
            if (string5 == null || kind == QuerySupport.Kind.PREFIX && !string5.startsWith(string) || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && !string5.regionMatches(true, 0, string, 0, string.length())) continue;
            if (string3 != null) {
                if (kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX || kind == QuerySupport.Kind.CASE_INSENSITIVE_REGEXP) {
                    if (!string3.equalsIgnoreCase(indexResult.getValue("in"))) {
                        continue;
                    }
                } else if (kind == QuerySupport.Kind.CAMEL_CASE) {
                    int n2;
                    string4 = indexResult.getValue("in");
                    if (string4 == null) continue;
                    StringBuilder stringBuilder = new StringBuilder();
                    n = 0;
                    do {
                        int n3 = -1;
                        for (int i = n + 1; i < string3.length(); ++i) {
                            if (!Character.isUpperCase(string3.charAt(i))) continue;
                            n3 = i;
                            break;
                        }
                        String string6 = string3.substring(n, (n2 = n3) == -1 ? string3.length() : n2);
                        stringBuilder.append(string6);
                        stringBuilder.append(n2 != -1 ? "[\\p{javaLowerCase}\\p{Digit}_\\$]*" : ".*");
                        n = n2;
                    } while (n2 != -1);
                    Pattern pattern = Pattern.compile(stringBuilder.toString());
                    if (!pattern.matcher(string4).matches()) {
                        continue;
                    }
                } else if (!string3.equals(indexResult.getValue("in"))) continue;
            }
            string4 = indexResult.getValue("attrs");
            boolean bl4 = true;
            if (string4 != null) {
                n = IndexedElement.stringToFlag(string4, 0);
                boolean bl5 = bl4 = (n & 0x40) == 0;
            }
            if (bl2 && bl4 || bl3 && !bl4) continue;
            String string7 = indexResult.getValue("fqn");
            if (!bl && !set.contains(string7)) {
                set.add(string7);
            }
            hashSet2.add(this.createClass(string7, string5, indexResult));
        }
        return hashSet2;
    }

    public Set<IndexedMethod> getMethods(String string, String string2, QuerySupport.Kind kind) {
        boolean bl = string2 == null;
        HashSet<IndexResult> hashSet = new HashSet<IndexResult>();
        String string3 = "method";
        QuerySupport.Kind kind2 = kind;
        if (kind == QuerySupport.Kind.EXACT) {
            kind = QuerySupport.Kind.PREFIX;
        }
        this.search(string3, string, kind, hashSet);
        HashSet<IndexedMethod> hashSet2 = new HashSet<IndexedMethod>();
        for (IndexResult indexResult : hashSet) {
            String[] stringArray;
            if (string2 != null && !string2.equals(stringArray = indexResult.getValue("fqn")) || (stringArray = indexResult.getValues("method")) == null) continue;
            for (String string4 : stringArray) {
                block9: {
                    if ((string == null || string.length() == 0) && !Character.isLowerCase(string4.charAt(0)) || kind == QuerySupport.Kind.PREFIX && !string4.startsWith(string) || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && !string4.regionMatches(true, 0, string, 0, string.length())) continue;
                    if (kind == QuerySupport.Kind.CASE_INSENSITIVE_REGEXP) {
                        int n = string4.length();
                        int n2 = string4.indexOf(40);
                        if (n2 == -1 && (n2 = string4.indexOf(59)) == -1) {
                            n2 = n;
                        }
                        String string5 = n2 != n ? string4.substring(0, n2) : string4;
                        try {
                            if (!string5.matches(string)) {
                                continue;
                            }
                            break block9;
                        }
                        catch (Exception exception) {
                            break block9;
                        }
                    }
                    if (kind2 == QuerySupport.Kind.EXACT && string4.length() > string.length() && string4.charAt(string.length()) != '(' && string4.charAt(string.length()) != ';') continue;
                }
                assert (indexResult != null);
                hashSet2.add(this.createMethod(string4, indexResult, bl));
            }
        }
        return hashSet2;
    }

    public Set<IndexedField> getFields(String string, String string2, QuerySupport.Kind kind) {
        boolean bl = string2 == null;
        HashSet<IndexResult> hashSet = new HashSet<IndexResult>();
        String string3 = "field";
        QuerySupport.Kind kind2 = kind;
        if (kind == QuerySupport.Kind.EXACT) {
            kind = QuerySupport.Kind.PREFIX;
        }
        this.search(string3, string, kind, hashSet);
        HashSet<IndexedField> hashSet2 = new HashSet<IndexedField>();
        for (IndexResult indexResult : hashSet) {
            String[] stringArray;
            if (string2 != null && !string2.equals(stringArray = indexResult.getValue("fqn")) || (stringArray = indexResult.getValues("field")) == null) continue;
            for (String string4 : stringArray) {
                block9: {
                    if ((string == null || string.length() == 0) && !Character.isLowerCase(string4.charAt(0)) || kind == QuerySupport.Kind.PREFIX && !string4.startsWith(string) || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX && !string4.regionMatches(true, 0, string, 0, string.length())) continue;
                    if (kind == QuerySupport.Kind.CASE_INSENSITIVE_REGEXP) {
                        int n = string4.length();
                        int n2 = string4.indexOf(59);
                        if (n2 == -1) {
                            n2 = n;
                        }
                        String string5 = n2 != n ? string4.substring(0, n2) : string4;
                        try {
                            if (!string5.matches(string)) {
                                continue;
                            }
                            break block9;
                        }
                        catch (Exception exception) {
                            break block9;
                        }
                    }
                    if (kind2 == QuerySupport.Kind.EXACT && string4.length() > string.length() && string4.charAt(string.length()) != ';') continue;
                }
                assert (indexResult != null);
                hashSet2.add(this.createField(string4, indexResult, bl));
            }
        }
        return hashSet2;
    }

    public Set<IndexedMethod> getInheritedMethods(String string, String string2, QuerySupport.Kind kind) {
        boolean bl = false;
        HashSet<IndexedMethod> hashSet = new HashSet<IndexedMethod>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        if (string2 == null) {
            string2 = "";
        }
        this.addMethodsFromClass(string2, kind, string, hashSet, hashSet3, hashSet2, bl, false);
        return hashSet;
    }

    private boolean addMethodsFromClass(String string, QuerySupport.Kind kind, String string2, Set<IndexedMethod> set, Set<String> set2, Set<String> set3, boolean bl, boolean bl2) {
        boolean bl3;
        if (set3.contains(string2)) {
            return false;
        }
        set3.add(string2);
        String string3 = "fqn";
        HashSet<IndexResult> hashSet = new HashSet<IndexResult>();
        this.search(string3, string2, QuerySupport.Kind.EXACT, hashSet);
        boolean bl4 = bl3 = hashSet.size() > 0;
        if (!bl3) {
            return bl3;
        }
        for (IndexResult indexResult : hashSet) {
            assert (indexResult != null);
            String[] stringArray = indexResult.getValues("method");
            if (stringArray == null) continue;
            for (String string4 : stringArray) {
                if (string.length() == 0 && !Character.isLowerCase(string4.charAt(0)) || set2.contains(string4) || !string4.startsWith(string)) continue;
                if (kind == QuerySupport.Kind.EXACT) {
                    if (string4.length() > string.length() && string4.charAt(string.length()) != '(' && string4.charAt(string.length()) != ';') {
                        continue;
                    }
                } else assert (kind == QuerySupport.Kind.PREFIX || kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
                set2.add(string4);
                IndexedMethod indexedMethod = this.createMethod(string4, indexResult, bl2);
                indexedMethod.setSmart(!bl);
                set.add(indexedMethod);
            }
        }
        this.addMethodsFromClass(string, kind, "java.lang.Object", set, set2, set3, true, true);
        return bl3;
    }

    private IndexedClass createClass(String string, String string2, IndexResult indexResult) {
        if (string2 == null) {
            string2 = indexResult.getValue("class");
        }
        String string3 = indexResult.getValue("attrs");
        int n = 0;
        if (string3 != null) {
            n = IndexedElement.stringToFlag(string3, 0);
        }
        IndexedClass indexedClass = IndexedClass.create(this, string2, string, indexResult, string3, n);
        return indexedClass;
    }

    private IndexedMethod createMethod(String string, IndexResult indexResult, boolean bl) {
        int n;
        String string2 = indexResult.getValue("class");
        String string3 = indexResult.getValue("in");
        if (string2 == null) {
            string2 = string3;
        } else if (string3 != null && string3.length() > 0) {
            string2 = string3 + "." + string2;
        }
        int n2 = string.indexOf(59);
        String string4 = string;
        String string5 = "void";
        if (n2 != -1) {
            n = string.indexOf(59, n2 + 1);
            if (n == -1) {
                n = string.length();
            }
            string5 = string.substring(n2 + 1, n);
            string4 = string.substring(0, n2);
        }
        n = string.indexOf(59, n2 + 1);
        String string6 = null;
        int n3 = 0;
        if (n != -1) {
            n3 = IndexedElement.stringToFlag(string, n + 1);
            if (string.length() > n + 1) {
                string6 = string.substring(n + 1, string.length());
            }
        }
        IndexedMethod indexedMethod = IndexedMethod.create(this, string4, string5, string2, indexResult, string6, n3);
        indexedMethod.setInherited(bl);
        return indexedMethod;
    }

    private IndexedField createField(String string, IndexResult indexResult, boolean bl) {
        int n;
        String string2 = indexResult.getValue("class");
        String string3 = indexResult.getValue("in");
        if (string2 == null) {
            string2 = string3;
        } else if (string3 != null && string3.length() > 0) {
            string2 = string3 + "." + string2;
        }
        int n2 = string.indexOf(59);
        String string4 = string;
        String string5 = "java.lang.Object";
        if (n2 != -1) {
            n = string.indexOf(59, n2 + 1);
            if (n == -1) {
                n = string.length();
            }
            string5 = string.substring(n2 + 1, n);
            string4 = string.substring(0, n2);
        }
        n = string.indexOf(59, n2 + 1);
        String string6 = null;
        int n3 = 0;
        if (n != -1) {
            n3 = IndexedElement.stringToFlag(string, n + 1);
            if (string.length() > n + 1) {
                string6 = string.substring(n + 1, string.length());
            }
        }
        IndexedField indexedField = IndexedField.create(this, string4, string5, string2, indexResult, string6, n3);
        indexedField.setInherited(bl);
        return indexedField;
    }

    private boolean search(String string, String string2, QuerySupport.Kind kind, Set<IndexResult> set) {
        try {
            set.addAll(this.querySupport.query(string, string2, kind, (String[])null));
            return true;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    public static void setClusterUrl(String string) {
        clusterUrl = string;
    }

    static String getPreindexUrl(String string) {
        String string2 = GroovyIndex.getClusterUrl();
        if (string.startsWith(string2)) {
            return CLUSTER_URL + string.substring(string2.length());
        }
        return string;
    }

    static String getClusterUrl() {
        if (clusterUrl == null) {
            File file = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-groovy-editor.jar", null, false);
            if (file == null) {
                throw new RuntimeException("Can't find cluster");
            }
            file = new File(file.getParentFile().getParentFile().getAbsolutePath());
            try {
                file = file.getCanonicalFile();
                clusterUrl = file.toURI().toURL().toExternalForm();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return clusterUrl;
    }
}

