/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api;

import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;

public final class GroovyBracesMatcher
implements BracesMatcher {
    MatcherContext context;

    public GroovyBracesMatcher(MatcherContext matcherContext) {
        this.context = matcherContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findOrigin() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            Token token;
            BaseDocument baseDocument = (BaseDocument)this.context.getDocument();
            int n = this.context.getSearchOffset();
            TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(baseDocument, n);
            if (tokenSequence != null) {
                tokenSequence.move(n);
                if (!tokenSequence.moveNext()) {
                    int[] nArray = null;
                    return nArray;
                }
                token = tokenSequence.token();
                if (token == null) {
                    int[] nArray = null;
                    return nArray;
                }
                TokenId tokenId = token.id();
                if (tokenId == GroovyTokenId.STRING_BEGIN) {
                    int[] nArray = new int[]{tokenSequence.offset(), tokenSequence.offset() + token.length()};
                    return nArray;
                }
                if (tokenId == GroovyTokenId.STRING_END) {
                    int[] nArray = new int[]{tokenSequence.offset(), tokenSequence.offset() + token.length()};
                    return nArray;
                }
                if (tokenId == GroovyTokenId.REGEXP_BEGIN) {
                    int[] nArray = new int[]{tokenSequence.offset(), tokenSequence.offset() + token.length()};
                    return nArray;
                }
                if (tokenId == GroovyTokenId.REGEXP_END) {
                    int[] nArray = new int[]{tokenSequence.offset(), tokenSequence.offset() + token.length()};
                    return nArray;
                }
                if (tokenId == GroovyTokenId.LPAREN) {
                    int[] nArray = new int[]{tokenSequence.offset(), tokenSequence.offset() + token.length()};
                    return nArray;
                }
                if (tokenId == GroovyTokenId.RPAREN) {
                    int[] nArray = new int[]{tokenSequence.offset(), tokenSequence.offset() + token.length()};
                    return nArray;
                }
                if (tokenId == GroovyTokenId.LBRACE) {
                    int[] nArray = new int[]{tokenSequence.offset(), tokenSequence.offset() + token.length()};
                    return nArray;
                }
                if (tokenId == GroovyTokenId.RBRACE) {
                    int[] nArray = new int[]{tokenSequence.offset(), tokenSequence.offset() + token.length()};
                    return nArray;
                }
                if (tokenId == GroovyTokenId.LBRACKET) {
                    int[] nArray = new int[]{tokenSequence.offset(), tokenSequence.offset() + token.length()};
                    return nArray;
                }
                if (tokenId == GroovyTokenId.RBRACKET) {
                    int[] nArray = new int[]{tokenSequence.offset(), tokenSequence.offset() + token.length()};
                    return nArray;
                }
            }
            token = null;
            return token;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findMatches() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            Token token;
            BaseDocument baseDocument = (BaseDocument)this.context.getDocument();
            int n = this.context.getSearchOffset();
            TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(baseDocument, n);
            if (tokenSequence != null) {
                tokenSequence.move(n);
                if (!tokenSequence.moveNext()) {
                    int[] nArray = null;
                    return nArray;
                }
                token = tokenSequence.token();
                if (token == null) {
                    int[] nArray = null;
                    return nArray;
                }
                TokenId tokenId = token.id();
                if (tokenId == GroovyTokenId.STRING_BEGIN) {
                    OffsetRange offsetRange = LexUtilities.findFwd(baseDocument, tokenSequence, GroovyTokenId.STRING_BEGIN, GroovyTokenId.STRING_END);
                    int[] nArray = new int[]{offsetRange.getStart(), offsetRange.getEnd()};
                    return nArray;
                }
                if (tokenId == GroovyTokenId.STRING_END) {
                    OffsetRange offsetRange = LexUtilities.findBwd(baseDocument, tokenSequence, GroovyTokenId.STRING_BEGIN, GroovyTokenId.STRING_END);
                    int[] nArray = new int[]{offsetRange.getStart(), offsetRange.getEnd()};
                    return nArray;
                }
                if (tokenId == GroovyTokenId.REGEXP_BEGIN) {
                    OffsetRange offsetRange = LexUtilities.findFwd(baseDocument, tokenSequence, GroovyTokenId.REGEXP_BEGIN, GroovyTokenId.REGEXP_END);
                    int[] nArray = new int[]{offsetRange.getStart(), offsetRange.getEnd()};
                    return nArray;
                }
                if (tokenId == GroovyTokenId.REGEXP_END) {
                    OffsetRange offsetRange = LexUtilities.findBwd(baseDocument, tokenSequence, GroovyTokenId.REGEXP_BEGIN, GroovyTokenId.REGEXP_END);
                    int[] nArray = new int[]{offsetRange.getStart(), offsetRange.getEnd()};
                    return nArray;
                }
                if (tokenId == GroovyTokenId.LPAREN) {
                    OffsetRange offsetRange = LexUtilities.findFwd(baseDocument, tokenSequence, GroovyTokenId.LPAREN, GroovyTokenId.RPAREN);
                    int[] nArray = new int[]{offsetRange.getStart(), offsetRange.getEnd()};
                    return nArray;
                }
                if (tokenId == GroovyTokenId.RPAREN) {
                    OffsetRange offsetRange = LexUtilities.findBwd(baseDocument, tokenSequence, GroovyTokenId.LPAREN, GroovyTokenId.RPAREN);
                    int[] nArray = new int[]{offsetRange.getStart(), offsetRange.getEnd()};
                    return nArray;
                }
                if (tokenId == GroovyTokenId.LBRACE) {
                    OffsetRange offsetRange = LexUtilities.findFwd(baseDocument, tokenSequence, GroovyTokenId.LBRACE, GroovyTokenId.RBRACE);
                    int[] nArray = new int[]{offsetRange.getStart(), offsetRange.getEnd()};
                    return nArray;
                }
                if (tokenId == GroovyTokenId.RBRACE) {
                    OffsetRange offsetRange = LexUtilities.findBwd(baseDocument, tokenSequence, GroovyTokenId.LBRACE, GroovyTokenId.RBRACE);
                    int[] nArray = new int[]{offsetRange.getStart(), offsetRange.getEnd()};
                    return nArray;
                }
                if (tokenId == GroovyTokenId.LBRACKET) {
                    OffsetRange offsetRange = LexUtilities.findFwd(baseDocument, tokenSequence, GroovyTokenId.LBRACKET, GroovyTokenId.RBRACKET);
                    int[] nArray = new int[]{offsetRange.getStart(), offsetRange.getEnd()};
                    return nArray;
                }
                if (tokenId == GroovyTokenId.RBRACKET) {
                    OffsetRange offsetRange = LexUtilities.findBwd(baseDocument, tokenSequence, GroovyTokenId.LBRACKET, GroovyTokenId.RBRACKET);
                    int[] nArray = new int[]{offsetRange.getStart(), offsetRange.getEnd()};
                    return nArray;
                }
            }
            token = null;
            return token;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }
}

