/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.platforms.Platforms;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MakeSampleProjectGenerator {
    private static final String PROJECT_CONFIGURATION_NAMESPACE = "http://www.netbeans.org/ns/make-project/1";
    private static final String PROJECT_CONFIGURATION_FILE = "nbproject/configurations.xml";

    private MakeSampleProjectGenerator() {
    }

    public static Set<DataObject> createProjectFromTemplate(FileObject fileObject, File file, String string) throws IOException {
        String string2 = (String)fileObject.getAttribute("mainProjectLocation");
        String string3 = (String)fileObject.getAttribute("subProjectLocations");
        if (string2 != null) {
            File file2 = new File(file.getPath() + File.separator + string2);
            File[] fileArray = null;
            if (string3 != null) {
                Vector<File> vector = new Vector<File>();
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    vector.add(new File(file.getPath() + File.separator + stringTokenizer.nextToken()));
                }
                fileArray = vector.toArray(new File[vector.size()]);
            }
            return MakeSampleProjectGenerator.createProjectFromTemplate(fileObject.getInputStream(), file, file2, fileArray, string);
        }
        return MakeSampleProjectGenerator.createProjectFromTemplate(fileObject.getInputStream(), file, string);
    }

    public static Set<DataObject> createProjectFromTemplate(URL uRL, File file, String string) throws IOException {
        return MakeSampleProjectGenerator.createProjectFromTemplate(uRL.openStream(), file, string);
    }

    private static void postProcessProject(FileObject fileObject, String string) throws IOException {
        try {
            fileObject.getFileSystem().refresh(false);
            FileObject fileObject2 = fileObject.getFileObject("nbproject/project.xml");
            File file = FileUtil.toFile((FileObject)fileObject2);
            Document document = XMLUtil.parse((InputSource)new InputSource(file.toURI().toString()), (boolean)false, (boolean)true, null, null);
            if (string != null) {
                MakeSampleProjectGenerator.changeXmlFileByNameNS(document, PROJECT_CONFIGURATION_NAMESPACE, "name", string, null);
            }
            MakeSampleProjectGenerator.saveXml(document, fileObject, "nbproject/project.xml");
            String string2 = MakeSampleProjectGenerator.getCurrentSystemOs();
            file = FileUtil.toFile((FileObject)fileObject.getFileObject(PROJECT_CONFIGURATION_FILE));
            document = XMLUtil.parse((InputSource)new InputSource(file.toURI().toString()), (boolean)false, (boolean)true, null, null);
            MakeSampleProjectGenerator.changeXmlFileByTagName(document, "defaultConf", string2, "X-DEFAULTCONF-X");
            ExecutionEnvironment executionEnvironment = CompilerSetManager.getDefaultExecutionEnvironment();
            CompilerSetManager compilerSetManager = CompilerSetManager.getDefault((ExecutionEnvironment)executionEnvironment);
            int n = compilerSetManager.getPlatform();
            CompilerSet compilerSet = compilerSetManager.getDefaultCompilerSet();
            String string3 = null;
            if (compilerSet != null) {
                string3 = MakeConfiguration.getVariant(compilerSet, n);
            }
            if (n == 3) {
                MakeSampleProjectGenerator.changeXmlFileByTagName(document, "output", "lib", "X-LIBPREFIX-X");
                MakeSampleProjectGenerator.changeXmlFileByTagName(document, "output", "dll", "X-LIBSUFFIX-X");
                MakeSampleProjectGenerator.changeXmlFileByTagAttrName(document, "makeArtifact", "OP", "lib", "X-LIBPREFIX-X");
                MakeSampleProjectGenerator.changeXmlFileByTagAttrName(document, "makeArtifact", "OP", "dll", "X-LIBSUFFIX-X");
                if (string3 != null) {
                    MakeSampleProjectGenerator.changeXmlFileByTagAttrName(document, "makeArtifact", "OP", string3, "X-PLATFORM-X");
                }
            }
            if (n == 4) {
                MakeSampleProjectGenerator.changeXmlFileByTagName(document, "output", "lib", "X-LIBPREFIX-X");
                MakeSampleProjectGenerator.changeXmlFileByTagName(document, "output", "dylib", "X-LIBSUFFIX-X");
                MakeSampleProjectGenerator.changeXmlFileByTagAttrName(document, "makeArtifact", "OP", "lib", "X-LIBPREFIX-X");
                MakeSampleProjectGenerator.changeXmlFileByTagAttrName(document, "makeArtifact", "OP", "dylib", "X-LIBSUFFIX-X");
                if (string3 != null) {
                    MakeSampleProjectGenerator.changeXmlFileByTagAttrName(document, "makeArtifact", "OP", string3, "X-PLATFORM-X");
                }
            } else {
                MakeSampleProjectGenerator.changeXmlFileByTagName(document, "output", "lib", "X-LIBPREFIX-X");
                MakeSampleProjectGenerator.changeXmlFileByTagName(document, "output", "so", "X-LIBSUFFIX-X");
                MakeSampleProjectGenerator.changeXmlFileByTagAttrName(document, "makeArtifact", "OP", "lib", "X-LIBPREFIX-X");
                MakeSampleProjectGenerator.changeXmlFileByTagAttrName(document, "makeArtifact", "OP", "so", "X-LIBSUFFIX-X");
                if (string3 != null) {
                    MakeSampleProjectGenerator.changeXmlFileByTagAttrName(document, "makeArtifact", "OP", string3, "X-PLATFORM-X");
                }
            }
            MakeSampleProjectGenerator.saveXml(document, fileObject, PROJECT_CONFIGURATION_FILE);
            MakeSampleProjectGenerator.recordCreateSampleProject(executionEnvironment);
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            iOException.initCause(exception);
            throw iOException;
        }
    }

    private static void recordCreateSampleProject(ExecutionEnvironment executionEnvironment) {
        String string;
        String string2;
        String[] stringArray;
        Logger logger = Logger.getLogger("org.netbeans.ui.metrics.cnd");
        if (!logger.isLoggable(Level.INFO)) {
            return;
        }
        CompilerSetManager compilerSetManager = CompilerSetManager.getDefault((ExecutionEnvironment)executionEnvironment);
        CompilerSet compilerSet = compilerSetManager.getDefaultCompilerSet();
        LogRecord logRecord = new LogRecord(Level.INFO, "USG_PROJECT_CREATE_CND");
        logRecord.setLoggerName(logger.getName());
        String string3 = compilerSetManager.getExecutionEnvironment().isLocal() ? "LOCAL" : "REMOTE";
        String string4 = compilerSet != null && Platforms.getPlatform(compilerSetManager.getPlatform()) != null ? Platforms.getPlatform(compilerSetManager.getPlatform()).getName() : "UNKNOWN_PLATFORM";
        if (compilerSet != null) {
            stringArray = compilerSet.getCompilerFlavor().getToolchainDescriptor().getFamily();
            string2 = compilerSet.getCompilerFlavor().toString();
        } else {
            stringArray = new String[]{};
            string2 = "UKNOWN";
        }
        if (stringArray.length == 0) {
            string = "UKNOWN";
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append(stringArray[i]);
                if (i >= stringArray.length - 1) continue;
                stringBuilder.append(",");
            }
            string = stringBuilder.toString();
        }
        logRecord.setParameters(new Object[]{"APPLICATION", string2, string, string3, string4, "SAMPLE_PROJECT"});
        logger.log(logRecord);
    }

    public static Set<DataObject> createProjectFromTemplate(InputStream inputStream, File file, String string) throws IOException {
        MakeSampleProjectGenerator.unzip(inputStream, file);
        FileObject fileObject = FileUtil.toFileObject((File)file);
        MakeSampleProjectGenerator.postProcessProject(fileObject, string);
        fileObject.refresh(false);
        return Collections.singleton(DataObject.find((FileObject)fileObject));
    }

    private static void addToSet(Vector<DataObject> vector, File file) throws IOException {
        try {
            FileObject fileObject = null;
            fileObject = FileUtil.toFileObject((File)file);
            MakeSampleProjectGenerator.postProcessProject(fileObject, null);
            fileObject.refresh(false);
            vector.add(DataObject.find((FileObject)fileObject));
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            iOException.initCause(exception);
            throw iOException;
        }
    }

    public static Set<DataObject> createProjectFromTemplate(InputStream inputStream, File file, File file2, File[] fileArray, String string) throws IOException {
        Vector<DataObject> vector = new Vector<DataObject>();
        MakeSampleProjectGenerator.unzip(inputStream, file);
        MakeSampleProjectGenerator.addToSet(vector, file2);
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                MakeSampleProjectGenerator.addToSet(vector, fileArray[i]);
            }
        }
        return new LinkedHashSet<DataObject>(vector);
    }

    private static void changeXmlFileByNameNS(Document document, String string, String string2, String string3, String string4) throws IOException {
        NodeList nodeList = document.getElementsByTagNameNS(string, string2);
        MakeSampleProjectGenerator.changeXmlFileByNodeList(nodeList, string3, string4);
    }

    private static void changeXmlFileByTagName(Document document, String string, String string2, String string3) throws IOException {
        NodeList nodeList = document.getElementsByTagName(string);
        MakeSampleProjectGenerator.changeXmlFileByNodeList(nodeList, string2, string3);
    }

    private static void changeXmlFileByTagAttrName(Document document, String string, String string2, String string3, String string4) throws IOException {
        NodeList nodeList = document.getElementsByTagName(string);
        MakeSampleProjectGenerator.changeXmlFileByAttrList(nodeList, string2, string3, string4);
    }

    private static void changeXmlFileByNodeList(NodeList nodeList, String string, String string2) throws IOException {
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                MakeSampleProjectGenerator.replaceText(element, string, string2);
            }
        }
    }

    private static void changeXmlFileByAttrList(NodeList nodeList, String string, String string2, String string3) throws IOException {
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element;
                Attr attr;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || (attr = (element = (Element)node).getAttributeNode(string)) == null) continue;
                attr.setValue(attr.getValue().replaceAll(string3, string2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(InputStream inputStream, File file) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                File file2 = new File(file, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    FileUtil.createFolder((File)file2);
                    continue;
                }
                FileUtil.createFolder((File)file2.getParentFile());
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                try {
                    MakeSampleProjectGenerator.copy(zipInputStream, fileOutputStream);
                }
                finally {
                    fileOutputStream.close();
                }
            }
        }
        finally {
            zipInputStream.close();
        }
    }

    private static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        while ((string = bufferedReader.readLine()) != null) {
            bufferedWriter.write(string + "\n");
        }
        bufferedWriter.flush();
    }

    private static void replaceText(Element element, String string, String string2) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            Text text = (Text)nodeList.item(i);
            if (string2 != null) {
                String string3 = text.getNodeValue();
                text.setNodeValue(string3.replaceAll(string2, string));
            } else {
                text.setNodeValue(string);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveXml(Document document, FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string);
        FileLock fileLock = fileObject2.lock();
        try {
            OutputStream outputStream = fileObject2.getOutputStream(fileLock);
            try {
                XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    private static String getCurrentSystemOs() {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.arch");
        if (string.toLowerCase().indexOf("linux") >= 0) {
            return "2";
        }
        if (string2.indexOf("86") >= 0) {
            return "1";
        }
        return "0";
    }
}

