/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptor;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptorProvider;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackagerManager {
    private static final PackagerManager instance = new PackagerManager();
    private final List<PackagerDescriptor> list = new ArrayList<PackagerDescriptor>();

    public static PackagerManager getDefault() {
        return instance;
    }

    private PackagerManager() {
    }

    private void addRegisteredPackagers() {
        Set<PackagerDescriptorProvider> set = PackagerManager.getPackagerDescriptorProviders();
        for (PackagerDescriptorProvider packagerDescriptorProvider : set) {
            List<PackagerDescriptor> list = packagerDescriptorProvider.getPackagerDescriptorProviderList();
            for (PackagerDescriptor packagerDescriptor : list) {
                this.addPackagingDescriptor(packagerDescriptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPackagingDescriptor(PackagerDescriptor packagerDescriptor) {
        List<PackagerDescriptor> list = this.list;
        synchronized (list) {
            PackagerDescriptor packagerDescriptor2 = this.getPackager(packagerDescriptor.getName());
            if (packagerDescriptor2 != null) {
                return;
            }
            this.list.add(packagerDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PackagerDescriptor> getPackagerList() {
        List<PackagerDescriptor> list = this.list;
        synchronized (list) {
            return new ArrayList<PackagerDescriptor>(this.list);
        }
    }

    public PackagerDescriptor getPackager(String string) {
        for (PackagerDescriptor packagerDescriptor : this.getPackagerList()) {
            if (!packagerDescriptor.getName().equals(string)) continue;
            return packagerDescriptor;
        }
        return null;
    }

    public int getNameIndex(String string) {
        int n = 0;
        for (PackagerDescriptor packagerDescriptor : this.getPackagerList()) {
            if (packagerDescriptor.getName().equals(string)) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public String[] getDisplayNames() {
        List<PackagerDescriptor> list = this.getPackagerList();
        String[] stringArray = new String[list.size()];
        int n = 0;
        for (PackagerDescriptor packagerDescriptor : list) {
            stringArray[n++] = packagerDescriptor.getDisplayName();
        }
        return stringArray;
    }

    public String getDisplayName(String string) {
        for (PackagerDescriptor packagerDescriptor : this.getPackagerList()) {
            if (!packagerDescriptor.getName().equals(string)) continue;
            return packagerDescriptor.getDisplayName();
        }
        return null;
    }

    public String getName(String string) {
        for (PackagerDescriptor packagerDescriptor : this.getPackagerList()) {
            if (!packagerDescriptor.getDisplayName().equals(string)) continue;
            return packagerDescriptor.getName();
        }
        return null;
    }

    private static Set<PackagerDescriptorProvider> getPackagerDescriptorProviders() {
        HashSet<PackagerDescriptorProvider> hashSet = new HashSet<PackagerDescriptorProvider>();
        Lookup.Template template = new Lookup.Template(PackagerDescriptorProvider.class);
        Lookup.Result result = Lookup.getDefault().lookup(template);
        for (Object e : result.allInstances()) {
            if (!(e instanceof PackagerDescriptorProvider)) continue;
            hashSet.add((PackagerDescriptorProvider)e);
        }
        return hashSet;
    }

    static {
        instance.addRegisteredPackagers();
    }
}

