/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsListener;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.api.compilers.BasicCompiler;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.FolderConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NativeProjectProvider
implements NativeProject,
PropertyChangeListener {
    private Project project;
    private ConfigurationDescriptorProvider projectDescriptorProvider;
    private final Set<NativeProjectItemsListener> listeners = new HashSet<NativeProjectItemsListener>();
    private Reference<List<NativeProject>> cachedDependency = new SoftReference<Object>(null);

    public NativeProjectProvider(Project project, ConfigurationDescriptorProvider configurationDescriptorProvider) {
        this.project = project;
        this.projectDescriptorProvider = configurationDescriptorProvider;
    }

    public void runOnCodeModelReadiness(Runnable runnable) {
        if (this.getMakeConfigurationDescriptor() != null) {
            this.getMakeConfigurationDescriptor().getConfs().runOnCodeModelReadiness(runnable);
        }
    }

    private void addMyListeners() {
        if (this.getMakeConfigurationDescriptor() != null) {
            this.getMakeConfigurationDescriptor().getConfs().addPropertyChangeListener(this);
        }
    }

    private void removeMyListeners() {
        if (this.getMakeConfigurationDescriptor() != null) {
            this.getMakeConfigurationDescriptor().getConfs().removePropertyChangeListener(this);
        }
    }

    private MakeConfigurationDescriptor getMakeConfigurationDescriptor() {
        return this.projectDescriptorProvider.getConfigurationDescriptor();
    }

    private MakeConfiguration getMakeConfiguration() {
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor();
        if (makeConfigurationDescriptor != null) {
            return makeConfigurationDescriptor.getActiveConfiguration();
        }
        return null;
    }

    public Object getProject() {
        return this.project;
    }

    public List<String> getSourceRoots() {
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor();
        if (makeConfigurationDescriptor != null) {
            return makeConfigurationDescriptor.getAbsoluteSourceRoots();
        }
        return Collections.emptyList();
    }

    public String getProjectRoot() {
        return FileUtil.toFile((FileObject)this.project.getProjectDirectory()).getPath();
    }

    public String getProjectDisplayName() {
        return ProjectUtils.getInformation((Project)this.project).getDisplayName();
    }

    public List<NativeFileItem> getAllFiles() {
        ArrayList<NativeFileItem> arrayList = new ArrayList<NativeFileItem>();
        if (this.getMakeConfigurationDescriptor() == null || this.getMakeConfiguration() == null) {
            return arrayList;
        }
        Item[] itemArray = this.getMakeConfigurationDescriptor().getProjectItems();
        for (int i = 0; i < itemArray.length; ++i) {
            ItemConfiguration itemConfiguration = itemArray[i].getItemConfiguration(this.getMakeConfiguration());
            if (itemConfiguration == null) continue;
            if (itemConfiguration.isCompilerToolConfiguration()) {
                arrayList.add(itemArray[i]);
                continue;
            }
            if (!itemArray[i].hasHeaderOrSourceExtension(true, true)) continue;
            arrayList.add(itemArray[i]);
        }
        return arrayList;
    }

    public List<NativeProject> getDependences() {
        List<Object> list = this.cachedDependency.get();
        if (list == null) {
            list = new ArrayList<NativeProject>(0);
            MakeConfiguration makeConfiguration = this.getMakeConfiguration();
            int n = 0;
            NativeProject nativeProject = null;
            if (makeConfiguration != null) {
                for (Project project : makeConfiguration.getSubProjects()) {
                    Project project2 = project;
                    NativeProject nativeProject2 = (NativeProject)project2.getLookup().lookup(NativeProject.class);
                    if (nativeProject2 == null) continue;
                    list.add(nativeProject2);
                    ++n;
                    nativeProject = nativeProject2;
                }
            }
            list = n == 0 ? Collections.emptyList() : (n == 1 ? Collections.singletonList(nativeProject) : Collections.unmodifiableList(list));
            this.cachedDependency = new SoftReference<List<NativeProject>>(list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProjectItemsListener(NativeProjectItemsListener nativeProjectItemsListener) {
        Set<NativeProjectItemsListener> set = this.listeners;
        synchronized (set) {
            if (this.listeners.size() == 0) {
                this.addMyListeners();
            }
            this.listeners.add(nativeProjectItemsListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProjectItemsListener(NativeProjectItemsListener nativeProjectItemsListener) {
        Set<NativeProjectItemsListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(nativeProjectItemsListener);
            if (this.listeners.size() == 0) {
                this.removeMyListeners();
            }
        }
    }

    public void fireFilesAdded(List<NativeFileItem> list) {
        ArrayList<NativeFileItem> arrayList = new ArrayList<NativeFileItem>();
        for (NativeFileItem object : list) {
            int nativeProjectItemsListener = ((Item)object).getDefaultTool();
            if (nativeProjectItemsListener == 3 && !"text/x-h".equals(((Item)object).getMIMEType())) continue;
            arrayList.add(object);
        }
        if (arrayList.size() > 0) {
            for (NativeProjectItemsListener nativeProjectItemsListener : this.getListenersCopy()) {
                if (arrayList.size() == 1) {
                    nativeProjectItemsListener.fileAdded((NativeFileItem)arrayList.get(0));
                    continue;
                }
                nativeProjectItemsListener.filesAdded(arrayList);
            }
        }
    }

    public void fireFilesRemoved(List<NativeFileItem> list) {
        ArrayList<NativeFileItem> arrayList = new ArrayList<NativeFileItem>();
        for (NativeFileItem object : list) {
            ItemConfiguration itemConfiguration = ((Item)object).getItemConfiguration(this.getMakeConfiguration());
            if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration() && !"text/x-h".equals(((Item)object).getMIMEType())) continue;
            arrayList.add(object);
        }
        if (arrayList.size() > 0) {
            for (NativeProjectItemsListener nativeProjectItemsListener : this.getListenersCopy()) {
                if (arrayList.size() == 1) {
                    nativeProjectItemsListener.fileRemoved((NativeFileItem)arrayList.get(0));
                    continue;
                }
                nativeProjectItemsListener.filesRemoved(arrayList);
            }
        }
    }

    public void fireFileRenamed(String string, NativeFileItem nativeFileItem) {
        for (NativeProjectItemsListener nativeProjectItemsListener : this.getListenersCopy()) {
            nativeProjectItemsListener.fileRenamed(string, nativeFileItem);
        }
    }

    public void fireFilePropertiesChanged(NativeFileItem nativeFileItem) {
        for (NativeProjectItemsListener nativeProjectItemsListener : this.getListenersCopy()) {
            nativeProjectItemsListener.filePropertiesChanged(nativeFileItem);
        }
    }

    public void fireFilesPropertiesChanged(List<NativeFileItem> list) {
        for (NativeProjectItemsListener nativeProjectItemsListener : this.getListenersCopy()) {
            nativeProjectItemsListener.filesPropertiesChanged(list);
        }
    }

    public void fireFilesPropertiesChanged() {
        for (NativeProjectItemsListener nativeProjectItemsListener : this.getListenersCopy()) {
            nativeProjectItemsListener.filesPropertiesChanged();
        }
    }

    public void fireProjectDeleted() {
        for (NativeProjectItemsListener nativeProjectItemsListener : this.getListenersCopy()) {
            nativeProjectItemsListener.projectDeleted((NativeProject)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<NativeProjectItemsListener> getListenersCopy() {
        Set<NativeProjectItemsListener> set = this.listeners;
        synchronized (set) {
            return this.listeners.size() == 0 ? Collections.EMPTY_LIST : new ArrayList<NativeProjectItemsListener>(this.listeners);
        }
    }

    public NativeFileItem findFileItem(File file) {
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor();
        if (makeConfigurationDescriptor != null) {
            return makeConfigurationDescriptor.findItemByFile(file);
        }
        return null;
    }

    private void checkConfigurationChanged(final Configuration configuration, final Configuration configuration2) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                NativeProjectProvider.this.checkConfigurationChangedWorker(configuration, configuration2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConfigurationChangedWorker(Configuration configuration, Configuration configuration2) {
        MakeConfiguration makeConfiguration = (MakeConfiguration)configuration;
        MakeConfiguration makeConfiguration2 = (MakeConfiguration)configuration2;
        ArrayList<NativeFileItem> arrayList = new ArrayList<NativeFileItem>();
        ArrayList<NativeFileItem> arrayList2 = new ArrayList<NativeFileItem>();
        ArrayList<NativeFileItem> arrayList3 = new ArrayList<NativeFileItem>();
        CompilerSet compilerSet = this.listeners;
        synchronized (compilerSet) {
            if (this.listeners.size() == 0) {
                return;
            }
        }
        if (configuration2 == null) {
            System.err.println("Nativeprojectprovider - checkConfigurationChanged - newConf is null!");
            return;
        }
        if (!configuration2.isDefault()) {
            return;
        }
        ConfigurationDescriptorProvider.recordMetrics("USG_PROJECT_CONFIG_CND", this.getMakeConfigurationDescriptor());
        if (configuration == null) {
            this.firePropertiesChanged(this.getMakeConfigurationDescriptor().getProjectItems(), true, true, true);
            MakeLogicalViewProvider.checkForChangedItems(this.getMakeConfigurationDescriptor().getProject(), null, null);
            MakeLogicalViewProvider.checkForChangedName(this.getMakeConfigurationDescriptor().getProject());
            return;
        }
        if (!makeConfiguration.getCompilerSet().getName().equals(makeConfiguration2.getCompilerSet().getName()) || !makeConfiguration.getDevelopmentHost().getExecutionEnvironment().equals(makeConfiguration2.getDevelopmentHost().getExecutionEnvironment())) {
            this.fireFilesPropertiesChanged();
            MakeLogicalViewProvider.checkForChangedItems(this.getMakeConfigurationDescriptor().getProject(), null, null);
            if (!makeConfiguration.getDevelopmentHost().getExecutionEnvironment().equals(makeConfiguration2.getDevelopmentHost().getExecutionEnvironment())) {
                MakeLogicalViewProvider.checkForChangedName(this.getMakeConfigurationDescriptor().getProject());
            }
            return;
        }
        compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
        CompilerSet compilerSet2 = makeConfiguration2.getCompilerSet().getCompilerSet();
        Item[] itemArray = this.getMakeConfigurationDescriptor().getProjectItems();
        Project project = this.getMakeConfigurationDescriptor().getProject();
        for (int i = 0; i < itemArray.length; ++i) {
            ItemConfiguration itemConfiguration = itemArray[i].getItemConfiguration(makeConfiguration);
            ItemConfiguration itemConfiguration2 = itemArray[i].getItemConfiguration(makeConfiguration2);
            if (itemConfiguration == null || itemConfiguration2 == null) continue;
            if (itemConfiguration2.getExcluded().getValue() ^ itemConfiguration.getExcluded().getValue() && (itemConfiguration2.getTool() == 0 || itemConfiguration2.getTool() == 1 || itemArray[i].hasHeaderOrSourceExtension(true, true))) {
                if (itemConfiguration2.getExcluded().getValue()) {
                    arrayList3.add(itemArray[i]);
                } else {
                    arrayList2.add(itemArray[i]);
                }
                MakeLogicalViewProvider.checkForChangedItems(project, null, itemArray[i]);
            }
            if (itemConfiguration2.getExcluded().getValue()) continue;
            if (itemConfiguration2.getTool() == 0) {
                if (itemConfiguration.getTool() != 0) {
                    arrayList.add(itemArray[i]);
                    continue;
                }
                if (!itemConfiguration.getCCompilerConfiguration().getPreprocessorOptions().equals(itemConfiguration2.getCCompilerConfiguration().getPreprocessorOptions())) {
                    arrayList.add(itemArray[i]);
                    continue;
                }
                if (!itemConfiguration.getCCompilerConfiguration().getIncludeDirectoriesOptions(compilerSet).equals(itemConfiguration2.getCCompilerConfiguration().getIncludeDirectoriesOptions(compilerSet2))) {
                    arrayList.add(itemArray[i]);
                    continue;
                }
            }
            if (itemConfiguration2.getTool() != 1) continue;
            if (itemConfiguration.getTool() != 1) {
                arrayList.add(itemArray[i]);
                continue;
            }
            if (!itemConfiguration.getCCCompilerConfiguration().getPreprocessorOptions().equals(itemConfiguration2.getCCCompilerConfiguration().getPreprocessorOptions())) {
                arrayList.add(itemArray[i]);
                continue;
            }
            if (itemConfiguration.getCCCompilerConfiguration().getIncludeDirectoriesOptions(compilerSet).equals(itemConfiguration2.getCCCompilerConfiguration().getIncludeDirectoriesOptions(compilerSet2))) continue;
            arrayList.add(itemArray[i]);
        }
        this.fireFilesRemoved(arrayList3);
        this.fireFilesAdded(arrayList2);
        this.firePropertiesChanged(arrayList, true);
    }

    public void checkForChangedItems(final Folder folder, final Item item) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                NativeProjectProvider.this.checkForChangedItemsWorker(folder, item);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForChangedItemsWorker(Folder folder, Item item) {
        Item[] itemArray;
        this.clearCache();
        Object object = this.listeners;
        synchronized (object) {
            if (this.listeners.size() == 0) {
                return;
            }
        }
        object = this.getMakeConfiguration();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        VectorConfiguration<String> vectorConfiguration = null;
        BooleanConfiguration booleanConfiguration = null;
        VectorConfiguration<String> vectorConfiguration2 = null;
        BooleanConfiguration booleanConfiguration2 = null;
        VectorConfiguration<String> vectorConfiguration3 = null;
        BooleanConfiguration booleanConfiguration3 = null;
        VectorConfiguration<String> vectorConfiguration4 = null;
        BooleanConfiguration booleanConfiguration4 = null;
        if (((MakeConfiguration)object).getDevelopmentHost().getDirty()) {
            ((MakeConfiguration)object).getDevelopmentHost().setDirty(false);
            Item[] itemArray2 = this.getMakeConfigurationDescriptor().getProjectItems();
            this.firePropertiesChanged(itemArray2, true, true, true);
            return;
        }
        if (((MakeConfiguration)object).getCompilerSet().getDirty()) {
            ((MakeConfiguration)object).getCompilerSet().setDirty(false);
            itemArray = this.getMakeConfigurationDescriptor().getProjectItems();
            this.firePropertiesChanged(itemArray, true, true, true);
        }
        if (folder != null) {
            FolderConfiguration folderConfiguration = folder.getFolderConfiguration((Configuration)object);
            vectorConfiguration = folderConfiguration.getCCompilerConfiguration().getIncludeDirectories();
            booleanConfiguration = folderConfiguration.getCCompilerConfiguration().getInheritIncludes();
            vectorConfiguration2 = folderConfiguration.getCCompilerConfiguration().getPreprocessorConfiguration();
            booleanConfiguration2 = folderConfiguration.getCCompilerConfiguration().getInheritPreprocessor();
            vectorConfiguration3 = folderConfiguration.getCCCompilerConfiguration().getIncludeDirectories();
            booleanConfiguration3 = folderConfiguration.getCCCompilerConfiguration().getInheritIncludes();
            vectorConfiguration4 = folderConfiguration.getCCCompilerConfiguration().getPreprocessorConfiguration();
            booleanConfiguration4 = folderConfiguration.getCCCompilerConfiguration().getInheritPreprocessor();
            itemArray = folder.getAllItemsAsArray();
        } else if (item != null) {
            ItemConfiguration itemConfiguration = item.getItemConfiguration(this.getMakeConfiguration());
            if (itemConfiguration.getTool() == 0) {
                vectorConfiguration = itemConfiguration.getCCompilerConfiguration().getIncludeDirectories();
                booleanConfiguration = itemConfiguration.getCCompilerConfiguration().getInheritIncludes();
                booleanConfiguration2 = itemConfiguration.getCCompilerConfiguration().getInheritPreprocessor();
                vectorConfiguration2 = itemConfiguration.getCCompilerConfiguration().getPreprocessorConfiguration();
            }
            if (itemConfiguration.getTool() == 1) {
                vectorConfiguration3 = itemConfiguration.getCCCompilerConfiguration().getIncludeDirectories();
                booleanConfiguration3 = itemConfiguration.getCCCompilerConfiguration().getInheritIncludes();
                vectorConfiguration4 = itemConfiguration.getCCCompilerConfiguration().getPreprocessorConfiguration();
                booleanConfiguration4 = itemConfiguration.getCCCompilerConfiguration().getInheritPreprocessor();
            }
            if (itemConfiguration.getExcluded().getDirty()) {
                itemConfiguration.getExcluded().setDirty(false);
                ArrayList<NativeFileItem> arrayList = new ArrayList<NativeFileItem>();
                arrayList.add(item);
                if (itemConfiguration.getExcluded().getValue()) {
                    this.fireFilesRemoved(arrayList);
                } else {
                    this.fireFilesAdded(arrayList);
                }
            }
            itemArray = new Item[]{item};
        } else {
            bl3 = ((MakeConfiguration)object).getRequiredProjectsConfiguration().getDirty() || ((MakeConfiguration)object).getLinkerConfiguration().getLibrariesConfiguration().getDirty();
            vectorConfiguration = ((MakeConfiguration)object).getCCompilerConfiguration().getIncludeDirectories();
            booleanConfiguration = ((MakeConfiguration)object).getCCompilerConfiguration().getInheritIncludes();
            vectorConfiguration2 = ((MakeConfiguration)object).getCCompilerConfiguration().getPreprocessorConfiguration();
            booleanConfiguration2 = ((MakeConfiguration)object).getCCompilerConfiguration().getInheritPreprocessor();
            vectorConfiguration3 = ((MakeConfiguration)object).getCCCompilerConfiguration().getIncludeDirectories();
            booleanConfiguration3 = ((MakeConfiguration)object).getCCCompilerConfiguration().getInheritIncludes();
            vectorConfiguration4 = ((MakeConfiguration)object).getCCCompilerConfiguration().getPreprocessorConfiguration();
            booleanConfiguration4 = ((MakeConfiguration)object).getCCCompilerConfiguration().getInheritPreprocessor();
            itemArray = this.getMakeConfigurationDescriptor().getProjectItems();
            bl4 = true;
        }
        if (vectorConfiguration != null && (vectorConfiguration.getDirty() || vectorConfiguration2.getDirty() || booleanConfiguration.getDirty() || booleanConfiguration2.getDirty())) {
            bl = true;
            vectorConfiguration.setDirty(false);
            vectorConfiguration2.setDirty(false);
            booleanConfiguration.setDirty(false);
            booleanConfiguration2.setDirty(false);
        }
        if (vectorConfiguration3 != null && (vectorConfiguration3.getDirty() || vectorConfiguration4.getDirty() || booleanConfiguration3.getDirty() || booleanConfiguration4.getDirty())) {
            bl2 = true;
            vectorConfiguration3.setDirty(false);
            vectorConfiguration4.setDirty(false);
            booleanConfiguration3.setDirty(false);
            booleanConfiguration4.setDirty(false);
        }
        if (bl3) {
            ((MakeConfiguration)object).getRequiredProjectsConfiguration().setDirty(false);
            ((MakeConfiguration)object).getLinkerConfiguration().getLibrariesConfiguration().setDirty(false);
            bl = true;
            bl2 = true;
        }
        if (bl || bl2) {
            this.firePropertiesChanged(itemArray, bl, bl2, bl4);
        }
    }

    private void firePropertiesChanged(Item[] itemArray, boolean bl, boolean bl2, boolean bl3) {
        ArrayList<NativeFileItem> arrayList = new ArrayList<NativeFileItem>();
        ArrayList<NativeFileItem> arrayList2 = new ArrayList<NativeFileItem>();
        for (int i = 0; i < itemArray.length; ++i) {
            ItemConfiguration itemConfiguration = itemArray[i].getItemConfiguration(this.getMakeConfiguration());
            if (itemConfiguration == null) continue;
            if (itemConfiguration.getExcluded().getValue()) {
                arrayList2.add(itemArray[i]);
                continue;
            }
            if (!(bl && itemConfiguration.getTool() == 0 || bl2 && itemConfiguration.getTool() == 1) && !itemArray[i].hasHeaderOrSourceExtension(bl, bl2)) continue;
            arrayList.add(itemArray[i]);
        }
        if (arrayList2.size() > 0) {
            this.fireFilesRemoved(arrayList2);
        }
        this.firePropertiesChanged(arrayList, bl3);
    }

    private void firePropertiesChanged(List<NativeFileItem> list, boolean bl) {
        if (list.size() > 1 || bl && list.size() == 1) {
            this.fireFilesPropertiesChanged(list);
        } else if (list.size() == 1) {
            this.fireFilePropertiesChanged(list.get(0));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("activeconfiguration")) {
            this.checkConfigurationChanged((Configuration)propertyChangeEvent.getOldValue(), (Configuration)propertyChangeEvent.getNewValue());
        }
    }

    public List<String> getSystemIncludePaths() {
        ArrayList<String> arrayList = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration != null) {
            CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
            if (compilerSet == null) {
                return arrayList;
            }
            BasicCompiler basicCompiler = (BasicCompiler)compilerSet.getTool(1);
            if (basicCompiler != null) {
                arrayList.addAll(basicCompiler.getSystemIncludeDirectories());
            }
        }
        return arrayList;
    }

    public List<String> getUserIncludePaths() {
        ArrayList<String> arrayList = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration != null) {
            CCCompilerConfiguration cCCompilerConfiguration = makeConfiguration.getCCCompilerConfiguration();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.addAll(cCCompilerConfiguration.getIncludeDirectories().getValue());
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                arrayList.add(IpeUtils.toAbsolutePath((String)makeConfiguration.getBaseDir(), (String)((String)iterator.next())));
            }
        }
        return arrayList;
    }

    public List<String> getSystemMacroDefinitions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration != null) {
            CompilerSet compilerSet = makeConfiguration.getCompilerSet().getCompilerSet();
            if (compilerSet == null) {
                return arrayList;
            }
            BasicCompiler basicCompiler = (BasicCompiler)compilerSet.getTool(1);
            if (basicCompiler != null) {
                arrayList.addAll(basicCompiler.getSystemPreprocessorSymbols());
            }
        }
        return arrayList;
    }

    public List<String> getUserMacroDefinitions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        MakeConfiguration makeConfiguration = this.getMakeConfiguration();
        if (makeConfiguration != null) {
            CCCompilerConfiguration cCCompilerConfiguration = makeConfiguration.getCCCompilerConfiguration();
            arrayList.addAll(cCCompilerConfiguration.getPreprocessorConfiguration().getValue());
        }
        return arrayList;
    }

    public String toString() {
        return this.getProjectDisplayName() + " " + this.getProjectRoot();
    }

    private void clearCache() {
        this.cachedDependency.clear();
    }
}

