/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.java.nodes;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.WildcardType;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavacUtils {
    private static final String BOOLEAN_CODE = "Z";
    private static final String CHAR_CODE = "C";
    private static final String BYTE_CODE = "B";
    private static final String SHORT_CODE = "S";
    private static final String INT_CODE = "I";
    private static final String LONG_CODE = "J";
    private static final String FLOAT_CODE = "F";
    private static final String DOUBLE_CODE = "D";
    private static final String VOID_CODE = "V";
    private static final String BOOLEAN_STRING = "boolean";
    private static final String CHAR_STRING = "char";
    private static final String BYTE_STRING = "byte";
    private static final String SHORT_STRING = "short";
    private static final String INT_STRING = "int";
    private static final String LONG_STRING = "long";
    private static final String FLOAT_STRING = "float";
    private static final String DOUBLE_STRING = "double";
    private static final String VOID_STRING = "void";
    private static final DeclaredTypeResolver declaredTypeResolver = new DeclaredTypeResolver();
    private static final Logger LOGGER = Logger.getLogger(JavacUtils.class.getName());

    JavacUtils() {
    }

    public static String getVMMethodSignature(ExecutableElement executableElement, CompilationInfo compilationInfo) {
        return JavacUtils.getSignature(executableElement, compilationInfo);
    }

    public static String typeToVMSignature(String string) {
        int n;
        String string2 = string.replaceAll("\\.", "/");
        string2 = string2.startsWith(BOOLEAN_STRING) ? string2.replaceAll(BOOLEAN_STRING, BOOLEAN_CODE) : (string2.startsWith(CHAR_STRING) ? string2.replaceAll(CHAR_STRING, CHAR_CODE) : (string2.startsWith(BYTE_STRING) ? string2.replaceAll(BYTE_STRING, BYTE_CODE) : (string2.startsWith(SHORT_STRING) ? string2.replaceAll(SHORT_STRING, SHORT_CODE) : (string2.startsWith(INT_STRING) ? string2.replaceAll(INT_STRING, INT_CODE) : (string2.startsWith(LONG_STRING) ? string2.replaceAll(LONG_STRING, LONG_CODE) : (string2.startsWith(FLOAT_STRING) ? string2.replaceAll(FLOAT_STRING, FLOAT_CODE) : (string2.startsWith(DOUBLE_STRING) ? string2.replaceAll(DOUBLE_STRING, DOUBLE_CODE) : (string2.startsWith(VOID_STRING) ? string2.replaceAll(VOID_STRING, VOID_CODE) : ((n = string2.indexOf(91)) == -1 ? "L" + string2 + ";" : "L" + string2.substring(0, n) + ";" + string2.substring(n))))))))));
        while (string2.endsWith("[]")) {
            string2 = "[" + string2.substring(0, string2.length() - 2);
        }
        return string2;
    }

    private static String getSignature(ExecutableElement executableElement, CompilationInfo compilationInfo) {
        try {
            switch (executableElement.getKind()) {
                case METHOD: 
                case CONSTRUCTOR: 
                case STATIC_INIT: {
                    String string = JavacUtils.getParamsSignature(executableElement.getParameters(), compilationInfo);
                    String string2 = JavacUtils.typeToVMSignature(JavacUtils.getRealTypeName(executableElement.getReturnType(), compilationInfo));
                    return "(" + string + ")" + string2;
                }
            }
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.warning(illegalArgumentException.getMessage());
            return null;
        }
    }

    private static String getParamsSignature(List<? extends VariableElement> list, CompilationInfo compilationInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<? extends VariableElement> iterator = list.iterator();
        while (iterator.hasNext()) {
            TypeMirror typeMirror = iterator.next().asType();
            String string = JavacUtils.getRealTypeName(typeMirror, compilationInfo);
            String string2 = JavacUtils.typeToVMSignature(string);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private static String getRealTypeName(TypeMirror typeMirror, CompilationInfo compilationInfo) {
        TypeKind typeKind = typeMirror.getKind();
        if (typeKind.isPrimitive()) {
            return ((Object)typeMirror).toString();
        }
        switch (typeKind) {
            case VOID: {
                return ((Object)typeMirror).toString();
            }
            case DECLARED: {
                return ElementUtilities.getBinaryName((TypeElement)JavacUtils.getDeclaredType(typeMirror));
            }
            case ARRAY: {
                return JavacUtils.getRealTypeName(((ArrayType)typeMirror).getComponentType(), compilationInfo) + "[]";
            }
            case TYPEVAR: {
                List<? extends TypeMirror> list = compilationInfo.getTypes().directSupertypes(typeMirror);
                if (list.size() == 0) {
                    return "java.lang.Object";
                }
                if (list.size() > 1 && ((Object)list.get(0)).toString().equals("java.lang.Object") && JavacUtils.getDeclaredType(list.get(1)).getKind().isInterface()) {
                    return JavacUtils.getRealTypeName(list.get(1), compilationInfo);
                }
                return JavacUtils.getRealTypeName(list.get(0), compilationInfo);
            }
            case WILDCARD: {
                throw new IllegalArgumentException("Unexpected WILDCARD parameter: " + typeMirror);
            }
        }
        throw new IllegalArgumentException("Unexpected type parameter: " + typeMirror + " of kind " + (Object)((Object)typeKind));
    }

    private static TypeElement getDeclaredType(TypeMirror typeMirror) {
        return typeMirror.accept(declaredTypeResolver, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DeclaredTypeResolver
    implements TypeVisitor<TypeElement, Void> {
        private DeclaredTypeResolver() {
        }

        @Override
        public TypeElement visit(TypeMirror typeMirror, Void void_) {
            return null;
        }

        @Override
        public TypeElement visit(TypeMirror typeMirror) {
            return null;
        }

        @Override
        public TypeElement visitArray(ArrayType arrayType, Void void_) {
            return null;
        }

        @Override
        public TypeElement visitDeclared(DeclaredType declaredType, Void void_) {
            return (TypeElement)declaredType.asElement();
        }

        @Override
        public TypeElement visitError(ErrorType errorType, Void void_) {
            return null;
        }

        @Override
        public TypeElement visitExecutable(ExecutableType executableType, Void void_) {
            return null;
        }

        @Override
        public TypeElement visitNoType(NoType noType, Void void_) {
            return null;
        }

        @Override
        public TypeElement visitNull(NullType nullType, Void void_) {
            return null;
        }

        @Override
        public TypeElement visitPrimitive(PrimitiveType primitiveType, Void void_) {
            return null;
        }

        @Override
        public TypeElement visitTypeVariable(TypeVariable typeVariable, Void void_) {
            return null;
        }

        @Override
        public TypeElement visitUnknown(TypeMirror typeMirror, Void void_) {
            return null;
        }

        @Override
        public TypeElement visitWildcard(WildcardType wildcardType, Void void_) {
            return null;
        }
    }
}

