/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.pojson;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.codeviation.commons.patterns.Filter;
import org.codeviation.commons.reflect.ClassUtils;
import org.codeviation.commons.reflect.FieldUtils;
import org.codeviation.pojson.Pojson;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreInfo {
    private Class<?> clazz;
    private Kind kind;
    private Map<String, Field> fields;
    private Map<Field, String> names;
    private String namePrefix;

    public StoreInfo(Class<?> clazz) {
        this.clazz = clazz;
        Pojson.NamePrefix namePrefix = clazz.getAnnotation(Pojson.NamePrefix.class);
        this.namePrefix = namePrefix == null ? null : namePrefix.value();
    }

    public synchronized Kind getKind() {
        if (this.kind == null) {
            this.kind = StoreInfo.isJsonValueType(this.clazz) ? Kind.VALUE : (this.clazz.isArray() || ClassUtils.isSuperinterface(this.clazz, Iterable.class) ? Kind.ARRAY : Kind.OBJECT);
        }
        return this.kind;
    }

    public boolean isSkipNullValues(Field field) {
        if (this.clazz.isAnnotationPresent(Pojson.SkipNullValues.class)) {
            return true;
        }
        return field.isAnnotationPresent(Pojson.SkipNullValues.class);
    }

    public synchronized String getPojsonFieldName(Field field) {
        String string;
        if (this.names == null) {
            this.names = new HashMap<Field, String>();
        }
        if ((string = this.names.get(field)) != null) {
            return string;
        }
        Pojson.Name name = field.getAnnotation(Pojson.Name.class);
        if (name == null) {
            string = field.getName();
        } else {
            string = name.value();
            String string2 = string = string == null ? field.getName() : string;
        }
        if (this.namePrefix != null) {
            string = this.namePrefix + string;
        }
        this.names.put(field, string);
        return string;
    }

    public synchronized Collection<Field> getFields() {
        if (this.fields == null) {
            Class<?> clazz;
            Pojson.StopAt stopAt = this.clazz.getAnnotation(Pojson.StopAt.class);
            if (stopAt == null) {
                clazz = this.clazz;
            } else {
                clazz = stopAt.value();
                if (stopAt.value() == Pojson.StopAtCurrentClass.class) {
                    clazz = this.clazz;
                }
            }
            this.fields = FieldUtils.getAll(this.clazz, clazz, new FieldFilter());
        }
        return this.fields.values();
    }

    private static boolean isJsonValueType(Class clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz.isEnum()) {
            return true;
        }
        if (Boolean.class.equals((Object)clazz) || Byte.class.equals((Object)clazz) || Short.class.equals((Object)clazz) || Character.class.equals((Object)clazz) || Integer.class.equals((Object)clazz) || Long.class.equals((Object)clazz) || Float.class.equals((Object)clazz) || Double.class.equals((Object)clazz) || Void.class.equals((Object)clazz) || String.class.equals((Object)clazz)) {
            return true;
        }
        return Date.class.equals((Object)clazz) || ClassUtils.isSuperclass(clazz, Date.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FieldFilter
    implements Filter<Field> {
        private int[] positive;
        private int[] negative;

        public FieldFilter() {
            Pojson.ModifierNegative modifierNegative;
            Pojson.ModifierPositive modifierPositive = StoreInfo.this.clazz.getAnnotation(Pojson.ModifierPositive.class);
            if (modifierPositive != null) {
                this.positive = modifierPositive.value();
                if (this.positive.length == 0) {
                    this.positive = null;
                }
            }
            if ((modifierNegative = StoreInfo.this.clazz.getAnnotation(Pojson.ModifierNegative.class)) != null) {
                this.negative = modifierPositive.value();
                if (this.negative.length == 0) {
                    this.negative = null;
                }
            }
        }

        @Override
        public boolean accept(Field field) {
            if (field.isAnnotationPresent(Pojson.SuppressStoring.class)) {
                return false;
            }
            int n = field.getModifiers();
            if (this.positive != null) {
                for (int n2 : this.positive) {
                    if ((n & n2) != 0) continue;
                    return false;
                }
            }
            if (this.negative != null) {
                for (int n2 : this.negative) {
                    if ((n & n2) == 0) continue;
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        VALUE,
        OBJECT,
        ARRAY;

    }
}

