/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.commons.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import org.codeviation.commons.utils.StreamUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UrlUriUtil {
    private UrlUriUtil() {
    }

    public static InputStream getInputStream(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        return inputStream;
    }

    public static InputStream getInputStream(URI uRI) throws IOException {
        URLConnection uRLConnection = uRI.toURL().openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        return inputStream;
    }

    public static String asString(URI uRI) throws IOException {
        return UrlUriUtil.asString(uRI.toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String asString(URL uRL) throws IOException {
        InputStream inputStream = UrlUriUtil.getInputStream(uRL);
        try {
            String string = StreamUtil.asString(inputStream);
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    public static Iterator<String> asLines(URL uRL) throws IOException {
        return StreamUtil.asLines(UrlUriUtil.getInputStream(uRL));
    }

    public static Iterator<String> asLines(URI uRI) throws IOException {
        return StreamUtil.asLines(UrlUriUtil.getInputStream(uRI));
    }
}

