/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.debugger.ui.views.VariablesViewButtons;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.SessionProvider;
import org.netbeans.spi.viewmodel.AsynchronousModelFilter;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.Model;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.NodeModelFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.netbeans.spi.viewmodel.TreeExpansionModelFilter;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class ViewModelListener
extends DebuggerManagerAdapter {
    private String viewType;
    private JComponent view;
    private JComponent buttonsPane;
    private List models = new ArrayList(11);
    private List hyperModels;
    private List<? extends SessionProvider> sessionProviders;
    private Session currentSession;
    private List treeModels;
    private List treeModelFilters;
    private List treeExpansionModels;
    private List treeExpansionModelFilters;
    private List nodeModels;
    private List nodeModelFilters;
    private List tableModels;
    private List tableModelFilters;
    private List nodeActionsProviders;
    private List nodeActionsProviderFilters;
    private List columnModels;
    private List mm;
    private List asynchModelFilters;
    private List<AbstractButton> buttons;
    private JTabbedPane tabbedPane;
    private Image viewIcon;
    private SessionProvider providerToDisplay;
    private List<ViewModelListener> subListeners = new ArrayList<ViewModelListener>();
    private Preferences preferences = NbPreferences.forModule(ContextProvider.class).node("variables_view");
    private ViewPreferenceChangeListener prefListener = new ViewPreferenceChangeListener();
    private String propertiesHelpID = null;

    ViewModelListener(String string, JComponent jComponent, JComponent jComponent2, String string2, Image image) {
        this.viewType = string;
        this.view = jComponent;
        this.buttonsPane = jComponent2;
        this.propertiesHelpID = string2;
        this.viewIcon = image;
        this.setUp();
    }

    void setUp() {
        DebuggerManager.getDebuggerManager().addDebuggerListener("currentEngine", (DebuggerManagerListener)this);
        this.preferences.addPreferenceChangeListener(this.prefListener);
        this.updateModel();
    }

    synchronized void destroy() {
        Object object;
        boolean bl;
        DebuggerManager.getDebuggerManager().removeDebuggerListener("currentEngine", (DebuggerManagerListener)this);
        this.preferences.removePreferenceChangeListener(this.prefListener);
        boolean bl2 = bl = this.treeModels.size() > 0 || this.nodeModels.size() > 0 || this.tableModels.size() > 0;
        if (bl && this.view.getComponentCount() > 0 && !((object = (JComponent)this.view.getComponent(0)) instanceof JTabbedPane)) {
            Models.setModelsToView((JComponent)object, null);
        }
        this.models.clear();
        this.treeModels = null;
        this.treeModelFilters = null;
        this.treeExpansionModels = null;
        this.treeExpansionModelFilters = null;
        this.nodeModels = null;
        this.nodeModelFilters = null;
        this.tableModels = null;
        this.tableModelFilters = null;
        this.nodeActionsProviders = null;
        this.nodeActionsProviderFilters = null;
        this.columnModels = null;
        this.mm = null;
        this.asynchModelFilters = null;
        this.sessionProviders = null;
        this.currentSession = null;
        this.providerToDisplay = null;
        this.buttonsPane.removeAll();
        this.buttons = null;
        this.view.removeAll();
        for (ViewModelListener viewModelListener : this.subListeners) {
            viewModelListener.destroy();
        }
        this.subListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() != null) {
            ViewModelListener viewModelListener = this;
            synchronized (viewModelListener) {
                this.providerToDisplay = null;
            }
        }
        this.updateModel();
    }

    private synchronized void updateModel() {
        Customizer[] customizerArray2;
        String string;
        DebuggerManager debuggerManager;
        DebuggerManager debuggerManager2 = DebuggerManager.getDebuggerManager();
        DebuggerEngine debuggerEngine = debuggerManager2.getCurrentEngine();
        this.sessionProviders = debuggerEngine == null ? debuggerManager2.lookup(this.viewType, SessionProvider.class) : DebuggerManager.join((ContextProvider)debuggerEngine, (ContextProvider)debuggerManager2).lookup(this.viewType, SessionProvider.class);
        if (!this.sessionProviders.contains(this.providerToDisplay)) {
            this.providerToDisplay = null;
        }
        if (debuggerEngine == null && this.providerToDisplay == null && this.sessionProviders.size() > 0) {
            this.providerToDisplay = this.sessionProviders.get(0);
        }
        if (this.providerToDisplay != null) {
            debuggerEngine = null;
            debuggerManager = debuggerManager2;
            string = this.viewType + "/" + this.providerToDisplay.getTypeID();
        } else {
            debuggerManager = debuggerEngine != null ? DebuggerManager.join((ContextProvider)debuggerEngine, (ContextProvider)debuggerManager2) : debuggerManager2;
            string = this.viewType;
        }
        this.currentSession = debuggerManager2.getCurrentSession();
        this.treeModels = debuggerManager.lookup(string, TreeModel.class);
        this.treeModelFilters = debuggerManager.lookup(string, TreeModelFilter.class);
        this.treeExpansionModels = debuggerManager.lookup(string, TreeExpansionModel.class);
        this.treeExpansionModelFilters = debuggerManager.lookup(this.viewType, TreeExpansionModelFilter.class);
        this.nodeModels = debuggerManager.lookup(string, NodeModel.class);
        this.nodeModelFilters = debuggerManager.lookup(string, NodeModelFilter.class);
        this.tableModels = debuggerManager.lookup(string, TableModel.class);
        this.tableModelFilters = debuggerManager.lookup(string, TableModelFilter.class);
        this.nodeActionsProviders = debuggerManager.lookup(string, NodeActionsProvider.class);
        this.nodeActionsProviderFilters = debuggerManager.lookup(string, NodeActionsProviderFilter.class);
        this.columnModels = debuggerManager.lookup(string, ColumnModel.class);
        this.mm = debuggerManager.lookup(string, Model.class);
        this.asynchModelFilters = debuggerManager.lookup(string, AsynchronousModelFilter.class);
        String string2 = string;
        while (this.asynchModelFilters.isEmpty() && string2 != null) {
            int n = string2.lastIndexOf(47);
            string2 = n > 0 ? string2.substring(0, n) : null;
            this.asynchModelFilters = debuggerManager.lookup(string2, AsynchronousModelFilter.class);
        }
        if ("LocalsView".equals(this.viewType) && (VariablesViewButtons.isResultsViewNested() || VariablesViewButtons.isWatchesViewNested())) {
            this.hyperModels = new ArrayList();
            if (VariablesViewButtons.isResultsViewNested()) {
                this.hyperModels.add(this.createCompound("ResultsView"));
            }
            if (VariablesViewButtons.isWatchesViewNested()) {
                this.hyperModels.add(this.createCompound("WatchesView"));
            }
            Models.CompoundModel compoundModel = this.createCompound("LocalsView");
            this.hyperModels.add(compoundModel);
            this.hyperModels.add(compoundModel);
            this.hyperModels.add(new TreeModelFilter(){

                public Object getRoot(TreeModel treeModel) {
                    return treeModel.getRoot();
                }

                public Object[] getChildren(TreeModel treeModel, Object object, int n, int n2) throws UnknownTypeException {
                    Object[] objectArray = treeModel.getChildren(object, n, n2);
                    if (objectArray != null) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (!"HistoryNode".equals(objectArray[i].getClass().getSimpleName())) continue;
                            Object[] objectArray2 = new Object[objectArray.length - 1];
                            System.arraycopy(objectArray, 0, objectArray2, 0, i);
                            if (i + 1 < objectArray.length) {
                                System.arraycopy(objectArray, i + 1, objectArray2, i, objectArray.length - i - 1);
                            }
                            objectArray = objectArray2;
                        }
                    }
                    return objectArray;
                }

                public int getChildrenCount(TreeModel treeModel, Object object) throws UnknownTypeException {
                    return treeModel.getChildrenCount(object);
                }

                public boolean isLeaf(TreeModel treeModel, Object object) throws UnknownTypeException {
                    return false;
                }

                public void addModelListener(ModelListener modelListener) {
                }

                public void removeModelListener(ModelListener modelListener) {
                }
            });
        } else {
            this.hyperModels = null;
        }
        List list = debuggerManager.lookup(string, AbstractButton.class);
        this.buttons = new ArrayList<AbstractButton>();
        ArrayList<Customizer[]> arrayList = new ArrayList<Customizer[]>();
        for (Customizer[] customizerArray2 : list) {
            if (customizerArray2 instanceof JToggleButton) {
                this.buttons.add((AbstractButton)customizerArray2);
                continue;
            }
            arrayList.add(customizerArray2);
        }
        this.buttons.addAll(arrayList);
        this.tabbedPane = (JTabbedPane)debuggerManager.lookupFirst(string, JTabbedPane.class);
        ModelsChangeRefresher modelsChangeRefresher = new ModelsChangeRefresher();
        customizerArray2 = new Customizer[]{(Customizer)((Object)this.treeModels), (Customizer)((Object)this.treeModelFilters), (Customizer)((Object)this.treeExpansionModels), (Customizer)((Object)this.treeExpansionModelFilters), (Customizer)((Object)this.nodeModels), (Customizer)((Object)this.nodeModelFilters), (Customizer)((Object)this.tableModels), (Customizer)((Object)this.tableModelFilters), (Customizer)((Object)this.nodeActionsProviders), (Customizer)((Object)this.nodeActionsProviderFilters), (Customizer)((Object)this.columnModels), (Customizer)((Object)this.mm), (Customizer)((Object)this.asynchModelFilters)};
        for (int i = 0; i < customizerArray2.length; ++i) {
            Customizer customizer = customizerArray2[i];
            if (customizer == null) continue;
            customizer.addPropertyChangeListener(modelsChangeRefresher);
            customizer.setObject("load first");
            customizer.setObject("unload last");
        }
        this.refreshModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void refreshModel() {
        boolean bl;
        this.models.clear();
        if (this.treeModels == null) {
            return;
        }
        Object object = this.treeModels;
        synchronized (object) {
            this.models.add(new ArrayList(this.treeModels));
        }
        object = this.treeModelFilters;
        synchronized (object) {
            this.models.add(new ArrayList(this.treeModelFilters));
        }
        object = this.treeExpansionModels;
        synchronized (object) {
            this.models.add(new ArrayList(this.treeExpansionModels));
        }
        object = this.nodeModels;
        synchronized (object) {
            this.models.add(new ArrayList(this.nodeModels));
        }
        object = this.nodeModelFilters;
        synchronized (object) {
            this.models.add(new ArrayList(this.nodeModelFilters));
        }
        object = this.tableModels;
        synchronized (object) {
            this.models.add(new ArrayList(this.tableModels));
        }
        object = this.tableModelFilters;
        synchronized (object) {
            this.models.add(new ArrayList(this.tableModelFilters));
        }
        object = this.nodeActionsProviders;
        synchronized (object) {
            this.models.add(new ArrayList(this.nodeActionsProviders));
        }
        object = this.nodeActionsProviderFilters;
        synchronized (object) {
            this.models.add(new ArrayList(this.nodeActionsProviderFilters));
        }
        object = this.columnModels;
        synchronized (object) {
            this.models.add(new ArrayList(this.columnModels));
        }
        object = this.mm;
        synchronized (object) {
            this.models.add(new ArrayList(this.mm));
        }
        object = this.treeExpansionModelFilters;
        synchronized (object) {
            this.models.add(new ArrayList(this.treeExpansionModelFilters));
        }
        object = this.asynchModelFilters;
        synchronized (object) {
            this.models.add(new ArrayList(this.asynchModelFilters));
        }
        List<AbstractButton> list = this.buttons;
        synchronized (list) {
            this.buttonsPane.removeAll();
            if (this.buttons.size() == 0 && this.sessionProviders.size() == 0) {
                this.buttonsPane.setVisible(false);
                object = null;
            } else {
                Serializable serializable;
                Object object2;
                this.buttonsPane.setVisible(true);
                int n = 0;
                if (this.sessionProviders.size() > 0) {
                    object2 = this.createSessionsSwitchButton();
                    Serializable serializable2 = new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0);
                    this.buttonsPane.add((Component)object2, serializable2);
                    serializable = new JSeparator(0);
                    serializable2 = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 0, 5, 0), 0, 0);
                    this.buttonsPane.add((Component)serializable, serializable2);
                    ++n;
                }
                if (this.tabbedPane != null) {
                    object = new JPanel();
                    ((Container)object).setLayout(new GridBagLayout());
                    object2 = new GridBagConstraints(0, n, 1, 1, 0.0, 1.0, 11, 3, new Insets(5, 0, 5, 0), 0, 0);
                    this.buttonsPane.add((Component)object, object2);
                    ++n;
                } else {
                    object = null;
                    for (Serializable serializable2 : this.buttons) {
                        serializable = new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0);
                        this.buttonsPane.add((Component)serializable2, serializable);
                        ++n;
                    }
                }
            }
        }
        boolean bl2 = bl = this.treeModels.size() > 0 || this.nodeModels.size() > 0 || this.tableModels.size() > 0 || this.hyperModels != null;
        final Models.CompoundModel compoundModel = this.hyperModels != null ? Models.createCompoundModel((List)this.hyperModels, (String)this.propertiesHelpID) : (bl ? Models.createCompoundModel((List)this.models, (String)this.propertiesHelpID) : null);
        SwingUtilities.invokeLater(new Runnable((JComponent)object){
            final /* synthetic */ JComponent val$buttonsSubPane;
            {
                this.val$buttonsSubPane = jComponent;
            }

            public void run() {
                if (ViewModelListener.this.view.getComponentCount() > 0) {
                    if (ViewModelListener.this.tabbedPane == null && ViewModelListener.this.view.getComponent(0) instanceof JTabbedPane) {
                        ViewModelListener.this.view.removeAll();
                    } else if (ViewModelListener.this.tabbedPane != null) {
                        ViewModelListener.this.view.removeAll();
                    }
                }
                if (ViewModelListener.this.view.getComponentCount() == 0) {
                    if (bl) {
                        ViewModelListener.this.view.add(Models.createView((Models.CompoundModel)compoundModel));
                        ViewModelListener.this.view.revalidate();
                        ViewModelListener.this.view.repaint();
                    } else if (ViewModelListener.this.tabbedPane != null) {
                        int n = ViewModelListener.this.tabbedPane.getTabCount();
                        for (int i = 0; i < n; ++i) {
                            Component component = ViewModelListener.this.tabbedPane.getComponentAt(i);
                            if (component instanceof JPanel) {
                                component = (Component)((JPanel)component).getClientProperty(JLabel.class.getName());
                            }
                            if (!(component instanceof JLabel)) continue;
                            String string = ((JLabel)component).getText();
                            if (ViewModelListener.this.providerToDisplay != null) {
                                string = ViewModelListener.this.providerToDisplay.getTypeID() + "/" + string;
                            }
                            JPanel jPanel = new JPanel(new BorderLayout());
                            ViewModelListener.this.subListeners.add(new ViewModelListener(ViewModelListener.this.viewType + "/" + string, jPanel, this.val$buttonsSubPane, ViewModelListener.this.propertiesHelpID, ViewModelListener.this.viewIcon));
                            ViewModelListener.this.tabbedPane.setComponentAt(i, jPanel);
                            jPanel.putClientProperty(JLabel.class.getName(), component);
                        }
                        ViewModelListener.this.view.add(ViewModelListener.this.tabbedPane);
                        ViewModelListener.this.view.revalidate();
                        ViewModelListener.this.view.repaint();
                    }
                } else if (ViewModelListener.this.tabbedPane == null) {
                    if (!bl) {
                        ViewModelListener.this.view.removeAll();
                        ViewModelListener.this.view.revalidate();
                        ViewModelListener.this.view.repaint();
                    } else {
                        JComponent jComponent = (JComponent)ViewModelListener.this.view.getComponent(0);
                        Models.setModelsToView((JComponent)jComponent, (Models.CompoundModel)compoundModel);
                    }
                }
            }
        });
    }

    private JButton createSessionsSwitchButton() {
        final JButton jButton = new JButton(new ImageIcon(this.viewIcon));
        jButton.setToolTipText(NbBundle.getMessage(ViewModelListener.class, (String)"Tooltip_SelectSrc"));
        jButton.setMargin(new Insets(2, 2, 2, 2));
        jButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == jButton) {
                    Object object;
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    if (ViewModelListener.this.currentSession != null) {
                        object = new JMenuItem(ViewModelListener.this.currentSession.getName());
                        ((JComponent)object).putClientProperty("SESSION", ViewModelListener.this.currentSession);
                        ((AbstractButton)object).addActionListener(this);
                        jPopupMenu.add((JMenuItem)object);
                    }
                    for (SessionProvider sessionProvider : ViewModelListener.this.sessionProviders) {
                        JMenuItem jMenuItem = new JMenuItem(sessionProvider.getSessionName());
                        jMenuItem.putClientProperty("SESSION", sessionProvider);
                        jMenuItem.addActionListener(this);
                        jPopupMenu.add(jMenuItem);
                    }
                    object = jButton.getMousePosition();
                    if (object == null) {
                        object = new Point(jButton.getWidth(), jButton.getHeight());
                    }
                    jPopupMenu.show(jButton, ((Point)object).x, ((Point)object).y);
                } else {
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    Object object = jMenuItem.getClientProperty("SESSION");
                    ViewModelListener viewModelListener = ViewModelListener.this;
                    synchronized (viewModelListener) {
                        if (object instanceof Session) {
                            ViewModelListener.this.providerToDisplay = null;
                        } else {
                            ViewModelListener.this.providerToDisplay = (SessionProvider)object;
                        }
                    }
                    ViewModelListener.this.updateModel();
                }
            }
        });
        return jButton;
    }

    private Models.CompoundModel createCompound(String string) {
        String string2;
        DebuggerManager debuggerManager;
        DebuggerManager debuggerManager2 = DebuggerManager.getDebuggerManager();
        DebuggerEngine debuggerEngine = debuggerManager2.getCurrentEngine();
        List list = debuggerEngine == null ? debuggerManager2.lookup(string, SessionProvider.class) : DebuggerManager.join((ContextProvider)debuggerEngine, (ContextProvider)debuggerManager2).lookup(string, SessionProvider.class);
        if (!list.contains(this.providerToDisplay)) {
            this.providerToDisplay = null;
        }
        if (debuggerEngine == null && this.providerToDisplay == null && list.size() > 0) {
            this.providerToDisplay = (SessionProvider)list.get(0);
        }
        if (this.providerToDisplay != null) {
            debuggerEngine = null;
            debuggerManager = debuggerManager2;
            string2 = string + "/" + this.providerToDisplay.getTypeID();
        } else {
            debuggerManager = debuggerEngine != null ? DebuggerManager.join((ContextProvider)debuggerEngine, (ContextProvider)debuggerManager2) : debuggerManager2;
            string2 = string;
        }
        List list2 = debuggerManager.lookup(string2, TreeModel.class);
        List list3 = debuggerManager.lookup(string2, TreeModelFilter.class);
        List list4 = debuggerManager.lookup(string2, TreeExpansionModel.class);
        List list5 = debuggerManager.lookup(string2, TreeExpansionModelFilter.class);
        List list6 = debuggerManager.lookup(string2, NodeModel.class);
        List list7 = debuggerManager.lookup(string2, NodeModelFilter.class);
        List list8 = debuggerManager.lookup(string2, TableModel.class);
        List list9 = debuggerManager.lookup(string2, TableModelFilter.class);
        List list10 = debuggerManager.lookup(string2, NodeActionsProvider.class);
        List list11 = debuggerManager.lookup(string2, NodeActionsProviderFilter.class);
        List list12 = debuggerManager.lookup(string2, ColumnModel.class);
        List list13 = debuggerManager.lookup(string2, Model.class);
        List list14 = debuggerManager.lookup(string2, AsynchronousModelFilter.class);
        String string3 = string2;
        while (list14.isEmpty() && string3 != null) {
            int n = string3.lastIndexOf(47);
            string3 = n > 0 ? string3.substring(0, n) : null;
            list14 = debuggerManager.lookup(string3, AsynchronousModelFilter.class);
        }
        ArrayList<List> arrayList = new ArrayList<List>(13);
        arrayList.add(list2);
        arrayList.add(list3);
        arrayList.add(list4);
        arrayList.add(list6);
        arrayList.add(list7);
        arrayList.add(list8);
        arrayList.add(list9);
        arrayList.add(list10);
        arrayList.add(list11);
        arrayList.add(list12);
        arrayList.add(list13);
        arrayList.add(list5);
        arrayList.add(list14);
        Models.CompoundModel compoundModel = Models.createCompoundModel(arrayList);
        return compoundModel;
    }

    private class ViewPreferenceChangeListener
    implements PreferenceChangeListener {
        private ViewPreferenceChangeListener() {
        }

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            String string = preferenceChangeEvent.getKey();
            if ("show_watches".equals(string) || "show_evaluator_result".equals(string)) {
                ViewModelListener.this.updateModel();
            }
        }
    }

    private class ModelsChangeRefresher
    implements PropertyChangeListener,
    Runnable {
        private RequestProcessor.Task task;

        private ModelsChangeRefresher() {
        }

        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.task == null) {
                this.task = new RequestProcessor(ModelsChangeRefresher.class.getName(), 1).create((Runnable)this);
            }
            this.task.schedule(1);
        }

        public void run() {
            ViewModelListener.this.refreshModel();
        }
    }
}

