/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.views;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import org.netbeans.modules.debugger.ui.actions.AddWatchAction;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class VariablesViewButtons {
    public static final String SHOW_WATCHES = "show_watches";
    public static final String SHOW_EVALUTOR_RESULT = "show_evaluator_result";
    public static final String PREFERENCES_NAME = "variables_view";

    public static JToggleButton createShowWatchesButton() {
        JToggleButton jToggleButton = VariablesViewButtons.createToggleButton(SHOW_WATCHES, "org/netbeans/modules/debugger/resources/localsView/show_watches_16.png", NbBundle.getMessage(VariablesViewButtons.class, (String)"Hint_Show_Watches"));
        jToggleButton.addActionListener(new ShowWatchesActionListener(jToggleButton));
        return jToggleButton;
    }

    public static JToggleButton createShowResultButton() {
        JToggleButton jToggleButton = VariablesViewButtons.createToggleButton(SHOW_EVALUTOR_RESULT, "org/netbeans/modules/debugger/resources/localsView/show_evaluator_result_16.png", NbBundle.getMessage(VariablesViewButtons.class, (String)"Hint_Show_Result"));
        jToggleButton.addActionListener(new ShowResultActionListener(jToggleButton));
        return jToggleButton;
    }

    public static JButton createNewWatchButton() {
        JButton jButton = VariablesViewButtons.createButton("org/netbeans/modules/debugger/resources/watchesView/create_new_watch_16.png", NbBundle.getMessage(VariablesViewButtons.class, (String)"Hint_Create_New_Watch"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((AddWatchAction)AddWatchAction.findObject(AddWatchAction.class, (boolean)true)).actionPerformed(null);
            }
        });
        return jButton;
    }

    public static boolean isWatchesViewNested() {
        Preferences preferences = NbPreferences.forModule(ContextProvider.class).node(PREFERENCES_NAME);
        return preferences.getBoolean(SHOW_WATCHES, true);
    }

    public static boolean isResultsViewNested() {
        Preferences preferences = NbPreferences.forModule(ContextProvider.class).node(PREFERENCES_NAME);
        return preferences.getBoolean(SHOW_EVALUTOR_RESULT, true);
    }

    private static JToggleButton createToggleButton(String string, String string2, String string3) {
        Icon icon = VariablesViewButtons.loadIcon(string2);
        boolean bl = VariablesViewButtons.isButtonSelected(string);
        JToggleButton jToggleButton = new JToggleButton(icon, bl);
        Dimension dimension = new Dimension(icon.getIconWidth() + 8, icon.getIconHeight() + 8);
        jToggleButton.setPreferredSize(dimension);
        jToggleButton.setMargin(new Insets(1, 1, 1, 1));
        jToggleButton.setToolTipText(string3);
        jToggleButton.setFocusable(false);
        return jToggleButton;
    }

    private static JButton createButton(String string, String string2) {
        Icon icon = VariablesViewButtons.loadIcon(string);
        JButton jButton = new JButton(icon);
        Dimension dimension = new Dimension(icon.getIconWidth() + 8, icon.getIconHeight() + 8);
        jButton.setPreferredSize(dimension);
        jButton.setMargin(new Insets(1, 1, 1, 1));
        jButton.setToolTipText(string2);
        jButton.setFocusable(false);
        return jButton;
    }

    private static Icon loadIcon(String string) {
        return ImageUtilities.loadImageIcon((String)string, (boolean)false);
    }

    private static boolean isButtonSelected(String string) {
        if (string.equals(SHOW_WATCHES)) {
            return VariablesViewButtons.isWatchesViewNested();
        }
        if (string.equals(SHOW_EVALUTOR_RESULT)) {
            return VariablesViewButtons.isResultsViewNested();
        }
        return false;
    }

    private static void setButtonSelected(String string, boolean bl) {
        Preferences preferences = NbPreferences.forModule(ContextProvider.class).node(PREFERENCES_NAME);
        preferences.putBoolean(string, bl);
    }

    private static void openView(String string, boolean bl) {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(string);
        topComponent.open();
        if (bl) {
            topComponent.requestActive();
        }
    }

    private static void closeView(String string) {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(string);
        topComponent.close();
    }

    private static class ShowResultActionListener
    implements ActionListener {
        private JToggleButton button;

        ShowResultActionListener(JToggleButton jToggleButton) {
            this.button = jToggleButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = this.button.isSelected();
            VariablesViewButtons.setButtonSelected(VariablesViewButtons.SHOW_EVALUTOR_RESULT, bl);
            if (bl) {
                VariablesViewButtons.closeView("resultsView");
            } else {
                VariablesViewButtons.openView("resultsView", false);
            }
        }
    }

    private static class ShowWatchesActionListener
    implements ActionListener {
        private JToggleButton button;

        ShowWatchesActionListener(JToggleButton jToggleButton) {
            this.button = jToggleButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = this.button.isSelected();
            VariablesViewButtons.setButtonSelected(VariablesViewButtons.SHOW_WATCHES, bl);
            if (bl) {
                VariablesViewButtons.closeView("watchesView");
            } else {
                VariablesViewButtons.openView("watchesView", false);
            }
        }
    }
}

