/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui;

import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;

public class Utils {
    public static String getIdentifier() {
        EditorCookie editorCookie = Utils.getCurrentEditorCookie();
        if (editorCookie == null) {
            return null;
        }
        JEditorPane jEditorPane = Utils.getCurrentEditor(editorCookie);
        if (jEditorPane == null) {
            return null;
        }
        return Utils.getIdentifier(editorCookie.getDocument(), jEditorPane, jEditorPane.getCaret().getDot());
    }

    private static String getIdentifier(StyledDocument styledDocument, JEditorPane jEditorPane, int n) {
        String string = null;
        if (jEditorPane.getSelectionStart() <= n && n <= jEditorPane.getSelectionEnd()) {
            string = jEditorPane.getSelectedText();
        }
        if (string != null) {
            return string;
        }
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        int n3 = NbDocument.findLineColumn((StyledDocument)styledDocument, (int)n);
        try {
            int n4;
            int n5;
            Element element = NbDocument.findLineRootElement((StyledDocument)styledDocument).getElement(n2);
            if (element == null) {
                return null;
            }
            int n6 = element.getStartOffset();
            int n7 = element.getEndOffset() - n6;
            string = styledDocument.getText(n6, n7);
            for (n5 = n3; n5 > 0 && (Character.isJavaIdentifierPart(string.charAt(n5 - 1)) || string.charAt(n5 - 1) == '.'); --n5) {
            }
            for (n4 = n3; n4 < n7 && Character.isJavaIdentifierPart(string.charAt(n4)); ++n4) {
            }
            if (n5 == n4) {
                return null;
            }
            return string.substring(n5, n4);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private static JEditorPane getCurrentEditor(EditorCookie editorCookie) {
        JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
        if (jEditorPaneArray == null || jEditorPaneArray.length < 1) {
            return null;
        }
        return jEditorPaneArray[0];
    }

    private static EditorCookie getCurrentEditorCookie() {
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray == null || nodeArray.length != 1) {
            return null;
        }
        Node node = nodeArray[0];
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        if (dataObject != null && !dataObject.isValid()) {
            return null;
        }
        return (EditorCookie)node.getCookie(EditorCookie.class);
    }

    public static ImageIcon getIcon(String string) {
        return ImageUtilities.loadImageIcon((String)(string + ".gif"), (boolean)false);
    }
}

