/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.event.ActionListener;
import java.beans.DesignMode;
import java.beans.beancontext.BeanContextChildComponentProxy;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.debugger.ui.actions.DebuggerAction;
import org.netbeans.spi.debugger.ActionsProvider;
import org.openide.awt.Toolbar;
import org.openide.awt.ToolbarPool;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebuggerManagerListener
extends DebuggerManagerAdapter {
    private static final String PROPERTY_CLOSED_TC = "closedTopComponents";
    private List<DebuggerEngine> openedGroups = new LinkedList<DebuggerEngine>();
    private final Map<DebuggerEngine, List<? extends Component>> openedComponents = new HashMap<DebuggerEngine, List<? extends Component>>();
    private Set<Reference<Component>> componentsInitiallyOpened = new HashSet<Reference<Component>>();
    private final Map<DebuggerEngine, List<? extends Component>> closedToolbarButtons = new HashMap<DebuggerEngine, List<? extends Component>>();
    private final Map<DebuggerEngine, List<? extends Component>> usedToolbarButtons = new HashMap<DebuggerEngine, List<? extends Component>>();
    private final Map<Component, Dimension> toolbarButtonsPrefferedSize = new HashMap<Component, Dimension>();
    private final Map<Mode, Reference<TopComponent>> lastSelectedTopComponents = new WeakHashMap<Mode, Reference<TopComponent>>();
    private static final List<Component> OPENED_COMPONENTS = new LinkedList<Component>();

    public void engineAdded(DebuggerEngine debuggerEngine) {
        this.openEngineComponents(debuggerEngine);
        this.setupToolbar(debuggerEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openEngineComponents(DebuggerEngine debuggerEngine) {
        Map<DebuggerEngine, List<? extends Component>> map = this.openedComponents;
        synchronized (map) {
            if (this.openedComponents.containsKey(debuggerEngine) || this.openedGroups.contains(debuggerEngine)) {
                return;
            }
            final List list = debuggerEngine.lookup(null, BeanContextChildComponentProxy.class);
            if (list != null && !list.isEmpty()) {
                RequestProcessor requestProcessor;
                final ArrayList<Label> arrayList = new ArrayList<Label>(list.size());
                arrayList.add(new Label("EMPTY"));
                if (this.openedComponents.isEmpty() && this.openedGroups.isEmpty()) {
                    this.fillOpenedDebuggerComponents(this.componentsInitiallyOpened);
                }
                if ((requestProcessor = (RequestProcessor)debuggerEngine.lookupFirst(null, RequestProcessor.class)) == null) {
                    requestProcessor = RequestProcessor.getDefault();
                }
                requestProcessor.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object;
                        ArrayList<Component> arrayList2 = new ArrayList<Component>(list.size());
                        try {
                            object = new ArrayList(list.size());
                            for (final BeanContextChildComponentProxy beanContextChildComponentProxy : list) {
                                boolean[] blArray;
                                Component[] componentArray;
                                block21: {
                                    componentArray = new Component[]{null};
                                    blArray = new boolean[]{false};
                                    try {
                                        SwingUtilities.invokeAndWait(new Runnable(){

                                            public void run() {
                                                componentArray[0] = beanContextChildComponentProxy.getComponent();
                                                blArray[0] = beanContextChildComponentProxy instanceof DesignMode ? ((DesignMode)((Object)beanContextChildComponentProxy)).isDesignTime() : true;
                                            }
                                        });
                                        if (componentArray[0] == null) {
                                        }
                                        break block21;
                                    }
                                    catch (Exception exception) {
                                        Exceptions.printStackTrace((Throwable)exception);
                                    }
                                    continue;
                                }
                                arrayList2.add(componentArray[0]);
                                if (componentArray[0] instanceof TopComponent) {
                                    boolean bl;
                                    TopComponent topComponent = (TopComponent)componentArray[0];
                                    boolean bl2 = Properties.getDefault().getProperties(DebuggerManagerListener.class.getName()).getProperties(DebuggerManagerListener.PROPERTY_CLOSED_TC).getBoolean(topComponent.getName(), false);
                                    boolean bl3 = bl = !Properties.getDefault().getProperties(DebuggerManagerListener.class.getName()).getProperties(DebuggerManagerListener.PROPERTY_CLOSED_TC).getBoolean(topComponent.getName(), true);
                                    if ((!blArray[0] || bl2) && (blArray[0] || !bl)) continue;
                                    object.add(topComponent);
                                    continue;
                                }
                                if (!blArray[0]) continue;
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        componentArray[0].setVisible(true);
                                    }
                                });
                            }
                            if (object.size() > 0) {
                                SwingUtilities.invokeLater(new Runnable((List)object){
                                    final /* synthetic */ List val$topComponentsToOpen;
                                    {
                                        this.val$topComponentsToOpen = list;
                                    }

                                    public void run() {
                                        DebuggerManagerListener.this.openTopComponents(this.val$topComponentsToOpen);
                                    }
                                });
                            }
                        }
                        finally {
                            object = DebuggerManagerListener.this.openedComponents;
                            synchronized (object) {
                                arrayList.clear();
                                arrayList.addAll(arrayList2);
                                DebuggerManagerListener.this.openedComponents.notifyAll();
                            }
                            object = OPENED_COMPONENTS;
                            synchronized (object) {
                                OPENED_COMPONENTS.addAll(arrayList2);
                            }
                        }
                    }
                });
                this.openedComponents.put(debuggerEngine, arrayList);
            } else {
                if (this.openedGroups.isEmpty()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            TopComponentGroup topComponentGroup = WindowManager.getDefault().findTopComponentGroup("debugger");
                            if (topComponentGroup != null) {
                                topComponentGroup.open();
                            }
                        }
                    });
                }
                this.openedGroups.add(debuggerEngine);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillOpenedDebuggerComponents(Set<Reference<Component>> set) {
        TopComponent.Registry registry;
        TopComponent.Registry registry2 = registry = TopComponent.getRegistry();
        synchronized (registry2) {
            for (TopComponent topComponent : registry.getOpened()) {
                set.add(new WeakReference<TopComponent>(topComponent));
            }
        }
    }

    private void openTopComponents(List<TopComponent> list) {
        assert (SwingUtilities.isEventDispatchThread());
        HashSet<Mode> hashSet = new HashSet<Mode>();
        for (TopComponent topComponent : list) {
            Object object;
            topComponent.open();
            Mode mode = WindowManager.getDefault().findMode(topComponent);
            if (!hashSet.add(mode)) continue;
            TopComponent topComponent2 = mode.getSelectedTopComponent();
            if (topComponent2 != null && topComponent2 != topComponent) {
                object = new WeakReference<TopComponent>(topComponent2);
                this.lastSelectedTopComponents.put(mode, (Reference<TopComponent>)object);
            }
            object = null;
            try {
                object = (String)mode.getClass().getMethod("getSide", new Class[0]).invoke((Object)mode, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object != null) continue;
            topComponent.requestVisible();
        }
    }

    private void closeTopComponentsList(List<TopComponent> list) {
        assert (SwingUtilities.isEventDispatchThread());
        ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>();
        for (TopComponent topComponent : list) {
            TopComponent topComponent2;
            Reference<TopComponent> reference;
            Mode mode = WindowManager.getDefault().findMode(topComponent);
            if (mode.getSelectedTopComponent() == topComponent && (reference = this.lastSelectedTopComponents.remove(mode)) != null && (topComponent2 = reference.get()) != null && topComponent2.isOpened()) {
                arrayList.add(topComponent2);
            }
            topComponent.close();
        }
        for (TopComponent topComponent : arrayList) {
            topComponent.requestVisible();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setupToolbar(final DebuggerEngine debuggerEngine) {
        boolean bl;
        List list = debuggerEngine.lookup(null, ActionsProvider.class);
        final HashSet hashSet = new HashSet();
        for (ActionsProvider actionsProvider : list) {
            hashSet.addAll(actionsProvider.getActions());
        }
        final ArrayList arrayList = new ArrayList();
        arrayList.add(new Label("EMPTY"));
        Map<DebuggerEngine, List<? extends Component>> map = this.closedToolbarButtons;
        synchronized (map) {
            bl = this.closedToolbarButtons.isEmpty();
            this.closedToolbarButtons.put(debuggerEngine, arrayList);
        }
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ArrayList<Component> arrayList3 = new ArrayList<Component>();
                ArrayList<Component> arrayList2 = new ArrayList<Component>();
                try {
                    Object object;
                    if (ToolbarPool.getDefault().getConfiguration().equals("Standard")) {
                        ToolbarPool.getDefault().setConfiguration("Debugging");
                    }
                    if ((object = ToolbarPool.getDefault().findToolbar("Debug")) == null) {
                        return;
                    }
                    for (Component component : object.getComponents()) {
                        Object object2;
                        if (!(component instanceof AbstractButton)) continue;
                        Action action = ((AbstractButton)component).getAction();
                        if (action == null) {
                            for (ActionListener actionListener : object2 = ((AbstractButton)component).getActionListeners()) {
                                if (!(actionListener instanceof Action)) continue;
                                action = (Action)actionListener;
                                break;
                            }
                        }
                        if (action == null || !(action instanceof DebuggerAction)) continue;
                        object2 = ((DebuggerAction)action).getAction();
                        boolean bl2 = hashSet.contains(object2);
                        if (bl && !bl2) {
                            component.setVisible(false);
                            arrayList3.add(component);
                            DebuggerManagerListener.this.toolbarButtonsPrefferedSize.put(component, component.getPreferredSize());
                            component.setPreferredSize(new Dimension(0, 0));
                        }
                        if (!bl && bl2) {
                            Dimension dimension = (Dimension)DebuggerManagerListener.this.toolbarButtonsPrefferedSize.remove(component);
                            if (dimension != null) {
                                component.setPreferredSize(dimension);
                            }
                            component.setVisible(true);
                        }
                        if (!bl2) continue;
                        arrayList2.add(component);
                    }
                    object.revalidate();
                    object.repaint();
                }
                finally {
                    Map map = DebuggerManagerListener.this.closedToolbarButtons;
                    synchronized (map) {
                        DebuggerManagerListener.this.usedToolbarButtons.put(debuggerEngine, arrayList2);
                        arrayList.clear();
                        arrayList.addAll(arrayList3);
                        DebuggerManagerListener.this.closedToolbarButtons.notifyAll();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineRemoved(DebuggerEngine debuggerEngine) {
        Map<DebuggerEngine, List<? extends Component>> map = this.openedComponents;
        synchronized (map) {
            List<? extends Component> list = this.openedComponents.remove(debuggerEngine);
            if (list != null) {
                if (list.size() == 1 && list.get(0) instanceof Label) {
                    try {
                        this.openedComponents.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ArrayList<? extends Component> arrayList = new ArrayList<Component>();
                for (List<? extends Component> list22 : this.openedComponents.values()) {
                    arrayList.addAll(list22);
                }
                final ArrayList<? extends Component> arrayList2 = new ArrayList<Component>(list);
                arrayList2.removeAll(arrayList);
                for (Reference<Component> reference : this.componentsInitiallyOpened) {
                    arrayList2.remove(reference.get());
                }
                if (!arrayList2.isEmpty()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>(arrayList2.size());
                            for (Component component : arrayList2) {
                                if (component instanceof TopComponent) {
                                    TopComponent topComponent = (TopComponent)component;
                                    boolean bl = topComponent.isOpened();
                                    Properties.getDefault().getProperties(DebuggerManagerListener.class.getName()).getProperties(DebuggerManagerListener.PROPERTY_CLOSED_TC).setBoolean(topComponent.getName(), !bl);
                                    if (!bl) continue;
                                    arrayList.add(topComponent);
                                    continue;
                                }
                                component.setVisible(false);
                            }
                            DebuggerManagerListener.this.closeTopComponentsList(arrayList);
                        }
                    });
                }
                List<Component> list2 = OPENED_COMPONENTS;
                synchronized (list2) {
                    OPENED_COMPONENTS.removeAll(arrayList2);
                }
            }
            this.openedGroups.remove(debuggerEngine);
            if (this.openedGroups.isEmpty()) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TopComponentGroup topComponentGroup = WindowManager.getDefault().findTopComponentGroup("debugger");
                        if (topComponentGroup != null) {
                            topComponentGroup.close();
                        }
                    }
                });
            }
            if (this.openedComponents.isEmpty() && this.openedGroups.isEmpty()) {
                this.componentsInitiallyOpened.clear();
            }
        }
        this.closeToolbar(debuggerEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeToolbar(DebuggerEngine debuggerEngine) {
        boolean bl;
        Map<DebuggerEngine, List<? extends Component>> map = this.closedToolbarButtons;
        synchronized (map) {
            List<? extends Component> list = this.closedToolbarButtons.remove(debuggerEngine);
            bl = this.closedToolbarButtons.isEmpty();
            if (list != null) {
                while (list.size() == 1 && list.get(0) instanceof Label) {
                    try {
                        this.closedToolbarButtons.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                List<? extends Component> list2 = this.usedToolbarButtons.remove(debuggerEngine);
                ToolbarPool.getDefault().waitFinished();
                if (!ToolbarPool.getDefault().getConfiguration().equals("Debugging")) {
                    return;
                }
                final Toolbar toolbar = ToolbarPool.getDefault().findToolbar("Debug");
                if (!bl) {
                    ArrayList<? extends Component> arrayList = new ArrayList<Component>();
                    for (List<? extends Component> list3 : this.usedToolbarButtons.values()) {
                        arrayList.addAll(list3);
                    }
                    final ArrayList<? extends Component> arrayList2 = new ArrayList<Component>(list2);
                    arrayList2.removeAll(arrayList);
                    if (!arrayList2.isEmpty()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                for (Component component : arrayList2) {
                                    component.setVisible(false);
                                    DebuggerManagerListener.this.toolbarButtonsPrefferedSize.put(component, component.getPreferredSize());
                                    component.setPreferredSize(new Dimension(0, 0));
                                }
                                toolbar.revalidate();
                                toolbar.repaint();
                            }
                        });
                    }
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            for (Component component : toolbar.getComponents()) {
                                if (!(component instanceof AbstractButton)) continue;
                                Dimension dimension = (Dimension)DebuggerManagerListener.this.toolbarButtonsPrefferedSize.remove(component);
                                if (dimension != null) {
                                    component.setPreferredSize(dimension);
                                }
                                component.setVisible(true);
                            }
                            toolbar.revalidate();
                            toolbar.repaint();
                        }
                    });
                }
            }
        }
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ToolbarPool.getDefault().setConfiguration("Standard");
                }
            });
        }
    }

    static void closeDebuggerUI() {
        if (SwingUtilities.isEventDispatchThread()) {
            DebuggerManagerListener.doCloseDebuggerUI();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DebuggerManagerListener.doCloseDebuggerUI();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCloseDebuggerUI() {
        TopComponentGroup topComponentGroup = WindowManager.getDefault().findTopComponentGroup("debugger");
        if (topComponentGroup != null) {
            topComponentGroup.close();
        }
        List<Component> list = OPENED_COMPONENTS;
        synchronized (list) {
            for (Component component : OPENED_COMPONENTS) {
                if (component instanceof TopComponent) {
                    ((TopComponent)component).close();
                    continue;
                }
                component.setVisible(false);
            }
            OPENED_COMPONENTS.clear();
        }
        ToolbarPool.getDefault().waitFinished();
        if (ToolbarPool.getDefault().getConfiguration().equals("Debugging")) {
            ToolbarPool.getDefault().setConfiguration("Standard");
        }
    }
}

