/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.netbeans.modules.db.sql.analyzer.QualIdent;
import org.netbeans.modules.db.sql.analyzer.SQLStatement;
import org.netbeans.modules.db.sql.analyzer.SQLStatementKind;
import org.netbeans.modules.db.sql.analyzer.TablesClause;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectStatement
extends SQLStatement {
    private final List<List<String>> selectValues;

    SelectStatement(int n, int n2, List<List<String>> list, TablesClause tablesClause, List<SelectStatement> list2, SortedMap<Integer, SQLStatement.Context> sortedMap) {
        super(n, n2, sortedMap, tablesClause, list2);
        this.kind = SQLStatementKind.SELECT;
        this.selectValues = list;
    }

    public TablesClause getTablesInEffect(int n) {
        ArrayList<SelectStatement> arrayList = new ArrayList<SelectStatement>();
        this.fillStatementPath(n, arrayList);
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() == 1) {
            return ((SelectStatement)arrayList.get(0)).getTablesClause();
        }
        Collections.reverse(arrayList);
        HashSet<QualIdent> hashSet = new HashSet<QualIdent>();
        HashMap<String, QualIdent> hashMap = new HashMap<String, QualIdent>();
        for (SelectStatement selectStatement : arrayList) {
            TablesClause tablesClause = selectStatement.getTablesClause();
            if (tablesClause == null) continue;
            hashSet.addAll(tablesClause.getUnaliasedTableNames());
            for (Map.Entry<String, QualIdent> entry : tablesClause.getAliasedTableNames().entrySet()) {
                String string = entry.getKey();
                QualIdent qualIdent = entry.getValue();
                if (hashMap.containsKey(string)) continue;
                hashMap.put(string, qualIdent);
            }
        }
        return new TablesClause(Collections.unmodifiableSet(hashSet), Collections.unmodifiableMap(hashMap));
    }

    public List<List<String>> getSelectValues() {
        return this.selectValues;
    }

    private void fillStatementPath(int n, List<SelectStatement> list) {
        if (n >= this.startOffset && n <= this.endOffset) {
            list.add(this);
            for (SelectStatement selectStatement : this.getSubqueries()) {
                selectStatement.fillStatementPath(n, list);
            }
        }
    }
}

