/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.outline;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.EventObject;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreePath;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.ETableColumn;
import org.netbeans.swing.outline.CheckRenderDataProvider;
import org.netbeans.swing.outline.DefaultOutlineCellRenderer;
import org.netbeans.swing.outline.OutlineModel;
import org.netbeans.swing.outline.RenderDataProvider;
import org.netbeans.swing.outline.TreePathSupport;

public class Outline
extends ETable {
    private boolean initialized = false;
    private Boolean cachedRootVisible = null;
    private RenderDataProvider renderDataProvider = null;
    private ComponentListener componentListener = null;
    private boolean selectionDisabled = false;

    public Outline() {
        this.init();
    }

    public Outline(OutlineModel outlineModel) {
        super(outlineModel);
        this.init();
    }

    private void init() {
        this.initialized = true;
        this.setDefaultRenderer(Object.class, new DefaultOutlineCellRenderer());
        ActionMap actionMap = this.getActionMap();
        Action action = actionMap.get("selectNextColumn");
        actionMap.put("selectNextColumn", new ExpandAction(true, action));
        action = actionMap.get("selectPreviousColumn");
        actionMap.put("selectPreviousColumn", new ExpandAction(false, action));
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        int n3 = this.convertColumnIndexToModel(n2);
        TableCellRenderer tableCellRenderer = n3 == 0 ? this.getDefaultRenderer(Object.class) : super.getCellRenderer(n, n2);
        return tableCellRenderer;
    }

    public RenderDataProvider getRenderDataProvider() {
        return this.renderDataProvider;
    }

    public void setRenderDataProvider(RenderDataProvider renderDataProvider) {
        if (renderDataProvider != this.renderDataProvider) {
            RenderDataProvider renderDataProvider2 = this.renderDataProvider;
            this.renderDataProvider = renderDataProvider;
            this.firePropertyChange("renderDataProvider", renderDataProvider2, renderDataProvider);
        }
    }

    TreePathSupport getTreePathSupport() {
        OutlineModel outlineModel = this.getOutlineModel();
        if (outlineModel != null) {
            return outlineModel.getTreePathSupport();
        }
        return null;
    }

    public final AbstractLayoutCache getLayoutCache() {
        OutlineModel outlineModel = this.getOutlineModel();
        if (outlineModel != null) {
            return outlineModel.getLayout();
        }
        return null;
    }

    boolean isTreeColumnIndex(int n) {
        int n2 = this.convertColumnIndexToModel(n);
        return n2 == 0;
    }

    public boolean isVisible(TreePath treePath) {
        if (this.getTreePathSupport() != null) {
            return this.getTreePathSupport().isVisible(treePath);
        }
        return false;
    }

    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.getLayoutCache() != null) {
            this.getLayoutCache().setRowHeight(n);
        }
    }

    public void setRootVisible(boolean bl) {
        if (this.getOutlineModel() == null) {
            Boolean bl2 = this.cachedRootVisible = bl ? Boolean.TRUE : Boolean.FALSE;
        }
        if (bl != this.isRootVisible()) {
            TreePath treePath;
            this.getLayoutCache().setRootVisible(bl);
            if (this.getLayoutCache().getRowCount() > 0 && null != (treePath = this.getLayoutCache().getPathForRow(0))) {
                this.getLayoutCache().treeStructureChanged(new TreeModelEvent((Object)this, treePath));
            }
            this.sortAndFilter();
            this.firePropertyChange("rootVisible", !bl, bl);
        }
    }

    public boolean isRootVisible() {
        if (this.getLayoutCache() == null) {
            return this.cachedRootVisible != null ? this.cachedRootVisible : true;
        }
        return this.getLayoutCache().isRootVisible();
    }

    public void setRowHeight(int n, int n2) {
        Logger.getLogger(Outline.class.getName()).warning("Not supported yet.");
    }

    protected TableColumn createColumn(int n) {
        return new OutlineColumn(n);
    }

    public void setModel(TableModel tableModel) {
        if (this.initialized && !(tableModel instanceof OutlineModel)) {
            throw new IllegalArgumentException("Table model for an Outline must be an instance of OutlineModel");
        }
        if (tableModel instanceof OutlineModel) {
            AbstractLayoutCache abstractLayoutCache = ((OutlineModel)tableModel).getLayout();
            if (this.cachedRootVisible != null) {
                abstractLayoutCache.setRootVisible(this.cachedRootVisible);
            }
            abstractLayoutCache.setRowHeight(this.getRowHeight());
            if (((OutlineModel)tableModel).isLargeModel()) {
                this.addComponentListener(this.getComponentListener());
                abstractLayoutCache.setNodeDimensions(new ND());
            } else if (this.componentListener != null) {
                this.removeComponentListener(this.componentListener);
                this.componentListener = null;
            }
        }
        super.setModel(tableModel);
    }

    public OutlineModel getOutlineModel() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof OutlineModel) {
            return (OutlineModel)this.getModel();
        }
        return null;
    }

    public void expandPath(TreePath treePath) {
        this.getTreePathSupport().expandPath(treePath);
    }

    public boolean isExpanded(TreePath treePath) {
        return this.getTreePathSupport().isExpanded(treePath);
    }

    public void collapsePath(TreePath treePath) {
        this.getTreePathSupport().collapsePath(treePath);
    }

    public Rectangle getPathBounds(TreePath treePath) {
        Insets insets = this.getInsets();
        Rectangle rectangle = this.getLayoutCache().getBounds(treePath, null);
        if (rectangle != null && insets != null) {
            rectangle.x += insets.left;
            rectangle.y += insets.top;
        }
        return rectangle;
    }

    public TreePath getClosestPathForLocation(int n, int n2) {
        Insets insets = this.getInsets();
        TreePath treePath = insets != null ? this.getLayoutCache().getPathClosestTo(n - insets.left, n2 - insets.top) : this.getLayoutCache().getPathClosestTo(n, n2);
        int n3 = this.getLayoutCache().getRowForPath(treePath);
        n3 = this.convertRowIndexToModel(n3);
        treePath = this.getLayoutCache().getPathForRow(n3);
        return treePath;
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        boolean bl;
        if (this.isTreeColumnIndex(n2) && eventObject instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            TreePath treePath = this.getLayoutCache().getPathForRow(this.convertRowIndexToModel(n));
            if (!this.getOutlineModel().isLeaf(treePath.getLastPathComponent())) {
                int n3 = DefaultOutlineCellRenderer.getExpansionHandleWidth();
                Insets insets = this.getInsets();
                int n4 = treePath.getPathCount() - (this.isRootVisible() ? 1 : 2);
                if (n4 < 0) {
                    n4 = 0;
                }
                int n5 = insets.left + n4 * DefaultOutlineCellRenderer.getNestingWidth();
                int n6 = insets.left + n5 + n3;
                int n7 = this.getCellRect((int)n, (int)n2, (boolean)false).x;
                if (mouseEvent.getX() > insets.left && mouseEvent.getX() >= (n5 += n7) && mouseEvent.getX() <= (n6 += n7) || mouseEvent.getClickCount() > 1) {
                    boolean bl2 = this.getLayoutCache().isExpanded(treePath);
                    if (!bl2) {
                        this.getTreePathSupport().expandPath(treePath);
                        Object object = treePath.getLastPathComponent();
                        int n8 = this.getOutlineModel().getChildCount(object);
                        if (n8 > 0) {
                            Object object2 = this.getOutlineModel().getChild(object, n8 - 1);
                            TreePath treePath2 = treePath.pathByAddingChild(object2);
                            int n9 = this.getLayoutCache().getRowForPath(treePath2);
                            Rectangle rectangle = this.getCellRect(n9, 0, true);
                            Rectangle rectangle2 = this.getCellRect(this.getLayoutCache().getRowForPath(treePath), 0, true);
                            Rectangle rectangle3 = new Rectangle(rectangle2.x, rectangle2.y, rectangle.x + rectangle.width - rectangle2.x, rectangle.y + rectangle.height - rectangle2.y);
                            this.scrollRectToVisible(rectangle3);
                        }
                    } else {
                        this.getTreePathSupport().collapsePath(treePath);
                    }
                    this.selectionDisabled = true;
                    return false;
                }
            }
            if (this.checkAt(n, n2, mouseEvent)) {
                return false;
            }
        }
        if ((bl = super.editCellAt(n, n2, eventObject)) && this.isTreeColumnIndex(n2) && null != this.getEditorComponent()) {
            this.configureTreeCellEditor(this.getEditorComponent(), n, n2);
        }
        if (eventObject == null && !bl && this.isTreeColumnIndex(n2)) {
            this.checkAt(n, n2, null);
        }
        return bl;
    }

    private boolean checkAt(int n, int n2, MouseEvent mouseEvent) {
        RenderDataProvider renderDataProvider = this.getRenderDataProvider();
        TableCellRenderer tableCellRenderer = this.getDefaultRenderer(Object.class);
        if (renderDataProvider instanceof CheckRenderDataProvider && tableCellRenderer instanceof DefaultOutlineCellRenderer) {
            CheckRenderDataProvider checkRenderDataProvider = (CheckRenderDataProvider)renderDataProvider;
            DefaultOutlineCellRenderer defaultOutlineCellRenderer = (DefaultOutlineCellRenderer)tableCellRenderer;
            Object object = this.getValueAt(n, n2);
            if (checkRenderDataProvider.isCheckable(object) && checkRenderDataProvider.isCheckEnabled(object)) {
                boolean bl;
                if (mouseEvent == null) {
                    bl = true;
                } else {
                    int n3 = DefaultOutlineCellRenderer.getExpansionHandleWidth();
                    int n4 = defaultOutlineCellRenderer.getTheCheckBoxWidth();
                    Insets insets = this.getInsets();
                    TreePath treePath = this.getLayoutCache().getPathForRow(this.convertRowIndexToModel(n));
                    int n5 = treePath.getPathCount() - (this.isRootVisible() ? 1 : 2);
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    int n6 = insets.left + n5 * DefaultOutlineCellRenderer.getNestingWidth() + n3;
                    int n7 = n6 + n4;
                    boolean bl2 = bl = mouseEvent.getX() > insets.left && mouseEvent.getX() >= n6 && mouseEvent.getX() <= n7 && mouseEvent.getClickCount() == 1;
                }
                if (bl) {
                    Boolean bl3 = checkRenderDataProvider.isSelected(object);
                    if (bl3 == null || Boolean.TRUE.equals(bl3)) {
                        checkRenderDataProvider.setSelected(object, Boolean.FALSE);
                    } else {
                        checkRenderDataProvider.setSelected(object, Boolean.TRUE);
                    }
                    Rectangle rectangle = this.getCellRect(n, n2, true);
                    this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    return true;
                }
            }
        }
        return false;
    }

    protected void configureTreeCellEditor(Component component, int n, int n2) {
        if (!(component instanceof JComponent)) {
            return;
        }
        TreeCellEditorBorder treeCellEditorBorder = new TreeCellEditorBorder();
        TreePath treePath = this.getLayoutCache().getPathForRow(this.convertRowIndexToModel(n));
        Object object = this.getValueAt(n, n2);
        RenderDataProvider renderDataProvider = this.getRenderDataProvider();
        treeCellEditorBorder.icon = renderDataProvider.getIcon(object);
        treeCellEditorBorder.nestingDepth = Math.max(0, treePath.getPathCount() - (this.isRootVisible() ? 1 : 2));
        treeCellEditorBorder.isLeaf = this.getOutlineModel().isLeaf(object);
        treeCellEditorBorder.isExpanded = this.getLayoutCache().isExpanded(treePath);
        ((JComponent)component).setBorder(treeCellEditorBorder);
    }

    public void addNotify() {
        super.addNotify();
        this.calcRowHeight();
    }

    private void calcRowHeight() {
        Integer n = (Integer)UIManager.get("netbeans.outline.rowHeight");
        int n2 = 20;
        if (n != null) {
            n2 = n;
        } else {
            Font font = this.getFont();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n3 = Math.max(fontMetrics.getHeight() + fontMetrics.getMaxDescent(), DefaultOutlineCellRenderer.getExpansionHandleHeight());
            n2 = Math.max(n2, n3) + 2;
        }
        this.setRowHeight(n2);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
    }

    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        if (this.selectionDisabled) {
            return;
        }
        super.changeSelection(n, n2, bl, bl2);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                this.selectionDisabled = false;
                break;
            }
            case 502: {
                this.selectionDisabled = false;
                break;
            }
            case 500: {
                this.selectionDisabled = false;
                break;
            }
            case 504: {
                this.selectionDisabled = false;
                break;
            }
            case 505: {
                this.selectionDisabled = false;
                break;
            }
            case 503: {
                break;
            }
            case 506: {
                if (!this.selectionDisabled) break;
                return;
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    private ComponentListener getComponentListener() {
        if (this.componentListener == null) {
            this.componentListener = new SizeManager();
        }
        return this.componentListener;
    }

    private JScrollPane getScrollPane() {
        JScrollPane jScrollPane = null;
        if (this.getParent() instanceof JViewport && ((JViewport)this.getParent()).getParent() instanceof JScrollPane) {
            jScrollPane = (JScrollPane)((JViewport)this.getParent()).getParent();
        }
        return jScrollPane;
    }

    private void change() {
        this.revalidate();
        this.repaint();
    }

    private class ExpandAction
    extends AbstractAction {
        private boolean expand;
        private Action origAction;

        public ExpandAction(boolean bl, Action action) {
            this.expand = bl;
            this.origAction = action;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath;
            if (Outline.this.getSelectedRowCount() == 1 && Outline.this.isTreeColumnIndex(Outline.this.getSelectedColumn()) && null != (treePath = Outline.this.getLayoutCache().getPathForRow(Outline.this.convertRowIndexToModel(Outline.this.getSelectedRow()))) && !Outline.this.getOutlineModel().isLeaf(treePath.getLastPathComponent())) {
                boolean bl = Outline.this.getLayoutCache().isExpanded(treePath);
                if (bl && !this.expand) {
                    Outline.this.collapsePath(treePath);
                    return;
                }
                if (!bl && this.expand) {
                    Outline.this.expandPath(treePath);
                    return;
                }
            }
            if (null != this.origAction) {
                this.origAction.actionPerformed(actionEvent);
            }
        }
    }

    private static class TreeCellEditorBorder
    implements Border {
        private Insets insets = new Insets(0, 0, 0, 0);
        private boolean isLeaf;
        private boolean isExpanded;
        private Icon icon;
        private int nestingDepth;
        private final int ICON_TEXT_GAP = new JLabel().getIconTextGap();

        private TreeCellEditorBorder() {
        }

        public Insets getBorderInsets(Component component) {
            this.insets.left = this.nestingDepth * DefaultOutlineCellRenderer.getNestingWidth() + DefaultOutlineCellRenderer.getExpansionHandleWidth() + 1;
            this.insets.left = this.insets.left + (this.icon != null ? this.icon.getIconWidth() + this.ICON_TEXT_GAP : 0);
            this.insets.top = 1;
            this.insets.right = 1;
            this.insets.bottom = 1;
            return this.insets;
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            int n5;
            int n6 = this.nestingDepth * DefaultOutlineCellRenderer.getNestingWidth();
            if (!this.isLeaf) {
                Icon icon = this.isExpanded ? DefaultOutlineCellRenderer.getExpandedIcon() : DefaultOutlineCellRenderer.getCollapsedIcon();
                n5 = icon.getIconHeight() < n4 ? n4 / 2 - icon.getIconHeight() / 2 : 0;
                icon.paintIcon(component, graphics, n6, n5);
            }
            if (null != this.icon) {
                n5 = this.icon.getIconHeight() < n4 ? n4 / 2 - this.icon.getIconHeight() / 2 : 0;
                this.icon.paintIcon(component, graphics, n6 += DefaultOutlineCellRenderer.getExpansionHandleWidth() + 1, n5);
            }
        }
    }

    private class SizeManager
    extends ComponentAdapter
    implements ActionListener {
        protected Timer timer = null;
        protected JScrollBar scrollBar = null;

        private SizeManager() {
        }

        public void componentMoved(ComponentEvent componentEvent) {
            if (this.timer == null) {
                JScrollPane jScrollPane = Outline.this.getScrollPane();
                if (jScrollPane == null) {
                    Outline.this.change();
                } else {
                    this.scrollBar = jScrollPane.getVerticalScrollBar();
                    if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                        this.scrollBar = jScrollPane.getHorizontalScrollBar();
                        if (this.scrollBar != null && this.scrollBar.getValueIsAdjusting()) {
                            this.startTimer();
                        } else {
                            Outline.this.change();
                        }
                    } else {
                        this.startTimer();
                    }
                }
            }
        }

        protected void startTimer() {
            if (this.timer == null) {
                this.timer = new Timer(200, this);
                this.timer.setRepeats(true);
            }
            this.timer.start();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                if (this.timer != null) {
                    this.timer.stop();
                }
                Outline.this.change();
                this.timer = null;
                this.scrollBar = null;
            }
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
        }

        public void componentShown(ComponentEvent componentEvent) {
        }
    }

    private class ND
    extends AbstractLayoutCache.NodeDimensions {
        private ND() {
        }

        public Rectangle getNodeDimensions(Object object, int n, int n2, boolean bl, Rectangle rectangle) {
            int n3 = Outline.this.getColumnModel().getColumn(0).getPreferredWidth();
            rectangle.setBounds(0, n * Outline.this.getRowHeight(), n3, Outline.this.getRowHeight());
            return rectangle;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OutlineColumn
    extends ETableColumn {
        public OutlineColumn(int n) {
            super(n, Outline.this);
        }

        @Override
        protected Comparator<ETable.RowMapping> getRowComparator(int n, boolean bl) {
            return new OutlineRowComparator(n, bl);
        }

        @Override
        public boolean isHidingAllowed() {
            return this.getModelIndex() != 0;
        }

        @Override
        public boolean isSortingAllowed() {
            return true;
        }

        private class OutlineRowComparator
        extends ETableColumn.RowComparator {
            private boolean ascending;

            public OutlineRowComparator(int n, boolean bl) {
                super(n);
                this.ascending = true;
                this.ascending = bl;
            }

            public int compare(ETable.RowMapping rowMapping, ETable.RowMapping rowMapping2) {
                int n;
                int n2 = rowMapping.getModelRowIndex();
                if (n2 == (n = rowMapping2.getModelRowIndex())) {
                    return 0;
                }
                TreePath treePath = Outline.this.getLayoutCache().getPathForRow(n2);
                TreePath treePath2 = Outline.this.getLayoutCache().getPathForRow(n);
                if (treePath == null) {
                    if (treePath2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (treePath2 == null) {
                    return 1;
                }
                if (treePath.isDescendant(treePath2)) {
                    return -1;
                }
                if (treePath2.isDescendant(treePath)) {
                    return 1;
                }
                TreePath treePath3 = treePath.getParentPath();
                TreePath treePath4 = treePath2.getParentPath();
                if (treePath3 != null && treePath4 != null && treePath3.equals(treePath4) && Outline.this.getOutlineModel().isLeaf(treePath.getLastPathComponent()) && Outline.this.getOutlineModel().isLeaf(treePath2.getLastPathComponent())) {
                    return this.ascending ? super.compare(rowMapping, rowMapping2) : -super.compare(rowMapping, rowMapping2);
                }
                while (treePath.getPathCount() < treePath2.getPathCount()) {
                    treePath2 = treePath2.getParentPath();
                }
                while (treePath.getPathCount() > treePath2.getPathCount()) {
                    treePath = treePath.getParentPath();
                }
                treePath3 = treePath.getParentPath();
                treePath4 = treePath2.getParentPath();
                while (treePath3 != null && treePath4 != null && !treePath3.equals(treePath4)) {
                    treePath = treePath3;
                    treePath2 = treePath4;
                    treePath3 = treePath.getParentPath();
                    treePath4 = treePath2.getParentPath();
                }
                int n3 = Outline.this.getLayoutCache().getRowForPath(treePath);
                int n4 = Outline.this.getLayoutCache().getRowForPath(treePath2);
                Object object = Outline.this.getModel().getValueAt(n3, this.column);
                Object object2 = Outline.this.getModel().getValueAt(n4, this.column);
                object = Outline.this.transformValue(object);
                object2 = Outline.this.transformValue(object2);
                if (object == null && object2 == null) {
                    return 0;
                }
                if (object == null) {
                    return -1;
                }
                if (object2 == null) {
                    return 1;
                }
                if (OutlineColumn.this.getNestedComparator() != null) {
                    int n5 = OutlineColumn.this.getNestedComparator().compare(object, object2);
                    return this.ascending ? n5 : -n5;
                }
                if (object instanceof Comparable && object.getClass().isAssignableFrom(object2.getClass())) {
                    Comparable comparable = (Comparable)object;
                    return this.ascending ? comparable.compareTo(object2) : -comparable.compareTo(object2);
                }
                return 0;
            }
        }
    }
}

