/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pisces;

import com.sun.pisces.GradientColorMap;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public class LinearGradientPaintContext
implements PaintContext {
    ColorModel cm = ColorModel.getRGBdefault();
    WritableRaster raster;
    AffineTransform transform;
    AffineTransform inverse;
    float x0;
    float y0;
    float x1;
    float y1;
    GradientColorMap map;
    long mx;
    long my;
    long b;

    private void computeTransform() {
        float f = this.x0 / 65536.0f;
        float f2 = this.x1 / 65536.0f;
        float f3 = this.y0 / 65536.0f;
        float f4 = this.y1 / 65536.0f;
        float f5 = f2 - f;
        float f6 = f4 - f3;
        float f7 = f5 * f5 + f6 * f6;
        float f8 = (float)this.inverse.getScaleX() / 65536.0f;
        float f9 = (float)this.inverse.getShearX() / 65536.0f;
        float f10 = (float)this.inverse.getTranslateX() / 65536.0f;
        float f11 = (float)this.inverse.getShearY() / 65536.0f;
        float f12 = (float)this.inverse.getScaleY() / 65536.0f;
        float f13 = (float)this.inverse.getTranslateY() / 65536.0f;
        this.mx = (long)(65536.0f * ((f8 * f5 + f11 * f6) / f7));
        this.my = (long)(65536.0f * ((f9 * f5 + f12 * f6) / f7));
        float f14 = f5 * f + f6 * f3;
        this.b = (long)(65536.0f * ((f10 * f5 + f13 * f6 - f14) / f7));
    }

    public LinearGradientPaintContext(float f, float f2, float f3, float f4, GradientColorMap gradientColorMap, AffineTransform affineTransform) {
        this.x0 = f;
        this.y0 = f2;
        this.x1 = f3;
        this.y1 = f4;
        this.map = gradientColorMap;
        this.transform = affineTransform;
        try {
            this.inverse = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            this.inverse = new AffineTransform();
        }
        this.computeTransform();
    }

    public void dispose() {
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        Object object;
        n3 = Math.max(n3, 1);
        n4 = Math.max(n4, 1);
        if (this.raster == null || this.raster.getWidth() < n3 || this.raster.getHeight() < n4) {
            object = new BufferedImage(n3, n4, 2);
            this.raster = ((BufferedImage)object).getRaster();
        }
        object = (DataBufferInt)this.raster.getDataBuffer();
        int[] nArray = ((DataBufferInt)object).getBankData()[0];
        int n5 = ((DataBuffer)object).getOffset();
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)this.raster.getSampleModel();
        int n6 = singlePixelPackedSampleModel.getScanlineStride();
        for (int i = 0; i < n4; ++i) {
            long l = (long)n * this.mx + (long)(n2 + i) * this.my + this.b;
            int n7 = n5 + i * n6;
            for (int j = 0; j < n3; ++j) {
                nArray[n7++] = this.map.getColor((int)l);
                l += this.mx;
            }
        }
        return this.raster.createChild(0, 0, n3, n4, n, n2, null);
    }
}

