/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.platform;

import com.sun.perseus.j2d.RasterImage;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.PrefetchCompleteEvent;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.Time;
import javax.media.UnsupportedPlugInException;
import javax.media.control.TrackControl;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class VideoPlayer
implements ControllerListener {
    private Component display;
    private RasterImage rasterImage;
    private Component component;
    private Buffer lastBuffer;
    private MemoryImageSource sourceImage;
    private Processor p;
    private Object waitSync = new Object();
    private boolean stateTransitionOK = true;
    private Image destImage;
    private int state;
    private GainControl gc;
    private float volume = 1.0f;
    int inWidth;
    int inHeight;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$I;

    VideoPlayer(String url) throws Exception {
        if (!this.createProcessor(url)) {
            throw new Exception("cannot create media processor");
        }
    }

    public void play(long startTime) {
        if (this.p != null) {
            this.p.setMediaTime(new Time(startTime * 1000000L));
            this.p.start();
        }
    }

    public int getState() {
        return this.state;
    }

    public void stop() {
        if (this.p != null) {
            this.p.stop();
        }
    }

    public void close() {
        if (this.p != null) {
            this.p.close();
        }
    }

    public long getMediaTime() {
        long time = 0L;
        if (this.p != null) {
            time = this.p.getMediaTime().getNanoseconds();
            time /= 1000000L;
        }
        return time;
    }

    public void setVolume(float volume) {
        if (this.gc != null) {
            this.gc.setLevel(volume);
        }
    }

    public float getVolume() {
        float volume = 0.0f;
        if (this.gc != null) {
            volume = this.gc.getLevel();
        }
        return volume;
    }

    private boolean createProcessor(String url) {
        this.lastBuffer = null;
        MediaLocator ml = new MediaLocator(url);
        if (ml == null) {
            System.err.println("Cannot build media locator from: " + url);
            return false;
        }
        try {
            this.p = Manager.createProcessor((MediaLocator)ml);
        }
        catch (Exception e) {
            System.err.println("Failed to create a processor from the given url: " + e);
            return false;
        }
        this.p.addControllerListener((ControllerListener)this);
        this.p.configure();
        if (!this.waitForState(180)) {
            System.err.println("Failed to configure the processor.");
            return false;
        }
        this.p.setContentDescriptor(null);
        TrackControl[] tc = this.p.getTrackControls();
        if (tc == null) {
            System.err.println("Failed to obtain track controls from the processor.");
            return false;
        }
        TrackControl videoTrack = null;
        for (int i = 0; i < tc.length; ++i) {
            if (!(tc[i].getFormat() instanceof VideoFormat)) continue;
            videoTrack = tc[i];
            break;
        }
        if (videoTrack == null) {
            System.err.println("The input media does not contain a video track.");
            return false;
        }
        System.err.println("Video format: " + videoTrack.getFormat());
        try {
            Codec[] codec = new Codec[]{new PreAccessCodec(), new PostAccessCodec()};
            videoTrack.setCodecChain(codec);
        }
        catch (UnsupportedPlugInException e) {
            System.err.println("The process does not support effects.");
        }
        this.p.prefetch();
        if (!this.waitForState(500)) {
            System.err.println("Failed to realize the processor.");
            return false;
        }
        this.gc = this.p.getGainControl();
        if (this.gc != null) {
            this.gc.setLevel(this.volume);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForState(int state) {
        Object object = this.waitSync;
        synchronized (object) {
            try {
                while (this.p.getState() != state && this.stateTransitionOK) {
                    this.waitSync.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.stateTransitionOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent evt) {
        if (evt instanceof ConfigureCompleteEvent || evt instanceof RealizeCompleteEvent || evt instanceof PrefetchCompleteEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = true;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof ResourceUnavailableEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = false;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof EndOfMediaEvent) {
            this.p.close();
        }
    }

    int getInWidth() {
        return this.inWidth;
    }

    int getInHeight() {
        return this.inHeight;
    }

    public RasterImage getFrame() {
        return this.rasterImage;
    }

    public class PostAccessCodec
    extends PreAccessCodec {
        public PostAccessCodec() {
            this.supportedIns = new Format[]{new RGBFormat()};
        }

        void accessFrame(Buffer buffer) {
            Object data;
            long t = (long)((float)buffer.getTimeStamp() / 1.0E7f);
            RGBFormat inputFormat = (RGBFormat)buffer.getFormat();
            Dimension size = inputFormat.getSize();
            VideoPlayer.this.inWidth = size.width;
            VideoPlayer.this.inHeight = size.height;
            if (VideoPlayer.this.component == null) {
                VideoPlayer.this.component = new Canvas(){

                    public Dimension getPreferredSize() {
                        return new Dimension(VideoPlayer.this.getInWidth(), VideoPlayer.this.getInHeight());
                    }

                    public void update(Graphics g) {
                    }

                    public void paint(Graphics g) {
                    }
                };
            }
            if (!((data = buffer.getData()) instanceof byte[])) {
                return;
            }
            int frameSize = VideoPlayer.this.inWidth * VideoPlayer.this.inHeight;
            int[] frame = new int[frameSize];
            byte[] in = (byte[])data;
            int k = 0;
            for (int i = 0; i < frameSize; ++i) {
                int r = in[k] & 0xFF;
                int g = in[k + 1] & 0xFF;
                int b = in[k + 2] & 0xFF;
                frame[i] = (r << 16) + (g << 8) + (b << 0);
                k += 3;
            }
            Buffer buf = new Buffer();
            buf.setData((Object)frame);
            int rMask = 0xFF0000;
            int gMask = 65280;
            int bMask = 255;
            RGBFormat format = new RGBFormat(size, frameSize, array$I == null ? (array$I = VideoPlayer.class$("[I")) : array$I, -1.0f, 32, rMask, gMask, bMask, 1, VideoPlayer.this.inWidth, 0, 1);
            buf.setFormat((Format)format);
            if (VideoPlayer.this.lastBuffer != buf) {
                VideoPlayer.this.lastBuffer = buf;
                this.newImage(buf);
            }
            VideoPlayer.this.sourceImage.newPixels(0, 0, VideoPlayer.this.inWidth, VideoPlayer.this.inHeight);
            VideoPlayer.this.rasterImage = new RasterImage(VideoPlayer.this.destImage);
        }

        private void newImage(Buffer buffer) {
            Object data = buffer.getData();
            if (!(data instanceof int[])) {
                return;
            }
            RGBFormat format = (RGBFormat)buffer.getFormat();
            DirectColorModel dcm = new DirectColorModel(format.getBitsPerPixel(), format.getRedMask(), format.getGreenMask(), format.getBlueMask());
            VideoPlayer.this.sourceImage = new MemoryImageSource(format.getLineStride(), format.getSize().height, (ColorModel)dcm, (int[])data, 0, format.getLineStride());
            VideoPlayer.this.sourceImage.setAnimated(true);
            VideoPlayer.this.sourceImage.setFullBufferUpdates(true);
            if (VideoPlayer.this.component != null) {
                VideoPlayer.this.destImage = VideoPlayer.this.component.createImage(VideoPlayer.this.sourceImage);
                VideoPlayer.this.component.prepareImage(VideoPlayer.this.destImage, VideoPlayer.this.component);
            }
        }

        public String getName() {
            return "Post-Access Codec";
        }
    }

    public class PreAccessCodec
    implements Codec {
        protected Format[] supportedIns = new Format[]{new RGBFormat(null, -1, array$B == null ? (array$B = VideoPlayer.class$("[B")) : array$B, -1.0f, 24, 1, 2, 3, 3, -1, 0, -1)};
        protected Format[] supportedOuts = new Format[]{new VideoFormat(null)};
        Format input = null;
        Format output = null;

        void accessFrame(Buffer frame) {
        }

        public String getName() {
            return "Pre-Access Codec";
        }

        public void open() {
        }

        public void close() {
        }

        public void reset() {
        }

        public Format[] getSupportedInputFormats() {
            return this.supportedIns;
        }

        public Format[] getSupportedOutputFormats(Format in) {
            if (in == null) {
                return this.supportedOuts;
            }
            Format[] outs = new Format[]{in};
            return outs;
        }

        public Format setInputFormat(Format format) {
            this.input = format;
            return this.input;
        }

        public Format setOutputFormat(Format format) {
            this.output = format;
            return this.output;
        }

        public int process(Buffer in, Buffer out) {
            this.accessFrame(in);
            Object data = in.getData();
            in.setData(out.getData());
            out.setData(data);
            out.setFormat(in.getFormat());
            out.setLength(in.getLength());
            out.setOffset(in.getOffset());
            return 0;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public Object getControl(String type) {
            return null;
        }
    }
}

