/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.TimeContainerNode;
import com.sun.perseus.model.TimedElementSupport;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGAnimationElement;

public class TimedElementNode
extends ElementNode
implements SVGAnimationElement {
    protected TimedElementSupport timedElementSupport;
    protected String localName;

    public TimedElementNode(DocumentNode ownerDocument, String localName) {
        this(ownerDocument, new TimedElementSupport(), localName);
    }

    public TimedElementNode(DocumentNode ownerDocument) {
        this(ownerDocument, new TimedElementSupport());
    }

    protected TimedElementNode(DocumentNode ownerDocument, TimedElementSupport timedElementSupport) {
        this(ownerDocument, timedElementSupport, "set");
    }

    protected TimedElementNode(DocumentNode ownerDocument, TimedElementSupport timedElementSupport, String localName) {
        super(ownerDocument);
        if (timedElementSupport == null) {
            throw new IllegalArgumentException();
        }
        if (localName == null) {
            throw new IllegalArgumentException();
        }
        this.timedElementSupport = timedElementSupport;
        this.localName = localName;
        timedElementSupport.animationElement = this;
    }

    void nodeHookedInDocumentTree() {
        super.nodeHookedInDocumentTree();
        ModelNode p = this.parent;
        while (p != this.ownerDocument && p != null) {
            if (p instanceof TimeContainerNode) {
                this.timedElementSupport.setTimeContainer(((TimeContainerNode)p).timeContainerSupport);
                break;
            }
            p = p.parent;
        }
        if (p == this.ownerDocument) {
            this.timedElementSupport.setTimeContainer(this.ownerDocument.timeContainerRootSupport);
        }
    }

    void nodeUnhookedFromDocumentTree() {
        this.timedElementSupport.reset();
        this.timedElementSupport.setTimeContainer(null);
    }

    public String getLocalName() {
        return this.localName;
    }

    public String[][] getDefaultTraits() {
        return new String[][]{{"begin", "0s"}};
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new TimedElementNode(doc, new TimedElementSupport(), this.localName);
    }

    public TimedElementSupport getTimedElementSupport() {
        return this.timedElementSupport;
    }

    public void beginElementAt(float offset) {
        this.timedElementSupport.beginAt((long)(offset * 1000.0f));
    }

    public void beginElement() {
        this.timedElementSupport.beginAt(0L);
    }

    public void endElementAt(float offset) {
        this.timedElementSupport.endAt((long)(offset * 1000.0f));
    }

    public void endElement() {
        this.timedElementSupport.endAt(0L);
    }

    public void pauseElement() {
        throw new Error("NOT IMPLEMENTED");
    }

    public void unpauseElement() {
        throw new Error("NOT IMPLEMENTED");
    }

    public boolean getElementPaused() {
        throw new Error("NOT IMPLEMENTED");
    }

    protected void parseTimeConditionsTrait(String traitName, String value, boolean isBegin) throws DOMException {
        try {
            this.ownerDocument.timeConditionParser.parseBeginEndAttribute(value, this, isBegin);
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
            throw this.illegalTraitValue(traitName, value);
        }
    }

    void validate() {
    }
}

