/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.StringTraitAnim;
import com.sun.perseus.model.TraitAnim;
import org.w3c.dom.DOMException;

public class GenericElementNode
extends ElementNode {
    protected String namespaceURI;
    protected String localName;
    protected String content;

    public GenericElementNode(String namespaceURI, String localName, DocumentNode doc) {
        super(doc);
        if (localName == null) {
            throw new IllegalArgumentException();
        }
        this.namespaceURI = namespaceURI;
        this.localName = localName;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getLocalName() {
        return this.localName;
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new GenericElementNode(this.namespaceURI, this.localName, doc);
    }

    public void appendTextChild(String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        if (this.content == null) {
            this.setContent(text);
        } else {
            this.setContent(this.content + text);
        }
    }

    public void setContent(String newContent) {
        if (GenericElementNode.equal(newContent, this.content)) {
            return;
        }
        this.modifyingNode();
        this.content = newContent;
        this.modifiedNode();
    }

    public String getContent() {
        return this.content;
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("#text" == name) {
            if (this.content == null) {
                return "";
            }
            return this.getContent();
        }
        return super.getTraitImpl(name);
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if ("#text" == traitName) {
            return new StringTraitAnim(this, "#!null/ns@!", traitName);
        }
        return super.createTraitAnimImpl(traitName);
    }

    public void setTraitImpl(String name, String value) throws DOMException {
        if ("#text" == name) {
            if (value == null) {
                throw this.illegalTraitValue(name, value);
            }
            this.setContent(value);
        } else {
            super.setTraitImpl(name, value);
        }
    }
}

