/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.impl.web.annotation;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.dd.impl.web.annotation.Refreshable;
import org.netbeans.modules.j2ee.dd.impl.web.annotation.SecurityRoles;
import org.netbeans.modules.j2ee.dd.impl.web.annotation.WebFilter;
import org.netbeans.modules.j2ee.dd.impl.web.annotation.WebServlet;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationScanner;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.ObjectProvider;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObjectManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationHelpers {
    private AnnotationModelHelper helper;
    private PersistentObjectManager<WebServlet> webServletsPOM;
    private PersistentObjectManager<WebFilter> webFiltersPOM;
    private PersistentObjectManager<SecurityRoles> securityRolesPOM;

    public AnnotationHelpers(AnnotationModelHelper annotationModelHelper) {
        this.helper = annotationModelHelper;
    }

    public AnnotationModelHelper getHelper() {
        return this.helper;
    }

    public PersistentObjectManager<WebServlet> getWebServletPOM() {
        if (this.webServletsPOM == null) {
            this.webServletsPOM = this.helper.createPersistentObjectManager((ObjectProvider)new AnnotationProvider("javax.servlet.annotation.WebServlet"){

                WebServlet newItem(AnnotationModelHelper annotationModelHelper, TypeElement typeElement) {
                    return new WebServlet(annotationModelHelper, typeElement);
                }
            });
        }
        return this.webServletsPOM;
    }

    public PersistentObjectManager<WebFilter> getWebFilterPOM() {
        if (this.webFiltersPOM == null) {
            this.webFiltersPOM = this.helper.createPersistentObjectManager((ObjectProvider)new AnnotationProvider("javax.servlet.annotation.WebFilter"){

                WebFilter newItem(AnnotationModelHelper annotationModelHelper, TypeElement typeElement) {
                    return new WebFilter(annotationModelHelper, typeElement);
                }
            });
        }
        return this.webFiltersPOM;
    }

    public PersistentObjectManager<SecurityRoles> getSecurityRolesPOM() {
        if (this.securityRolesPOM == null) {
            this.securityRolesPOM = this.helper.createPersistentObjectManager((ObjectProvider)new AnnotationProvider("javax.annotation.security.DeclareRoles"){

                SecurityRoles newItem(AnnotationModelHelper annotationModelHelper, TypeElement typeElement) {
                    return new SecurityRoles(annotationModelHelper, typeElement);
                }
            });
        }
        return this.securityRolesPOM;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AnnotationProvider<T extends Refreshable>
    implements ObjectProvider<T> {
        private String annotationName;

        AnnotationProvider(String string) {
            this.annotationName = string;
        }

        public List<T> createInitialObjects() throws InterruptedException {
            final ArrayList arrayList = new ArrayList();
            AnnotationHelpers.this.helper.getAnnotationScanner().findAnnotations(this.annotationName, AnnotationScanner.TYPE_KINDS, new AnnotationHandler(){

                public void handleAnnotation(TypeElement typeElement, Element element, AnnotationMirror annotationMirror) {
                    arrayList.add(AnnotationProvider.this.newItem(AnnotationHelpers.this.helper, typeElement));
                }
            });
            return arrayList;
        }

        public List<T> createObjects(TypeElement typeElement) {
            ArrayList<T> arrayList = new ArrayList<T>();
            if (AnnotationHelpers.this.helper.hasAnnotation(typeElement.getAnnotationMirrors(), this.annotationName)) {
                arrayList.add(this.newItem(AnnotationHelpers.this.helper, typeElement));
            }
            return arrayList;
        }

        public boolean modifyObjects(TypeElement typeElement, List<T> list) {
            assert (list.size() == 1);
            Refreshable refreshable = (Refreshable)list.get(0);
            if (!refreshable.refresh(typeElement)) {
                list.remove(0);
                return true;
            }
            return false;
        }

        abstract T newItem(AnnotationModelHelper var1, TypeElement var2);
    }
}

