/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wizards.checkoutstep;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.ui.browser.RepositoryPaths;
import org.netbeans.modules.subversion.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.ui.wizards.CheckoutWizard;
import org.netbeans.modules.subversion.ui.wizards.checkoutstep.CheckoutPanel;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class CheckoutStep
extends AbstractStep
implements ActionListener,
DocumentListener,
FocusListener,
ItemListener {
    public static final String CHECKOUT_DIRECTORY = "checkoutStep.checkoutDirectory";
    private CheckoutPanel workdirPanel;
    private RepositoryPaths repositoryPaths;

    public HelpCtx getHelp() {
        return new HelpCtx(CheckoutStep.class);
    }

    protected JComponent createComponent() {
        if (this.workdirPanel == null) {
            this.workdirPanel = new CheckoutPanel();
            this.workdirPanel.browseWorkdirButton.addActionListener(this);
            this.workdirPanel.scanForProjectsCheckBox.addItemListener(this);
            this.workdirPanel.atWorkingDirLevelCheckBox.addItemListener(this);
            this.workdirPanel.workdirTextField.setText(this.defaultWorkingDirectory().getPath());
            this.workdirPanel.workdirTextField.getDocument().addDocumentListener(this);
            this.workdirPanel.workdirTextField.addFocusListener(this);
            this.workdirPanel.repositoryPathTextField.getDocument().addDocumentListener(this);
            this.workdirPanel.repositoryPathTextField.addFocusListener(this);
            this.workdirPanel.revisionTextField.getDocument().addDocumentListener(this);
            this.workdirPanel.revisionTextField.addFocusListener(this);
        }
        this.validateUserInput(true);
        return this.workdirPanel;
    }

    public void setup(RepositoryFile repositoryFile) {
        if (this.repositoryPaths == null) {
            this.repositoryPaths = new RepositoryPaths(repositoryFile, this.workdirPanel.repositoryPathTextField, this.workdirPanel.browseRepositoryButton, this.workdirPanel.revisionTextField, this.workdirPanel.searchRevisionButton);
            String string = NbBundle.getMessage(CheckoutStep.class, (String)"LBL_BrowserMessage");
            int n = 9;
            this.repositoryPaths.setupBehavior(string, n, "org.netbeans.modules.subversion.ui.browser.checkout", "org.netbeans.modules.subversion.ui.search.checkout");
        } else {
            this.repositoryPaths.setRepositoryFile(repositoryFile);
        }
        this.workdirPanel.repositoryPathTextField.setText(repositoryFile.getPath());
        this.refreshWorkingCopy(new RepositoryFile[]{repositoryFile});
        if (!repositoryFile.getRevision().equals((Object)SVNRevision.HEAD)) {
            this.workdirPanel.revisionTextField.setText(repositoryFile.getRevision().toString());
        } else {
            this.workdirPanel.revisionTextField.setText("");
        }
        this.workdirPanel.scanForProjectsCheckBox.setSelected(SvnModuleConfig.getDefault().getShowCheckoutCompleted());
    }

    protected void validateBeforeNext() {
        boolean bl;
        String string;
        File file;
        if (this.validateUserInput(true) && !(file = new File(string = this.workdirPanel.workdirTextField.getText())).exists() && !(bl = file.mkdirs())) {
            this.invalid(new AbstractStep.WizardMessage(NbBundle.getMessage(CheckoutWizard.class, (String)"BK2013") + file.getPath(), false));
        }
    }

    private boolean validateUserInput(boolean bl) {
        String string;
        if (this.repositoryPaths != null) {
            try {
                this.repositoryPaths.getRepositoryFiles();
            }
            catch (NumberFormatException numberFormatException) {
                this.invalid(new AbstractStep.WizardMessage(NbBundle.getMessage(CheckoutStep.class, (String)"BK2018"), false));
                return false;
            }
            catch (MalformedURLException malformedURLException) {
                this.invalid(new AbstractStep.WizardMessage(NbBundle.getMessage(CheckoutStep.class, (String)"BK2015"), true));
                return false;
            }
        }
        if ((string = this.workdirPanel.workdirTextField.getText()) == null || string.length() == 0) {
            this.invalid(new AbstractStep.WizardMessage(NbBundle.getMessage(CheckoutStep.class, (String)"BK2014"), true));
            return false;
        }
        AbstractStep.WizardMessage wizardMessage = null;
        if (bl) {
            File file = new File(string);
            if (!file.exists()) {
                for (File file2 = file.getParentFile(); file2 != null; file2 = file2.getParentFile()) {
                    if (!file2.exists()) continue;
                    if (!file2.canWrite()) {
                        wizardMessage = new AbstractStep.WizardMessage(NbBundle.getMessage(CheckoutStep.class, (String)"BK2016") + file2.getPath(), false);
                    }
                    break;
                }
            } else if (file.isFile()) {
                wizardMessage = new AbstractStep.WizardMessage(NbBundle.getMessage(CheckoutStep.class, (String)"BK2017"), false);
            }
        }
        if (wizardMessage == null) {
            this.valid();
        } else {
            this.invalid(wizardMessage);
        }
        return wizardMessage == null;
    }

    private void onBrowseWorkdir() {
        File file = this.defaultWorkingDirectory();
        AccessibleJFileChooser accessibleJFileChooser = new AccessibleJFileChooser(NbBundle.getMessage(CheckoutStep.class, (String)"ACSD_BrowseFolder"), file);
        accessibleJFileChooser.setDialogTitle(NbBundle.getMessage(CheckoutStep.class, (String)"BK0010"));
        accessibleJFileChooser.setMultiSelectionEnabled(false);
        FileFilter[] fileFilterArray = accessibleJFileChooser.getChoosableFileFilters();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            FileFilter fileFilter = fileFilterArray[i];
            accessibleJFileChooser.removeChoosableFileFilter(fileFilter);
        }
        accessibleJFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }

            public String getDescription() {
                return NbBundle.getMessage(CheckoutStep.class, (String)"BK0008");
            }
        });
        accessibleJFileChooser.setFileSelectionMode(1);
        accessibleJFileChooser.showDialog(this.workdirPanel, NbBundle.getMessage(CheckoutStep.class, (String)"BK0009"));
        File file2 = accessibleJFileChooser.getSelectedFile();
        if (file2 != null) {
            this.workdirPanel.workdirTextField.setText(file2.getAbsolutePath());
        }
    }

    private File defaultWorkingDirectory() {
        Object object;
        Object object2 = null;
        String string = this.workdirPanel.workdirTextField.getText();
        if (string != null && !string.trim().equals("")) {
            for (object = new File(string); object != null && !((File)object).exists(); object = ((File)object).getParentFile()) {
            }
            if (object != null) {
                object2 = ((File)object).isFile() ? ((File)object).getParentFile() : object;
            }
        }
        if (object2 == null && (object = SvnModuleConfig.getDefault().getPreferences().get(CHECKOUT_DIRECTORY, null)) != null) {
            object2 = new File((String)object);
        }
        if (object2 == null && ((File)(object = ProjectChooser.getProjectsFolder())).exists() && ((File)object).isDirectory()) {
            object2 = object;
        }
        if (object2 == null) {
            object2 = new File(System.getProperty("user.home"));
        }
        return object2;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.validateUserInput(false);
        this.repositoryFoldersChanged();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.validateUserInput(false);
        this.repositoryFoldersChanged();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.validateUserInput(true);
        this.repositoryFoldersChanged();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        assert (actionEvent.getSource() == this.workdirPanel.browseWorkdirButton);
        this.onBrowseWorkdir();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.workdirPanel.scanForProjectsCheckBox) {
            SvnModuleConfig.getDefault().setShowCheckoutCompleted(this.workdirPanel.scanForProjectsCheckBox.isSelected());
        } else if (object == this.workdirPanel.atWorkingDirLevelCheckBox) {
            RepositoryFile[] repositoryFileArray = null;
            if (this.getRepositoryPath().length() != 0) {
                try {
                    repositoryFileArray = this.repositoryPaths.getRepositoryFiles();
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            this.refreshWorkingCopy(repositoryFileArray);
        }
    }

    public File getWorkdir() {
        return new File(this.workdirPanel.workdirTextField.getText());
    }

    public RepositoryFile[] getRepositoryFiles() {
        try {
            return this.repositoryPaths.getRepositoryFiles(".");
        }
        catch (MalformedURLException malformedURLException) {
            Subversion.LOG.log(Level.INFO, null, malformedURLException);
            return null;
        }
    }

    public boolean isAtWorkingDirLevel() {
        return this.workdirPanel.atWorkingDirLevelCheckBox.isSelected();
    }

    private void repositoryFoldersChanged() {
        if (this.getRepositoryPath().equals("")) {
            this.resetWorkingDirLevelCheckBox();
            this.refreshWorkingCopy(null);
            return;
        }
        RepositoryFile[] repositoryFileArray = null;
        try {
            repositoryFileArray = this.repositoryPaths.getRepositoryFiles();
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (repositoryFileArray == null || repositoryFileArray.length == 0 || repositoryFileArray.length > 1) {
            this.resetWorkingDirLevelCheckBox();
            this.refreshWorkingCopy(repositoryFileArray);
            return;
        }
        String string = repositoryFileArray[0].getFileUrl().getLastPathSegment().trim();
        if (string.equals("") || string.equals(".")) {
            this.resetWorkingDirLevelCheckBox();
            this.refreshWorkingCopy(repositoryFileArray);
            return;
        }
        this.workdirPanel.atWorkingDirLevelCheckBox.setText(NbBundle.getMessage(CheckoutStep.class, (String)"CTL_Checkout_CheckoutContentFolder", (Object[])new Object[]{string}));
        this.workdirPanel.atWorkingDirLevelCheckBox.setEnabled(true);
        this.refreshWorkingCopy(repositoryFileArray);
    }

    private void resetWorkingDirLevelCheckBox() {
        this.workdirPanel.atWorkingDirLevelCheckBox.setText(NbBundle.getMessage(CheckoutStep.class, (String)"CTL_Checkout_CheckoutContentEmpty"));
        this.workdirPanel.atWorkingDirLevelCheckBox.setEnabled(false);
    }

    private String getRepositoryPath() {
        return this.workdirPanel.repositoryPathTextField.getText().trim();
    }

    private void refreshWorkingCopy(RepositoryFile[] repositoryFileArray) {
        String string;
        int n;
        String string2 = CheckoutStep.trimTrailingSlashes(this.workdirPanel.workdirTextField.getText().trim());
        int n2 = n = repositoryFileArray != null ? repositoryFileArray.length : 0;
        if (n == 0) {
            string = string2;
        } else {
            String string3 = CheckoutStep.trimSlashes(repositoryFileArray[0].getPath());
            if (string3.equals(".")) {
                string3 = "";
            }
            if (n == 1 && (this.workdirPanel.atWorkingDirLevelCheckBox.isSelected() || string3.length() == 0)) {
                string = string2;
            } else {
                String string4 = repositoryFileArray[0].getName();
                StringBuilder stringBuilder = new StringBuilder(string2.length() + string4.length() + 10);
                stringBuilder.append(string2).append(File.separatorChar).append(string4);
                if (n > 1) {
                    stringBuilder.append(", ...");
                }
                string = stringBuilder.toString();
            }
        }
        this.workdirPanel.workingCopy.setText(string);
    }

    private static String trimTrailingSlashes(String string) {
        return CheckoutStep.trimSlashes(string, true);
    }

    private static String trimSlashes(String string) {
        return CheckoutStep.trimSlashes(string, false);
    }

    private static String trimSlashes(String string, boolean bl) {
        int n;
        int n2;
        int n3 = string.length();
        if (n3 == 0) {
            return string;
        }
        if (!bl) {
            for (n2 = 0; n2 < n3 && string.charAt(n2) == '/'; ++n2) {
            }
            if (n2 == n3) {
                return "";
            }
        }
        for (n = n3; n != 0 && string.charAt(n - 1) == '/'; --n) {
        }
        if (n == 0) {
            return "";
        }
        return n2 == 0 && n == n3 ? string : string.substring(n2, n);
    }
}

