/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.update;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.logging.Level;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.ui.update.FileUpdateInfo;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.tigris.subversion.svnclientadapter.SVNClientException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UpdateResultNode
extends AbstractNode {
    private FileUpdateInfo info;
    static final String COLUMN_NAME_NAME = "name";
    static final String COLUMN_NAME_PATH = "path";
    static final String COLUMN_NAME_STATUS = "status";
    private final MessageFormat conflictFormat = new MessageFormat("<font color=\"#FF0000\">{0}</font>");
    private final MessageFormat mergedFormat = new MessageFormat("<font color=\"#0000FF\">{0}</font>");
    private final MessageFormat removedFormat = new MessageFormat("<font color=\"#999999\">{0}</font>");
    private final MessageFormat addedFormat = new MessageFormat("<font color=\"#008000\">{0}</font>");
    private String statusDisplayName;
    private String htmlDisplayName;
    private final String[] zeros = new String[]{"", "00", "0", ""};

    public UpdateResultNode(FileUpdateInfo fileUpdateInfo) {
        super(Children.LEAF, Lookups.fixed((Object[])new Object[]{fileUpdateInfo}));
        this.info = fileUpdateInfo;
        this.initProperties();
        this.refreshHtmlDisplayName();
    }

    public FileUpdateInfo getInfo() {
        return this.info;
    }

    public String getName() {
        String string = this.info.getFile().getName() + ((this.info.getAction() & FileUpdateInfo.ACTION_TYPE_PROPERTY) != 0 ? " - Property" : "");
        return string;
    }

    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        FileObject fileObject = FileUtil.toFileObject((File)this.info.getFile());
        if (fileObject != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                if (fileObject.equals(dataObject.getPrimaryFile())) {
                    return (T)dataObject.getCookie(clazz);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return (T)super.getCookie(clazz);
    }

    private void initProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new NameProperty());
        set.put((Node.Property)new PathProperty());
        set.put((Node.Property)new FileStatusProperty());
        sheet.put(set);
        this.setSheet(sheet);
    }

    private void refreshHtmlDisplayName() {
        String string = this.getName();
        if ((this.info.getAction() & FileUpdateInfo.ACTION_ADDED) != 0) {
            this.htmlDisplayName = this.addedFormat.format(new Object[]{string});
            this.statusDisplayName = NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Status_Added");
        } else if ((this.info.getAction() & FileUpdateInfo.ACTION_CONFLICTED) != 0) {
            this.htmlDisplayName = this.conflictFormat.format(new Object[]{string});
            this.statusDisplayName = NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Status_Conflict");
        } else if ((this.info.getAction() & FileUpdateInfo.ACTION_DELETED) != 0) {
            this.htmlDisplayName = this.removedFormat.format(new Object[]{string});
            this.statusDisplayName = NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Status_Removed");
        } else if ((this.info.getAction() & FileUpdateInfo.ACTION_MERGED) != 0) {
            this.htmlDisplayName = this.mergedFormat.format(new Object[]{string});
            this.statusDisplayName = NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Status_Merged");
        } else if ((this.info.getAction() & FileUpdateInfo.ACTION_UPDATED) != 0) {
            this.htmlDisplayName = string;
            this.statusDisplayName = NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Status_Updated");
        } else if ((this.info.getAction() & FileUpdateInfo.ACTION_CONFLICTED_RESOLVED) != 0) {
            this.htmlDisplayName = string;
            this.statusDisplayName = NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Status_Conflict_Resolved");
        } else {
            throw new IllegalStateException("Unhandled update type: " + this.info.getAction());
        }
        this.fireDisplayNameChange(this.htmlDisplayName, this.htmlDisplayName);
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    public void refresh() {
        this.refreshHtmlDisplayName();
    }

    private class FileStatusProperty
    extends SyncFileProperty {
        private String shortPath;

        public FileStatusProperty() {
            super(UpdateResultNode.COLUMN_NAME_STATUS, String.class, NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Status_Name"), NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Status_Desc"));
            try {
                this.shortPath = SvnUtils.getRelativePath(UpdateResultNode.this.info.getFile());
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
                this.shortPath = "";
            }
            String string = Integer.toString(UpdateResultNode.this.info.getAction());
            this.setValue("sortkey", UpdateResultNode.this.zeros[string.length()] + string + "\t" + this.shortPath + "\t" + UpdateResultNode.this.getName());
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return UpdateResultNode.this.statusDisplayName;
        }
    }

    private class NameProperty
    extends SyncFileProperty {
        public NameProperty() {
            super(UpdateResultNode.COLUMN_NAME_NAME, String.class, NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Name_Name"), NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Name_Desc"));
            this.setValue("sortkey", UpdateResultNode.this.getName());
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return UpdateResultNode.this.getDisplayName();
        }
    }

    private class PathProperty
    extends SyncFileProperty {
        private String shortPath;

        public PathProperty() {
            super(UpdateResultNode.COLUMN_NAME_PATH, String.class, NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Path_Name"), NbBundle.getMessage(UpdateResultNode.class, (String)"LBL_Path_Desc"));
            try {
                this.shortPath = SvnUtils.getRelativePath(UpdateResultNode.this.info.getFile());
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
                this.shortPath = "";
            }
            this.setValue("sortkey", this.shortPath + "\t" + UpdateResultNode.this.getName());
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return this.shortPath;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class SyncFileProperty
    extends PropertySupport.ReadOnly<String> {
        protected SyncFileProperty(String string, Class<String> clazz, String string2, String string3) {
            super(string, clazz, string2, string3);
        }

        public String toString() {
            try {
                return (String)this.getValue();
            }
            catch (Exception exception) {
                Subversion.LOG.log(Level.INFO, null, exception);
                return exception.getLocalizedMessage();
            }
        }
    }
}

