/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.VersionsCache;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class DiffStreamSource
extends StreamSource
implements Cancellable {
    private final File baseFile;
    private final String revision;
    private final String pegRevision;
    private final String title;
    private String mimeType;
    private SVNUrl url;
    private SVNUrl repoUrl;
    private SvnClient client;
    private File remoteFile;

    public DiffStreamSource(File file, SVNUrl sVNUrl, SVNUrl sVNUrl2, String string, String string2) {
        this.baseFile = file;
        this.revision = this.pegRevision = string;
        this.title = string2;
        this.url = sVNUrl2;
        this.repoUrl = sVNUrl;
    }

    public DiffStreamSource(File file, SVNUrl sVNUrl, SVNUrl sVNUrl2, String string, String string2, String string3) {
        this.baseFile = file;
        this.revision = string;
        this.pegRevision = string2;
        this.title = string3;
        this.url = sVNUrl2;
        this.repoUrl = sVNUrl;
    }

    public String getName() {
        if (this.baseFile != null) {
            return this.baseFile.getName();
        }
        return NbBundle.getMessage(DiffStreamSource.class, (String)"LBL_Diff_Anonymous");
    }

    public String getTitle() {
        return this.title;
    }

    public synchronized String getMIMEType() {
        try {
            this.init();
        }
        catch (IOException iOException) {
            Subversion.LOG.log(Level.INFO, "DiffStreamSource.getMIMEType() returns null", iOException);
            return null;
        }
        return this.mimeType;
    }

    public synchronized Reader createReader() throws IOException {
        this.init();
        if (this.revision == null || this.remoteFile == null) {
            return null;
        }
        if (!this.mimeType.startsWith("text/")) {
            return null;
        }
        return Utils.createReader((File)this.remoteFile);
    }

    public Writer createWriter(Difference[] differenceArray) throws IOException {
        throw new IOException("Operation not supported");
    }

    public boolean isEditable() {
        return false;
    }

    private boolean isPrimary() {
        FileObject fileObject = FileUtil.toFileObject((File)this.baseFile);
        if (fileObject != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                return fileObject.equals(dataObject.getPrimaryFile());
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return true;
    }

    public synchronized Lookup getLookup() {
        try {
            this.init();
        }
        catch (IOException iOException) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        if (this.remoteFile == null || !this.isPrimary()) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        FileObject fileObject = FileUtil.toFileObject((File)this.remoteFile);
        if (fileObject == null) {
            return Lookups.fixed((Object[])new Object[0]);
        }
        return Lookups.fixed((Object[])new Object[]{fileObject});
    }

    synchronized void init() throws IOException {
        if (this.remoteFile != null || this.revision == null) {
            return;
        }
        if (this.baseFile.isDirectory()) {
            this.mimeType = "content/unknown";
            return;
        }
        this.mimeType = SvnUtils.getMimeType(this.baseFile);
        try {
            if (this.isEditable()) {
                this.remoteFile = VersionsCache.getInstance().getFileRevision(this.baseFile, this.revision);
            } else {
                File file = VersionsCache.getInstance().getFileRevision(this.repoUrl, this.url, this.revision, this.pegRevision, this.baseFile.getName());
                if (file == null) {
                    this.remoteFile = null;
                    return;
                }
                this.remoteFile = file;
                Utils.associateEncoding((File)this.baseFile, (File)file);
            }
        }
        catch (IOException iOException) {
            if (iOException.getCause() != null && SvnClientExceptionHandler.isTargetDirectory(iOException.getCause().getMessage()) || SvnClientExceptionHandler.isTargetDirectory(iOException.getMessage())) {
                Subversion.LOG.log(Level.FINE, "", iOException);
                this.mimeType = "content/unknown";
                return;
            }
            throw iOException;
        }
        if (!this.baseFile.exists() && this.remoteFile != null && this.remoteFile.exists()) {
            this.mimeType = SvnUtils.getMimeType(this.remoteFile);
        }
    }

    public boolean cancel() {
        if (this.client != null) {
            this.client.cancel();
        }
        return true;
    }
}

