/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.copy;

import java.awt.EventQueue;
import java.io.File;
import java.text.MessageFormat;
import java.util.logging.Level;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.copy.CreateCopy;
import org.netbeans.modules.subversion.ui.copy.SwitchToAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class CreateCopyAction
extends ContextAction {
    private static final String MESSAGE_CREATE_FOLDER = "Netbeans SVN client generated message: create a new folder for the copy:\n{0}";

    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_Copy";
    }

    protected int getFileEnabledStatus() {
        return -4;
    }

    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    protected boolean enable(Node[] nodeArray) {
        return nodeArray != null && nodeArray.length == 1 && this.getCachedContext(nodeArray).getRoots().size() > 0;
    }

    protected void performContextAction(Node[] nodeArray) {
        SVNUrl sVNUrl;
        SVNUrl sVNUrl2;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context context = this.getContext(nodeArray);
        File[] fileArray = SvnUtils.getActionRoots(context);
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        File[] fileArray2 = Subversion.getInstance().getStatusCache().listFiles(context, 6612);
        File file = fileArray.length == 1 ? fileArray[0] : SvnUtils.getPrimaryFile(fileArray[0]);
        try {
            sVNUrl2 = SvnUtils.getRepositoryRootUrl(file);
            sVNUrl = SvnUtils.getRepositoryUrl(file);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        RepositoryFile repositoryFile = new RepositoryFile(sVNUrl2, sVNUrl, SVNRevision.HEAD);
        RequestProcessor requestProcessor = this.createRequestProcessor(nodeArray);
        boolean bl = fileArray2.length > 0;
        CreateCopy createCopy = new CreateCopy(repositoryFile, file, bl);
        this.performCopy(createCopy, requestProcessor, nodeArray, fileArray);
    }

    private void performCopy(final CreateCopy createCopy, final RequestProcessor requestProcessor, final Node[] nodeArray, final File[] fileArray) {
        if (!createCopy.showDialog()) {
            return;
        }
        requestProcessor.post(new Runnable(){

            public void run() {
                String string = CreateCopyAction.this.validateTargetPath(createCopy);
                if (string == null) {
                    ContextAction.ProgressSupport progressSupport = new ContextAction.ProgressSupport(CreateCopyAction.this, nodeArray){

                        public void perform() {
                            CreateCopyAction.this.performCopy(createCopy, this, fileArray);
                        }
                    };
                    progressSupport.start(requestProcessor);
                } else {
                    SvnClientExceptionHandler.annotate(string);
                    createCopy.setErrorText(string);
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            CreateCopyAction.this.performCopy(createCopy, requestProcessor, nodeArray, fileArray);
                        }
                    });
                }
            }
        });
    }

    private String validateTargetPath(CreateCopy createCopy) {
        String string = null;
        try {
            ISVNInfo iSVNInfo;
            block5: {
                RepositoryFile repositoryFile = createCopy.getToRepositoryFile();
                SvnClient svnClient = Subversion.getInstance().getClient(repositoryFile.getRepositoryUrl());
                iSVNInfo = null;
                try {
                    iSVNInfo = svnClient.getInfo(repositoryFile.getFileUrl());
                }
                catch (SVNClientException sVNClientException) {
                    if (SvnClientExceptionHandler.isWrongUrl(sVNClientException.getMessage())) break block5;
                    throw sVNClientException;
                }
            }
            if (iSVNInfo != null) {
                string = NbBundle.getMessage(CreateCopyAction.class, (String)"MSG_CreateCopy_Target_Exists");
            }
        }
        catch (SVNClientException sVNClientException) {
            string = null;
        }
        return string;
    }

    private void performCopy(CreateCopy createCopy, SvnProgressSupport svnProgressSupport, File[] fileArray) {
        if (fileArray == null) {
            return;
        }
        RepositoryFile repositoryFile = createCopy.getToRepositoryFile();
        try {
            SVNUrl sVNUrl;
            Object object;
            SvnClient svnClient;
            try {
                svnClient = Subversion.getInstance().getClient(repositoryFile.getRepositoryUrl());
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                return;
            }
            if (!repositoryFile.isRepositoryRoot()) {
                ISVNInfo iSVNInfo;
                block27: {
                    block26: {
                        object = repositoryFile.removeLastSegment().getFileUrl();
                        try {
                            svnClient.getInfo((SVNUrl)object);
                        }
                        catch (SVNClientException sVNClientException) {
                            if (SvnClientExceptionHandler.isWrongUrl(sVNClientException.getMessage())) break block26;
                            throw sVNClientException;
                        }
                    }
                    iSVNInfo = null;
                    try {
                        iSVNInfo = svnClient.getInfo((SVNUrl)object);
                    }
                    catch (SVNClientException sVNClientException) {
                        if (SvnClientExceptionHandler.isWrongUrl(sVNClientException.getMessage())) break block27;
                        throw sVNClientException;
                    }
                }
                if (svnProgressSupport.isCanceled()) {
                    return;
                }
                if (iSVNInfo == null) {
                    svnClient.mkdir((SVNUrl)object, true, this.getCreateFolderMessage(createCopy.getMessage()));
                }
            }
            if (svnProgressSupport.isCanceled()) {
                return;
            }
            if (createCopy.isLocal()) {
                if (fileArray.length == 1) {
                    svnClient.copy(new File[]{createCopy.getLocalFile()}, repositoryFile.getFileUrl(), createCopy.getMessage(), true, false);
                } else {
                    for (File object2 : fileArray) {
                        sVNUrl = this.getToRepositoryFile(repositoryFile, object2).getFileUrl();
                        svnClient.copy(new File[]{object2}, sVNUrl, createCopy.getMessage(), true, false);
                    }
                }
            } else if (fileArray.length == 1) {
                object = createCopy.getFromRepositoryFile();
                svnClient.copy(((RepositoryFile)object).getFileUrl(), repositoryFile.getFileUrl(), createCopy.getMessage(), ((RepositoryFile)object).getRevision(), false);
            } else {
                for (File file : fileArray) {
                    sVNUrl = SvnUtils.getRepositoryRootUrl(file).appendPath(SvnUtils.getRepositoryPath(file));
                    SVNUrl sVNUrl2 = this.getToRepositoryFile(repositoryFile, file).getFileUrl();
                    svnClient.copy(sVNUrl, sVNUrl2, createCopy.getMessage(), SVNRevision.HEAD, false);
                }
            }
            if (svnProgressSupport.isCanceled()) {
                return;
            }
            if (createCopy.switchTo()) {
                if (fileArray != null && fileArray.length > 1) {
                    for (File file : fileArray) {
                        SwitchToAction.performSwitch(this.getToRepositoryFile(repositoryFile, file), file, svnProgressSupport);
                    }
                } else {
                    SwitchToAction.performSwitch(repositoryFile, createCopy.getLocalFile(), svnProgressSupport);
                }
            }
        }
        catch (SVNClientException sVNClientException) {
            svnProgressSupport.annotate(sVNClientException);
        }
    }

    private RepositoryFile getToRepositoryFile(RepositoryFile repositoryFile, File file) {
        return repositoryFile.replaceLastSegment(file.getName(), 0);
    }

    private String getCreateFolderMessage(String string) {
        String string2;
        String string3 = System.getProperty("subversion.copy.createFolderMessage", MESSAGE_CREATE_FOLDER);
        if (string3 == null || string3.length() == 0) {
            string3 = "{0}";
        }
        try {
            string2 = MessageFormat.format(string3, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Subversion.LOG.log(Level.INFO, string3, illegalArgumentException);
            string2 = MessageFormat.format(MESSAGE_CREATE_FOLDER, string);
        }
        return string2;
    }
}

