/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.browser;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.sql.Date;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.JButton;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.browser.Browser;
import org.netbeans.modules.subversion.ui.browser.BrowserAction;
import org.netbeans.modules.subversion.ui.browser.BrowserClient;
import org.netbeans.modules.subversion.ui.browser.RepositoryPathNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class CreateFolderAction
extends BrowserAction
implements PropertyChangeListener {
    private final String defaultFolderName;

    public CreateFolderAction(String string) {
        this.defaultFolderName = string;
        this.putValue("Name", NbBundle.getMessage(RepositoryPathNode.class, (String)"CTL_Action_MakeDir"));
        this.setEnabled(false);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            this.setEnabled(this.isEnabled());
        }
    }

    public boolean isEnabled() {
        Browser browser = this.getBrowser();
        if (browser == null) {
            return false;
        }
        if (browser.getExplorerManager().getRootContext() == Node.EMPTY) {
            return false;
        }
        Node[] nodeArray = this.getBrowser().getSelectedNodes();
        if (nodeArray.length != 1) {
            return false;
        }
        return nodeArray[0] instanceof RepositoryPathNode && ((RepositoryPathNode)nodeArray[0]).getEntry().getSvnNodeKind() == SVNNodeKind.DIR;
    }

    public void setBrowser(Browser browser) {
        Browser browser2 = this.getBrowser();
        if (browser2 != null) {
            browser2.removePropertyChangeListener(this);
        }
        browser.addPropertyChangeListener(this);
        super.setBrowser(browser);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                Node[] nodeArray = CreateFolderAction.this.getSelectedNodes();
                if (nodeArray.length > 1) {
                    return;
                }
                RepositoryPathNode repositoryPathNode = (RepositoryPathNode)nodeArray[0];
                Children children = repositoryPathNode.getChildren();
                Node[] nodeArray2 = children.getNodes();
                if (nodeArray2.length > 0) {
                    try {
                        CreateFolderAction.this.getExplorerManager().setSelectedNodes(new Node[]{nodeArray2[0]});
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        Subversion.LOG.log(Level.INFO, null, propertyVetoException);
                    }
                }
                NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/browser/Bundle").getString("CTL_Browser_NewFolder_Prompt"), ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/browser/Bundle").getString("CTL_Browser_NewFolder_Title"));
                inputLine.setInputText(CreateFolderAction.this.defaultFolderName);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
                String string = inputLine.getInputText().trim();
                if (inputLine.getValue() == DialogDescriptor.CANCEL_OPTION || inputLine.getValue() == DialogDescriptor.CLOSED_OPTION || string.equals("")) {
                    return;
                }
                RepositoryFile repositoryFile = repositoryPathNode.getEntry().getRepositoryFile();
                RepositoryPathNode repositoryPathNode2 = repositoryPathNode;
                String[] stringArray = string.split("/");
                boolean bl = true;
                for (int i = 0; i < stringArray.length; ++i) {
                    RepositoryPathNode repositoryPathNode3;
                    Object object;
                    RepositoryFile repositoryFile2 = repositoryFile.appendPath(stringArray[i]);
                    Node node = repositoryPathNode2.getChildren().findChild(stringArray[i]);
                    if (node != null) {
                        repositoryPathNode2 = node;
                    } else {
                        bl = false;
                        object = new RepositoryPathNode.RepositoryPathEntry(repositoryFile2, SVNNodeKind.DIR, new SVNRevision(0), new Date(System.currentTimeMillis()), "");
                        repositoryPathNode3 = RepositoryPathNode.createRepositoryPathNode((BrowserClient)CreateFolderAction.this.getBrowser(), (RepositoryPathNode.RepositoryPathEntry)object);
                        repositoryPathNode2.getChildren().add(new Node[]{repositoryPathNode3});
                        repositoryPathNode2 = repositoryPathNode3;
                    }
                    repositoryFile = repositoryFile2;
                    if (i != stringArray.length - 1) continue;
                    if (bl) {
                        object = new JButton(ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/browser/Bundle").getString("CTL_Browser_OK"));
                        repositoryPathNode3 = new NotifyDescriptor((Object)NbBundle.getMessage(CreateFolderAction.class, (String)"MSG_Browser_FolderExists", (Object)string), NbBundle.getMessage(CreateFolderAction.class, (String)"MSG_Browser_WrongFolerName"), -1, 0, new Object[]{object}, object);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)repositoryPathNode3);
                    }
                    try {
                        CreateFolderAction.this.setSelectedNodes(new Node[]{repositoryPathNode2});
                        continue;
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        Subversion.LOG.log(Level.INFO, null, propertyVetoException);
                    }
                }
            }
        });
    }
}

