/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.kenai;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JTextPane;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.notifications.NotificationsManager;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.VCSKenaiSupport;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class KenaiNotificationListener
extends VCSKenaiSupport.KenaiNotificationListener {
    protected void handleVCSNotification(VCSKenaiSupport.VCSKenaiNotification vCSKenaiNotification) {
        if (vCSKenaiNotification.getService() != VCSKenaiSupport.Service.VCS_SVN) {
            LOG.fine("rejecting VCS notification " + vCSKenaiNotification + " because not from svn");
            return;
        }
        File file = vCSKenaiNotification.getProjectDirectory();
        if (!SvnUtils.isManaged(file)) {
            assert (false) : " project " + file + " not managed";
            LOG.fine("rejecting VCS notification " + vCSKenaiNotification + " for " + file + " because not versioned by svn");
            return;
        }
        LOG.fine("accepting VCS notification " + vCSKenaiNotification + " for " + file);
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        File[] fileArray = fileStatusCache.listFiles(new File[]{file}, 6612);
        List list = vCSKenaiNotification.getModifications();
        LinkedList<File> linkedList = new LinkedList<File>();
        String string = null;
        block4: for (File file2 : fileArray) {
            String string2;
            try {
                string2 = SvnUtils.getRepositoryPath(file2);
            }
            catch (SVNClientException sVNClientException) {
                LOG.log(Level.WARNING, file2.getAbsolutePath(), sVNClientException);
                continue;
            }
            string2 = this.trim(string2);
            for (VCSKenaiSupport.VCSKenaiModification vCSKenaiModification : list) {
                String string3 = vCSKenaiModification.getResource();
                LOG.finer(" changed file " + string2 + ", " + string3);
                if (!string2.equals(string3 = this.trim(string3))) continue;
                LOG.fine("  will notify " + file2 + ", " + vCSKenaiNotification);
                linkedList.add(file2);
                if (string != null) continue block4;
                string = vCSKenaiModification.getId();
                continue block4;
            }
        }
        if (linkedList.size() > 0) {
            this.notifyFileChange(linkedList.toArray(new File[linkedList.size()]), file, vCSKenaiNotification.getUri().toString(), string);
            try {
                NotificationsManager.getInstance().notfied(fileArray, Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                LOG.log(Level.WARNING, string, numberFormatException);
            }
        }
    }

    protected void setupPane(JTextPane jTextPane, File[] fileArray, File file, String string, String string2) {
        NotificationsManager.getInstance().setupPane(jTextPane, fileArray, this.getFileNames(fileArray), file, string, string2);
    }
}

