/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli.commands;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.subversion.client.cli.SvnCommand;
import org.openide.xml.XMLUtil;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class StatusCommand
extends SvnCommand {
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss Z");
    private byte[] output;
    private final File[] files;
    private final boolean getAll;
    private final boolean descend;
    private final boolean checkUpdates;
    private final boolean ignoreExternals;

    public StatusCommand(File[] fileArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.files = fileArray;
        this.getAll = bl;
        this.descend = bl2;
        this.checkUpdates = bl3;
        this.ignoreExternals = bl4;
    }

    protected boolean hasBinaryOutput() {
        return true;
    }

    protected boolean notifyOutput() {
        return false;
    }

    protected int getCommand() {
        return 12;
    }

    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("status");
        arguments.add("--xml");
        if (this.getAll) {
            arguments.add("-v");
            arguments.add("--no-ignore");
        }
        if (!this.descend) {
            arguments.add("-N");
        }
        if (this.checkUpdates) {
            arguments.add("-u");
        }
        if (this.ignoreExternals) {
            arguments.add("--ignore-externals");
        }
        arguments.add(this.files);
    }

    public void output(byte[] byArray) {
        this.output = byArray;
    }

    public Status[] getStatusValues() throws SVNClientException {
        if (this.output == null || this.output.length == 0) {
            return new Status[0];
        }
        try {
            XMLReader xMLReader = XMLUtil.createXMLReader();
            XmlEntriesHandler xmlEntriesHandler = new XmlEntriesHandler();
            xMLReader.setContentHandler(xmlEntriesHandler);
            xMLReader.setErrorHandler(xmlEntriesHandler);
            InputSource inputSource = new InputSource(new ByteArrayInputStream(this.output));
            xMLReader.parse(inputSource);
            return xmlEntriesHandler.getStatusValues();
        }
        catch (SAXException sAXException) {
            throw new SVNClientException((Throwable)sAXException);
        }
        catch (IOException iOException) {
            throw new SVNClientException((Throwable)iOException);
        }
    }

    public class Status {
        private final String path;
        private final SVNStatusKind wcStatus;
        private final SVNStatusKind wcPropsStatus;
        private final SVNRevision.Number wcRev;
        private final boolean wcLocked;
        private final boolean wcCopied;
        private final boolean wcSwitched;
        private final SVNRevision.Number commitRev;
        private final String author;
        private final Date changeDate;
        private final String lockOwner;
        private final String lockComment;
        private final Date lockCreated;
        private final SVNStatusKind repoStatus;
        private final SVNStatusKind repoPropsStatus;

        public Status(String string, SVNStatusKind sVNStatusKind, SVNStatusKind sVNStatusKind2, SVNRevision.Number number, boolean bl, boolean bl2, boolean bl3, SVNRevision.Number number2, String string2, Date date, String string3, String string4, Date date2, SVNStatusKind sVNStatusKind3, SVNStatusKind sVNStatusKind4) {
            this.path = string;
            this.wcStatus = sVNStatusKind;
            this.wcPropsStatus = sVNStatusKind2;
            this.wcRev = number;
            this.wcLocked = bl;
            this.wcCopied = bl2;
            this.wcSwitched = bl3;
            this.commitRev = number2;
            this.author = string2;
            this.changeDate = date;
            this.lockOwner = string3;
            this.lockComment = string4;
            this.lockCreated = date2;
            this.repoStatus = sVNStatusKind3;
            this.repoPropsStatus = sVNStatusKind4;
        }

        public String getAuthor() {
            return this.author;
        }

        public Date getChangeDate() {
            return this.changeDate;
        }

        public SVNRevision.Number getCommitRev() {
            return this.commitRev;
        }

        public String getLockComment() {
            return this.lockComment;
        }

        public Date getLockCreated() {
            return this.lockCreated;
        }

        public String getLockOwner() {
            return this.lockOwner;
        }

        public String getPath() {
            return this.path;
        }

        public SVNStatusKind getRepoPropsStatus() {
            return this.repoPropsStatus;
        }

        public SVNStatusKind getRepoStatus() {
            return this.repoStatus;
        }

        public boolean isWcCopied() {
            return this.wcCopied;
        }

        public boolean isWcLocked() {
            return this.wcLocked;
        }

        public SVNStatusKind getWcPropsStatus() {
            return this.wcPropsStatus;
        }

        public SVNRevision.Number getWcRev() {
            return this.wcRev;
        }

        public SVNStatusKind getWcStatus() {
            return this.wcStatus;
        }

        public boolean isWcSwitched() {
            return this.wcSwitched;
        }
    }

    private class XmlEntriesHandler
    extends DefaultHandler {
        private List<Status> statusValues = new ArrayList<Status>();
        private static final String WC_ST_ELEMENT_NAME = "wc-status";
        private static final String ENTRY_ELEMENT_NAME = "entry";
        private static final String NAME_ELEMENT_NAME = "name";
        private static final String SIZE_ELEMENT_NAME = "size";
        private static final String COMMIT_ELEMENT_NAME = "commit";
        private static final String AUTHOR_ELEMENT_NAME = "author";
        private static final String DATE_ELEMENT_NAME = "date";
        private static final String LOCK_ELEMENT_NAME = "lock";
        private static final String REPO_ST_ELEMENT_NAME = "repos-status";
        private static final String TOKEN_ELEMENT_NAME = "token";
        private static final String OWNER_ELEMENT_NAME = "owner";
        private static final String COMMENT_ELEMENT_NAME = "comment";
        private static final String CREATED_ELEMENT_NAME = "created";
        private static final String EXPIRES_ELEMENT_NAME = "expires";
        private static final String PATH_ATTRIBUTE = "path";
        private static final String PROPS_ATTRIBUTE = "props";
        private static final String ITEM_ATTRIBUTE = "item";
        private static final String WC_LOCKED_ATTRIBUTE = "wc-locked";
        private static final String COPIED_ATTRIBUTE = "copied";
        private static final String SWITCHED_ATTRIBUTE = "switched";
        private static final String REVISION_ATTRIBUTE = "revision";
        private static final String PATH_ATTR = "path";
        private static final String WC_PROPS_ATTR = "wcprops";
        private static final String REPO_PROPS_ATTR = "repoprops";
        private static final String WC_ITEM_ATTR = "wcitem";
        private static final String REPO_ITEM_ATTR = "repoitem";
        private static final String WC_LOCKED_ATTR = "wc-locked";
        private static final String WC_COPIED_ATTR = "copied";
        private static final String WC_SWITCHED_ATTR = "switched";
        private static final String WC_REVISION_ATTR = "wcrevision";
        private static final String CI_REVISION_ATTR = "reporevision";
        private Map<String, String> values;
        private String tag;

        private XmlEntriesHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.tag = string3.trim();
            if (ENTRY_ELEMENT_NAME.equals(string3)) {
                this.values = new HashMap<String, String>();
                this.values.put("path", attributes.getValue("path"));
            } else if (WC_ST_ELEMENT_NAME.equals(string3)) {
                this.values.put(WC_ITEM_ATTR, attributes.getValue(ITEM_ATTRIBUTE));
                this.values.put(WC_PROPS_ATTR, attributes.getValue(PROPS_ATTRIBUTE));
                this.values.put(WC_REVISION_ATTR, attributes.getValue(REVISION_ATTRIBUTE));
                this.values.put("wc-locked", attributes.getValue("wc-locked"));
                this.values.put("copied", attributes.getValue("copied"));
                this.values.put("switched", attributes.getValue("switched"));
            } else if (REPO_ST_ELEMENT_NAME.equals(string3)) {
                this.values.put(REPO_ITEM_ATTR, attributes.getValue(ITEM_ATTRIBUTE));
                this.values.put(REPO_PROPS_ATTR, attributes.getValue(PROPS_ATTRIBUTE));
            } else if (COMMIT_ELEMENT_NAME.equals(string3)) {
                this.values.put(CI_REVISION_ATTR, attributes.getValue(REVISION_ATTRIBUTE));
            }
            if (this.values != null) {
                this.values.put(this.tag, "");
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.values == null || this.tag == null) {
                return;
            }
            String string = this.toString(n2, cArray, n);
            String string2 = this.values.get(string);
            if (string2 == null) {
                this.values.put(this.tag, string);
            } else {
                this.values.put(this.tag, string2 + string);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            this.tag = null;
            if (ENTRY_ELEMENT_NAME.equals(string3)) {
                if (this.values != null) {
                    String string4 = this.values.get("path");
                    if (this.values.get(WC_ST_ELEMENT_NAME) == null) {
                        throw new SAXException("'wc-status' tag expected under 'entry'");
                    }
                    SVNStatusKind sVNStatusKind = SVNStatusKind.fromString((String)this.values.get(WC_ITEM_ATTR));
                    SVNStatusKind sVNStatusKind2 = SVNStatusKind.fromString((String)this.values.get(WC_PROPS_ATTR));
                    SVNRevision.Number number = this.getRevision(this.values.get(WC_REVISION_ATTR));
                    boolean bl = this.getBoolean(this.values.get("wc-locked"));
                    boolean bl2 = this.getBoolean(this.values.get("copied"));
                    boolean bl3 = this.getBoolean(this.values.get("switched"));
                    SVNRevision.Number number2 = this.getRevision(this.values.get(CI_REVISION_ATTR));
                    String string5 = this.values.get(AUTHOR_ELEMENT_NAME);
                    Date date = this.getDate(this.values.get(DATE_ELEMENT_NAME));
                    String string6 = null;
                    String string7 = null;
                    String string8 = null;
                    Date date2 = null;
                    Date date3 = null;
                    if (this.values.get(LOCK_ELEMENT_NAME) != null) {
                        string6 = this.values.get(TOKEN_ELEMENT_NAME);
                        if (string6 == null) {
                            throw new SAXException("'token' tag expected under 'lock'");
                        }
                        string7 = this.values.get(OWNER_ELEMENT_NAME);
                        if (string7 == null) {
                            throw new SAXException("'owner' tag expected under 'lock'");
                        }
                        string8 = this.values.get(COMMENT_ELEMENT_NAME);
                        date2 = this.getDate(this.values.get(CREATED_ELEMENT_NAME));
                        date3 = this.getDate(this.values.get(EXPIRES_ELEMENT_NAME));
                    }
                    SVNStatusKind sVNStatusKind3 = null;
                    SVNStatusKind sVNStatusKind4 = null;
                    if (this.values.get(REPO_ST_ELEMENT_NAME) != null) {
                        sVNStatusKind3 = SVNStatusKind.fromString((String)this.values.get(REPO_ITEM_ATTR));
                        sVNStatusKind4 = SVNStatusKind.fromString((String)this.values.get(REPO_PROPS_ATTR));
                    }
                    this.statusValues.add(new Status(string4, sVNStatusKind, sVNStatusKind2, number, bl, bl2, bl3, number2, string5, date, string7, string8, date2, sVNStatusKind3, sVNStatusKind4));
                }
                this.values = null;
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public Status[] getStatusValues() {
            return this.statusValues != null ? this.statusValues.toArray(new Status[this.statusValues.size()]) : new Status[]{};
        }

        private boolean getBoolean(String string) {
            return string != null && string.trim().equals("true");
        }

        private String toString(int n, char[] cArray, int n2) {
            char[] cArray2 = new char[n];
            System.arraycopy(cArray, n2, cArray2, 0, n);
            return new String(cArray2);
        }

        private Date getDate(String string) {
            Date date = null;
            if (string != null) {
                try {
                    date = dateFormat.parse(string);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return date;
        }

        private SVNRevision.Number getRevision(String string) {
            SVNRevision.Number number = null;
            if (string != null && !string.trim().equals("")) {
                try {
                    number = new SVNRevision.Number(Long.parseLong(string));
                }
                catch (NumberFormatException numberFormatException) {
                    new SVNRevision.Number(-1L);
                }
            }
            return number;
        }
    }
}

