/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class SvnFileNode {
    private final File file;
    private String relativePath;
    private String copy;
    private boolean copyScanned;

    public SvnFileNode(File file) {
        this.file = FileUtil.normalizeFile((File)file);
    }

    public String getName() {
        return this.file.getName();
    }

    public FileInformation getInformation() {
        return Subversion.getInstance().getStatusCache().getStatus(this.file);
    }

    public File getFile() {
        return this.file;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof SvnFileNode && this.file.equals(((SvnFileNode)object).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public FileObject getFileObject() {
        return FileUtil.toFileObject((File)this.file);
    }

    public Object[] getLookupObjects() {
        ArrayList<File> arrayList = new ArrayList<File>(2);
        arrayList.add(this.file);
        FileObject fileObject = this.getFileObject();
        if (fileObject != null) {
            arrayList.add((File)fileObject);
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    public String getRelativePath() {
        if (this.relativePath == null) {
            try {
                assert (!EventQueue.isDispatchThread());
                this.relativePath = SvnUtils.getRelativePath(this.getFile());
            }
            catch (SVNClientException sVNClientException) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
            }
            if (this.relativePath == null) {
                this.relativePath = NbBundle.getMessage(SvnFileNode.class, (String)"SvnFileNode.relativePath.unknown");
            }
        }
        return this.relativePath;
    }

    public String getCopy() {
        if (!this.copyScanned) {
            assert (!EventQueue.isDispatchThread());
            this.copy = SvnUtils.getCopy(this.getFile());
            this.copyScanned = true;
        }
        return this.copy;
    }
}

