/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChildFactory<T> {
    private Reference<Observer> observer = null;

    protected Node createNodeForKey(T t) {
        throw new AssertionError((Object)("Neither createNodeForKey() nor createNodesForKey() overridden in " + this.getClass().getName()));
    }

    protected Node[] createNodesForKey(T t) {
        Node[] nodeArray;
        Node node = this.createNodeForKey(t);
        if (node == null) {
            nodeArray = null;
        } else {
            Node[] nodeArray2 = new Node[1];
            nodeArray = nodeArray2;
            nodeArray2[0] = node;
        }
        return nodeArray;
    }

    protected abstract boolean createKeys(List<T> var1);

    protected final void refresh(boolean bl) {
        Observer observer;
        Observer observer2 = observer = this.observer == null ? null : this.observer.get();
        if (observer != null) {
            observer.refresh(bl);
        }
    }

    Node getWaitNode() {
        Node node = this.createWaitNode();
        return node == null ? null : new WaitFilterNode(node);
    }

    protected Node createWaitNode() {
        AbstractNode abstractNode = new AbstractNode(Children.LEAF){

            public Action[] getActions(boolean bl) {
                return new Action[0];
            }
        };
        abstractNode.setIconBaseWithExtension("org/openide/nodes/wait.gif");
        abstractNode.setDisplayName(NbBundle.getMessage(ChildFactory.class, (String)"LBL_WAIT"));
        return abstractNode;
    }

    final void setObserver(Observer observer) {
        if (this.observer != null) {
            throw new IllegalStateException("Attempting to create two Children objects for a single ChildFactory " + this + ".  Use " + "FilterNode.Children over the existing Children object " + "instead");
        }
        this.observer = new WeakReference<Observer>(observer);
    }

    void removeNotify() {
    }

    void addNotify() {
    }

    static boolean isWaitNode(Object object) {
        return object instanceof WaitFilterNode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Detachable<T>
    extends ChildFactory<T> {
        @Override
        protected void addNotify() {
        }

        @Override
        protected void removeNotify() {
        }
    }

    private static final class WaitFilterNode
    extends FilterNode {
        public WaitFilterNode(Node node) {
            super(node);
        }
    }

    static interface Observer {
        public void refresh(boolean var1);
    }
}

