/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.j2me.cdc.platform.CDCDevice;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.j2me.cdc.project.ui.wizards.PanelConfigurePlatform;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class PanelConfigurePlatformVisual
extends JPanel {
    protected PanelConfigurePlatform panel;
    private PlatformComboBoxModel model;
    private CDCDevice[] devices;
    private String platformType;
    private JPanel containerPanel;
    private JComboBox jComboBoxDevice;
    private JComboBox jComboPlatform;
    private JComboBox jComboProfile;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSeparator jSeparator1;

    public PanelConfigurePlatformVisual(PanelConfigurePlatform panelConfigurePlatform, String string) {
        this.panel = panelConfigurePlatform;
        this.platformType = string;
        this.setName(NbBundle.getMessage(PanelConfigurePlatformVisual.class, (String)"LAB_SelectPlatform"));
        this.initComponents();
    }

    protected void selectPlatformPanel() {
        String string = ((PlatformKey)this.model.getSelectedItem()).getPlatform().getType();
    }

    protected void selectDevice() {
        CDCPlatform cDCPlatform = ((PlatformKey)this.model.getSelectedItem()).getPlatform();
        this.devices = cDCPlatform.getDevices();
        Vector<String> vector = new Vector<String>();
        for (CDCDevice cDCDevice : this.devices) {
            vector.add(cDCDevice.getName());
        }
        this.jComboBoxDevice.setModel(new DefaultComboBoxModel(vector));
    }

    protected void selectProfile() {
        String string = null;
        Object object = this.jComboBoxDevice.getSelectedItem();
        for (CDCDevice cDCDevice : this.devices) {
            if (!cDCDevice.getName().equals(object)) continue;
            CDCDevice.CDCProfile[] cDCProfileArray = cDCDevice.getProfiles();
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < cDCProfileArray.length; ++i) {
                String string2 = cDCProfileArray[i].getName();
                vector.add(string2);
                if (!cDCProfileArray[i].isDefault()) continue;
                string = string2;
            }
            this.jComboProfile.setModel(new DefaultComboBoxModel(vector));
            this.jComboProfile.setSelectedItem(string);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jComboPlatform = new JComboBox();
        this.jComboBoxDevice = new JComboBox();
        this.jComboProfile = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.containerPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.jComboPlatform);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(PanelConfigurePlatformVisual.class, (String)"LBL_WizardsPlatform_Platform"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelConfigurePlatformVisual.class, (String)"ACSN_WizardsPlatform_Platform"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelConfigurePlatformVisual.class, (String)"ACSD_WizardsPlatform_Platform"));
        this.jLabel2.setLabelFor(this.jComboBoxDevice);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(PanelConfigurePlatformVisual.class, (String)"LBL_WizardsPlatform_Device"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelConfigurePlatformVisual.class, (String)"ACSN_WizardsPlatform_Device"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelConfigurePlatformVisual.class, (String)"ACSD_WizardsPlatform_Device"));
        this.jLabel3.setLabelFor(this.jComboProfile);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(PanelConfigurePlatformVisual.class, (String)"LBL_WizardsPlatform_Profile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelConfigurePlatformVisual.class, (String)"ACSN_WizardsPlatform_Profile"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelConfigurePlatformVisual.class, (String)"ACSD_WizardsPlatform_Profile"));
        this.jComboPlatform.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.add((Component)this.jComboPlatform, gridBagConstraints);
        this.jComboBoxDevice.setModel(new DefaultComboBoxModel<String>(new String[]{"Default"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.add((Component)this.jComboBoxDevice, gridBagConstraints);
        this.jComboProfile.setModel(new DefaultComboBoxModel<String>(new String[]{"Default"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.add((Component)this.jComboProfile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.containerPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.containerPanel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelConfigurePlatformVisual.class, (String)"ACSN_WizardsPlatform"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelConfigurePlatformVisual.class, (String)"ACSD_WizardsPlatform"));
    }

    void read(WizardDescriptor wizardDescriptor) {
        this.model = new PlatformComboBoxModel(this.platformType);
        this.jComboPlatform.setModel(this.model);
        this.selectPlatformPanel();
        this.selectDevice();
        this.selectProfile();
        this.jComboPlatform.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PanelConfigurePlatformVisual.this.selectPlatformPanel();
                PanelConfigurePlatformVisual.this.selectDevice();
                PanelConfigurePlatformVisual.this.selectProfile();
                PanelConfigurePlatformVisual.this.panel.fireChangeEvent();
            }
        });
        this.jComboBoxDevice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PanelConfigurePlatformVisual.this.selectProfile();
                PanelConfigurePlatformVisual.this.panel.fireChangeEvent();
            }
        });
        this.panel.fireChangeEvent();
        String string = (String)wizardDescriptor.getProperty("activePlatform");
        if (string != null) {
            for (int i = 0; i < this.jComboPlatform.getItemCount(); ++i) {
                if (!((PlatformKey)this.jComboPlatform.getItemAt(i)).getDisplayName().equals(string)) continue;
                this.jComboPlatform.setSelectedIndex(i);
            }
        }
        if ((string = (String)wizardDescriptor.getProperty("activeDevice")) != null) {
            this.jComboBoxDevice.setSelectedItem(string);
        }
        if ((string = (String)wizardDescriptor.getProperty("activeProfile")) != null) {
            this.jComboProfile.setSelectedItem(string);
        }
    }

    void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("activePlatform", (Object)((PlatformKey)this.jComboPlatform.getSelectedItem()).getDisplayName());
        wizardDescriptor.putProperty("activeDevice", this.jComboBoxDevice.getSelectedItem());
        wizardDescriptor.putProperty("activeProfile", this.jComboProfile.getSelectedItem());
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)" ");
        return true;
    }

    private static class PlatformComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private JavaPlatformManager pm = JavaPlatformManager.getDefault();
        private PlatformKey[] platformNamesCache;
        private PlatformKey selectedPlatform;
        private String platformType;

        public PlatformComboBoxModel(String string) {
            this.platformType = string;
        }

        public int getSize() {
            PlatformKey[] platformKeyArray = this.getPlatformNames();
            return platformKeyArray.length;
        }

        public Object getElementAt(int n) {
            PlatformKey[] platformKeyArray = this.getPlatformNames();
            assert (n >= 0 && n < platformKeyArray.length);
            return platformKeyArray[n];
        }

        public Object getSelectedItem() {
            this.getPlatformNames();
            return this.selectedPlatform;
        }

        public void setSelectedItem(Object object) {
            this.selectedPlatform = (PlatformKey)object;
            this.fireContentsChanged(this, -1, -1);
        }

        private synchronized PlatformKey[] getPlatformNames() {
            JavaPlatform[] javaPlatformArray;
            HashSet<String> hashSet = null;
            if (this.platformType != null) {
                hashSet = new HashSet<String>();
                javaPlatformArray = new StringTokenizer(this.platformType, ",");
                while (javaPlatformArray.hasMoreTokens()) {
                    hashSet.add(javaPlatformArray.nextToken());
                }
            }
            if (this.platformNamesCache == null) {
                javaPlatformArray = this.pm.getPlatforms(null, new Specification("cdc", null));
                TreeSet<PlatformKey> treeSet = new TreeSet<PlatformKey>();
                for (JavaPlatform javaPlatform : javaPlatformArray) {
                    if (javaPlatform.getInstallFolders().size() <= 0 || hashSet != null && !hashSet.contains(((CDCPlatform)javaPlatform).getType())) continue;
                    PlatformKey platformKey = new PlatformKey(javaPlatform);
                    treeSet.add(platformKey);
                }
                if (!treeSet.isEmpty() && this.selectedPlatform == null) {
                    this.selectedPlatform = (PlatformKey)treeSet.iterator().next();
                }
                this.platformNamesCache = treeSet.toArray(new PlatformKey[treeSet.size()]);
            }
            return this.platformNamesCache;
        }
    }

    private static class PlatformKey
    implements Comparable {
        private String name;
        private JavaPlatform platform;

        public PlatformKey(JavaPlatform javaPlatform) {
            this.platform = javaPlatform;
        }

        public int compareTo(Object object) {
            return this.getDisplayName().compareTo(((PlatformKey)object).getDisplayName());
        }

        public boolean equals(Object object) {
            if (object instanceof PlatformKey) {
                PlatformKey platformKey = (PlatformKey)object;
                return (this.platform == null ? platformKey.platform == null : this.platform.equals(platformKey.platform)) && platformKey.getDisplayName().equals(this.getDisplayName());
            }
            return false;
        }

        public int hashCode() {
            return this.getDisplayName().hashCode();
        }

        public String toString() {
            return this.getDisplayName();
        }

        public synchronized String getDisplayName() {
            if (this.name == null) {
                this.name = this.platform.getDisplayName();
            }
            return this.name;
        }

        public synchronized CDCPlatform getPlatform() {
            return (CDCPlatform)this.platform;
        }
    }
}

