/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.JXLabel;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.decorator.Filter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.DataViewActionHandler;
import org.netbeans.modules.db.dataview.output.DataViewPageContext;
import org.netbeans.modules.db.dataview.output.DataViewTablePanel;
import org.netbeans.modules.db.dataview.output.DataViewTableUI;
import org.netbeans.modules.db.dataview.output.UpdatedRowContext;
import org.netbeans.modules.db.dataview.table.MultiColPatternFilter;
import org.netbeans.modules.db.dataview.table.SuperPatternFilter;
import org.openide.awt.MouseUtils;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataViewUI
extends JXPanel {
    private JXButton commit;
    private JXButton refreshButton;
    private JXButton truncateButton;
    private JXButton next;
    private JXButton last;
    private JXButton previous;
    private JXButton first;
    private JXButton deleteRow;
    private JXButton insert;
    private JTextField refreshField;
    private JTextField matchBoxField;
    private JXLabel totalRowsLabel;
    private JXLabel limitRow;
    private JXButton[] editButtons = new JXButton[5];
    private DataViewTablePanel dataPanel;
    private final DataView dataView;
    private JXButton cancel;
    private DataViewActionHandler actionHandler;
    private String imgPrefix = "/org/netbeans/modules/db/dataview/images/";
    private static final int MAX_TAB_LENGTH = 25;
    private static final MouseListener sharedMouseListener = new MouseUtils.PopupMouseAdapter(){

        public void mouseEntered(MouseEvent mouseEvent) {
            AbstractButton abstractButton;
            Object object = mouseEvent.getSource();
            if (object instanceof AbstractButton && (abstractButton = (AbstractButton)mouseEvent.getSource()).isEnabled()) {
                abstractButton.setContentAreaFilled(true);
                abstractButton.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
                abstractButton.setContentAreaFilled(false);
                abstractButton.setBorderPainted(false);
            }
        }

        protected void showPopup(MouseEvent mouseEvent) {
        }
    };
    private static final Insets BUTTON_INSETS = new Insets(2, 1, 0, 1);

    DataViewUI(DataView dataView, boolean bl) {
        Object object;
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called from AWT thread";
        this.dataView = dataView;
        this.putClientProperty("TabPolicy", "HideWhenAlone");
        this.putClientProperty("PersistenceType", "Never");
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        String string = dataView.getSQLString();
        if (string.length() > 25) {
            object = NbBundle.getMessage(DataViewUI.class, (String)"DataViewUI_TrimmedTabName", (Object)string.substring(0, Math.min(string.length(), 25)));
            this.setName((String)object);
        } else {
            this.setName(string);
        }
        this.setToolTipText(string);
        object = this.initializeMainPanel(bl);
        this.add((Component)object, "North");
        this.actionHandler = new DataViewActionHandler(this, dataView);
        this.dataPanel = new DataViewTablePanel(dataView, this, this.actionHandler);
        this.add((Component)((Object)this.dataPanel), "Center");
        this.dataPanel.revalidate();
        this.dataPanel.repaint();
    }

    JButton[] getEditButtons() {
        return this.editButtons;
    }

    void setEditable(boolean bl) {
        this.dataPanel.setEditable(bl);
    }

    boolean isEditable() {
        return this.dataPanel.isEditable();
    }

    void setTotalCount(int n) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called from AWT thread";
        if (n < 0) {
            int n2 = this.dataView.getDataViewPageContext().getPageSize();
            int n3 = this.dataView.getDataViewPageContext().getCurrentRows().size();
            String string = NbBundle.getMessage(DataViewUI.class, (String)"LBL_not_available");
            this.totalRowsLabel.setText(n3 < n2 ? n3 + "" : string);
        } else {
            this.totalRowsLabel.setText(n + "   " + this.dataView.getDataViewPageContext().pageOf());
        }
    }

    boolean isCommitEnabled() {
        return this.commit.isEnabled();
    }

    DataViewTableUI getDataViewTableUI() {
        return this.dataPanel.getDataViewTableUI();
    }

    UpdatedRowContext getUpdatedRowContext() {
        return this.dataPanel.getUpdatedRowContext();
    }

    void setCommitEnabled(boolean bl) {
        this.commit.setEnabled(bl);
    }

    void setCancelEnabled(boolean bl) {
        this.cancel.setEnabled(bl);
    }

    void setDataRows(List<Object[]> list) {
        this.dataPanel.createTableModel(list);
    }

    void resetValueAt(int n, int n2) {
        Object object = this.dataView.getDataViewPageContext().getColumnData(n, n2);
        this.dataPanel.setValueAt(object, n, n2);
    }

    void syncPageWithTableModel() {
        List<Object[]> list = this.dataPanel.getPageDataFromTable();
        List<Object[]> list2 = this.dataView.getDataViewPageContext().getCurrentRows();
        for (Integer n : this.dataView.getUpdatedRowContext().getUpdateKeys()) {
            list.set(n, list2.get(n));
        }
        this.dataView.getDataViewPageContext().setCurrentRows(list);
    }

    void disableButtons() {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called from AWT thread";
        this.truncateButton.setEnabled(false);
        this.refreshButton.setEnabled(false);
        this.refreshField.setEnabled(false);
        this.matchBoxField.setEditable(false);
        this.first.setEnabled(false);
        this.previous.setEnabled(false);
        this.next.setEnabled(false);
        this.last.setEnabled(false);
        this.deleteRow.setEnabled(false);
        this.commit.setEnabled(false);
        this.cancel.setEnabled(false);
        this.insert.setEnabled(false);
        this.dataPanel.revalidate();
        this.dataPanel.repaint();
    }

    int getPageSize() {
        int n = this.dataView.getDataViewPageContext().getPageSize();
        int n2 = this.dataView.getDataViewPageContext().getTotalRows();
        try {
            int n3 = Integer.parseInt(this.refreshField.getText().trim());
            return n3 < 0 ? n : n3;
        }
        catch (NumberFormatException numberFormatException) {
            return n2 < n ? n2 : n;
        }
    }

    boolean isDirty() {
        return this.dataPanel.isDirty();
    }

    void resetToolbar(boolean bl) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called from AWT thread";
        this.refreshButton.setEnabled(true);
        this.refreshField.setEnabled(true);
        this.matchBoxField.setEditable(true);
        this.deleteRow.setEnabled(false);
        DataViewPageContext dataViewPageContext = this.dataView.getDataViewPageContext();
        if (!bl) {
            if (dataViewPageContext.hasPrevious()) {
                this.first.setEnabled(true);
                this.previous.setEnabled(true);
            }
            if (dataViewPageContext.hasNext()) {
                this.next.setEnabled(true);
                this.last.setEnabled(true);
            }
            if (dataViewPageContext.hasOnePageOnly()) {
                this.first.setEnabled(false);
                this.previous.setEnabled(false);
            }
            if (dataViewPageContext.isLastPage()) {
                this.next.setEnabled(false);
                this.last.setEnabled(false);
            }
            if (!this.isEditable()) {
                this.commit.setEnabled(false);
                this.cancel.setEnabled(false);
                this.deleteRow.setEnabled(false);
                this.insert.setEnabled(false);
                this.truncateButton.setEnabled(false);
            } else {
                if (dataViewPageContext.hasRows()) {
                    this.truncateButton.setEnabled(true);
                } else {
                    this.deleteRow.setEnabled(false);
                    this.truncateButton.setEnabled(false);
                    dataViewPageContext.first();
                }
                this.insert.setEnabled(true);
                if (this.getUpdatedRowContext().getUpdateKeys().isEmpty()) {
                    this.commit.setEnabled(false);
                    this.cancel.setEnabled(false);
                } else {
                    this.commit.setEnabled(true);
                    this.cancel.setEnabled(true);
                }
            }
        } else {
            this.disableButtons();
        }
        this.refreshField.setText("" + dataViewPageContext.getPageSize());
        if (this.dataPanel != null) {
            this.dataPanel.revalidate();
            this.dataPanel.repaint();
        }
    }

    private ActionListener createOutputListener() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object.equals(DataViewUI.this.refreshButton)) {
                    DataViewUI.this.actionHandler.refreshActionPerformed();
                } else if (object.equals(DataViewUI.this.first)) {
                    DataViewUI.this.actionHandler.firstActionPerformed();
                } else if (object.equals(DataViewUI.this.last)) {
                    DataViewUI.this.actionHandler.lastActionPerformed();
                } else if (object.equals(DataViewUI.this.next)) {
                    DataViewUI.this.actionHandler.nextActionPerformed();
                } else if (object.equals(DataViewUI.this.previous)) {
                    DataViewUI.this.actionHandler.previousActionPerformed();
                } else if (object.equals(DataViewUI.this.refreshField)) {
                    DataViewUI.this.actionHandler.setMaxActionPerformed();
                } else if (object.equals(DataViewUI.this.commit)) {
                    DataViewUI.this.actionHandler.commitActionPerformed(false);
                } else if (object.equals(DataViewUI.this.cancel)) {
                    DataViewUI.this.actionHandler.cancelEditPerformed(false);
                } else if (object.equals(DataViewUI.this.deleteRow)) {
                    DataViewUI.this.actionHandler.deleteRecordActionPerformed();
                } else if (object.equals(DataViewUI.this.insert)) {
                    DataViewUI.this.actionHandler.insertActionPerformed();
                } else if (object.equals(DataViewUI.this.truncateButton)) {
                    DataViewUI.this.actionHandler.truncateActionPerformed();
                }
            }
        };
        return actionListener;
    }

    private void processButton(AbstractButton abstractButton) {
        abstractButton.setContentAreaFilled(false);
        abstractButton.setBorderPainted(false);
        abstractButton.setMargin(BUTTON_INSETS);
        if (abstractButton instanceof AbstractButton) {
            abstractButton.addMouseListener(sharedMouseListener);
        }
        abstractButton.setFocusable(false);
    }

    private void initToolbar(JToolBar jToolBar, ActionListener actionListener) {
        jToolBar.addSeparator(new Dimension(10, 10));
        URL uRL = ((Object)((Object)this)).getClass().getResource(this.imgPrefix + "refresh.png");
        this.refreshButton = new JXButton((Icon)new ImageIcon(uRL));
        this.refreshButton.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_refresh"));
        this.refreshButton.addActionListener(actionListener);
        this.processButton((AbstractButton)this.refreshButton);
        jToolBar.add((Component)this.refreshButton);
        uRL = ((Object)((Object)this)).getClass().getResource(this.imgPrefix + "navigate_beginning.png");
        this.first = new JXButton((Icon)new ImageIcon(uRL));
        this.first.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_first"));
        this.first.addActionListener(actionListener);
        this.first.setEnabled(false);
        this.processButton((AbstractButton)this.first);
        jToolBar.add((Component)this.first);
        uRL = ((Object)((Object)this)).getClass().getResource(this.imgPrefix + "navigate_left.png");
        this.previous = new JXButton((Icon)new ImageIcon(uRL));
        this.previous.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_previous"));
        this.previous.addActionListener(actionListener);
        this.previous.setEnabled(false);
        this.processButton((AbstractButton)this.previous);
        jToolBar.add((Component)this.previous);
        uRL = ((Object)((Object)this)).getClass().getResource(this.imgPrefix + "navigate_right.png");
        this.next = new JXButton((Icon)new ImageIcon(uRL));
        this.next.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_next"));
        this.next.addActionListener(actionListener);
        this.next.setEnabled(false);
        this.processButton((AbstractButton)this.next);
        jToolBar.add((Component)this.next);
        uRL = ((Object)((Object)this)).getClass().getResource(this.imgPrefix + "navigate_end.png");
        this.last = new JXButton((Icon)new ImageIcon(uRL));
        this.last.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_last"));
        this.last.addActionListener(actionListener);
        this.last.setEnabled(false);
        jToolBar.add((Component)this.last);
        this.processButton((AbstractButton)this.last);
        jToolBar.addSeparator(new Dimension(10, 10));
        this.limitRow = new JXLabel(NbBundle.getMessage(DataViewUI.class, (String)"LBL_max_rows"));
        this.limitRow.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 8));
        jToolBar.add((Component)this.limitRow);
        this.refreshField = new JTextField(2);
        this.refreshField.setMinimumSize(new Dimension(30, 25));
        this.refreshField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                DataViewUI.this.refreshField.selectAll();
            }

            public void focusLost(FocusEvent focusEvent) {
                if (DataViewUI.this.refreshField.getText().length() > 2) {
                    DataViewUI.this.refreshField.setMinimumSize(new Dimension(10 * DataViewUI.this.refreshField.getText().length(), 25));
                    DataViewUI.this.refreshField.setColumns(DataViewUI.this.refreshField.getText().length());
                } else {
                    DataViewUI.this.refreshField.setMinimumSize(new Dimension(30, 25));
                    DataViewUI.this.refreshField.setColumns(2);
                }
            }
        });
        this.refreshField.addActionListener(actionListener);
        jToolBar.add(this.refreshField);
        jToolBar.addSeparator(new Dimension(10, 10));
        JXLabel jXLabel = new JXLabel(NbBundle.getMessage(DataViewUI.class, (String)"LBL_total_rows"));
        jXLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DataViewUI.class, (String)"LBL_total_rows"));
        jXLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        jToolBar.add((Component)jXLabel);
        this.totalRowsLabel = new JXLabel();
        jToolBar.add((Component)this.totalRowsLabel);
        jToolBar.addSeparator(new Dimension(10, 10));
        Box.Filler filler = new Box.Filler(new Dimension(this.getWidth(), this.getHeight()), new Dimension(800, this.getHeight()), new Dimension(this.getWidth(), this.getHeight()));
        jToolBar.add(filler);
        JXLabel jXLabel2 = new JXLabel(NbBundle.getMessage(DataViewUI.class, (String)"LBL_matchbox"));
        jXLabel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 8));
        jToolBar.add((Component)jXLabel2);
        this.matchBoxField = new JTextField(10);
        this.matchBoxField.setText("");
        this.matchBoxField.setMinimumSize(new Dimension(35, this.matchBoxField.getHeight()));
        this.matchBoxField.setSize(35, this.matchBoxField.getHeight());
        this.matchBoxField.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
                DataViewUI.this.processKeyEvents();
            }

            public void keyPressed(KeyEvent keyEvent) {
                DataViewUI.this.processKeyEvents();
            }

            public void keyReleased(KeyEvent keyEvent) {
                DataViewUI.this.processKeyEvents();
            }
        });
        jToolBar.add(this.matchBoxField);
    }

    private void processKeyEvents() {
        DataViewTableUI dataViewTableUI = this.getDataViewTableUI();
        int[] nArray = new int[dataViewTableUI.getColumnCount()];
        for (int i = 0; i < dataViewTableUI.getColumnCount(); ++i) {
            nArray[i] = i;
        }
        MultiColPatternFilter multiColPatternFilter = new MultiColPatternFilter(nArray);
        multiColPatternFilter.setFilterStr(this.matchBoxField.getText(), SuperPatternFilter.MODE.REGEX_FIND);
        dataViewTableUI.setFilters(new FilterPipeline(new Filter[]{multiColPatternFilter}));
    }

    private void initVerticalToolbar(ActionListener actionListener) {
        URL uRL = ((Object)((Object)this)).getClass().getResource(this.imgPrefix + "row_add.png");
        this.insert = new JXButton((Icon)new ImageIcon(uRL));
        this.insert.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_insert") + " (Alt+I)");
        this.insert.setMnemonic('I');
        this.insert.addActionListener(actionListener);
        this.insert.setEnabled(false);
        this.processButton((AbstractButton)this.insert);
        this.editButtons[0] = this.insert;
        uRL = ((Object)((Object)this)).getClass().getResource(this.imgPrefix + "row_delete.png");
        this.deleteRow = new JXButton((Icon)new ImageIcon(uRL));
        this.deleteRow.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_deleterow"));
        this.deleteRow.addActionListener(actionListener);
        this.deleteRow.setEnabled(false);
        this.processButton((AbstractButton)this.deleteRow);
        this.editButtons[1] = this.deleteRow;
        uRL = ((Object)((Object)this)).getClass().getResource(this.imgPrefix + "row_commit.png");
        this.commit = new JXButton((Icon)new ImageIcon(uRL));
        this.commit.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_commit_all"));
        this.commit.addActionListener(actionListener);
        this.commit.setEnabled(false);
        this.processButton((AbstractButton)this.commit);
        this.editButtons[2] = this.commit;
        uRL = ((Object)((Object)this)).getClass().getResource(this.imgPrefix + "cancel_edits.png");
        this.cancel = new JXButton((Icon)new ImageIcon(uRL));
        this.cancel.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_cancel_edits"));
        this.cancel.addActionListener(actionListener);
        this.cancel.setEnabled(false);
        this.processButton((AbstractButton)this.cancel);
        this.editButtons[3] = this.cancel;
        uRL = ((Object)((Object)this)).getClass().getResource(this.imgPrefix + "table_truncate.png");
        this.truncateButton = new JXButton((Icon)new ImageIcon(uRL));
        this.truncateButton.setToolTipText(NbBundle.getMessage(DataViewUI.class, (String)"TOOLTIP_truncate_table") + " (Alt+T)");
        this.truncateButton.setMnemonic('T');
        this.truncateButton.addActionListener(actionListener);
        this.truncateButton.setEnabled(false);
        this.processButton((AbstractButton)this.truncateButton);
        this.editButtons[4] = this.truncateButton;
    }

    private JPanel initializeMainPanel(boolean bl) {
        GroupLayout groupLayout;
        JXPanel jXPanel = new JXPanel();
        jXPanel.setBorder(BorderFactory.createEtchedBorder());
        ActionListener actionListener = this.createOutputListener();
        this.initVerticalToolbar(actionListener);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setRollover(true);
        if (!bl) {
            for (GroupLayout groupLayout2 : groupLayout = this.getEditButtons()) {
                if (groupLayout2 == null) continue;
                jToolBar.add((Component)groupLayout2);
            }
        }
        this.initToolbar(jToolBar, actionListener);
        groupLayout = new GroupLayout((Container)jXPanel);
        jXPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)jToolBar, -1, 205, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)jToolBar, -2, 25, -2)));
        return jXPanel;
    }

    public void enableDeleteBtn(boolean bl) {
        this.deleteRow.setEnabled(bl);
    }
}

