/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.awt.Component;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.output.DataViewDBTable;
import org.netbeans.modules.db.dataview.output.DataViewPageContext;
import org.netbeans.modules.db.dataview.output.DataViewUI;
import org.netbeans.modules.db.dataview.output.SQLExecutionHelper;
import org.netbeans.modules.db.dataview.output.SQLStatementGenerator;
import org.netbeans.modules.db.dataview.output.UpdatedRowContext;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataView {
    private DatabaseConnection dbConn;
    private List<Throwable> errMessages = new ArrayList<Throwable>();
    private String sqlString;
    private DataViewDBTable tblMeta;
    private SQLStatementGenerator stmtGenerator;
    private SQLExecutionHelper execHelper;
    private DataViewPageContext dataPage;
    private DataViewUI dataViewUI;
    private boolean nbOutputComponent = false;
    private boolean hasResultSet = false;
    private int updateCount;
    private long executionTime;
    private boolean supportsLimit = false;

    public static DataView create(DatabaseConnection databaseConnection, String string, int n) {
        assert (databaseConnection != null);
        DataView dataView = new DataView();
        dataView.dbConn = databaseConnection;
        dataView.sqlString = string.trim();
        dataView.nbOutputComponent = false;
        try {
            dataView.dataPage = new DataViewPageContext(n);
            dataView.execHelper = new SQLExecutionHelper(dataView);
            SQLExecutionHelper.initialDataLoad(dataView, databaseConnection, dataView.execHelper);
            dataView.stmtGenerator = new SQLStatementGenerator(dataView);
        }
        catch (Exception exception) {
            dataView.setErrorStatusText(exception);
        }
        return dataView;
    }

    public static DataView create(DatabaseConnection databaseConnection, String string, int n, boolean bl) {
        DataView dataView = DataView.create(databaseConnection, string, n);
        dataView.nbOutputComponent = bl;
        return dataView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Component> createComponents() {
        if (!this.hasResultSet) {
            return Collections.emptyList();
        }
        DataView dataView = this;
        synchronized (dataView) {
            this.dataViewUI = new DataViewUI(this, this.nbOutputComponent);
            this.setRowsInTableModel();
            this.dataViewUI.setEditable(this.tblMeta == null ? false : this.tblMeta.hasOneTable());
            this.resetToolbar(this.hasExceptions());
        }
        ArrayList<Component> arrayList = new ArrayList<Component>();
        arrayList.add((Component)((Object)this.dataViewUI));
        return arrayList;
    }

    public boolean hasExceptions() {
        return !this.errMessages.isEmpty();
    }

    public boolean hasResultSet() {
        return this.hasResultSet;
    }

    public Collection<Throwable> getExceptions() {
        return Collections.unmodifiableCollection(this.errMessages);
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public JButton[] getEditButtons() {
        assert (this.nbOutputComponent);
        return this.dataViewUI.getEditButtons();
    }

    public synchronized void setEditable(boolean bl) {
        this.dataViewUI.setEditable(bl);
    }

    public DataViewDBTable getDataViewDBTable() {
        return this.tblMeta;
    }

    DataViewPageContext getDataViewPageContext() {
        return this.dataPage;
    }

    DatabaseConnection getDatabaseConnection() {
        return this.dbConn;
    }

    String getSQLString() {
        return this.sqlString;
    }

    UpdatedRowContext getUpdatedRowContext() {
        return this.dataViewUI.getUpdatedRowContext();
    }

    SQLExecutionHelper getSQLExecutionHelper() {
        return this.execHelper;
    }

    SQLStatementGenerator getSQLStatementGenerator() {
        return this.stmtGenerator;
    }

    public boolean isEditable() {
        return this.dataViewUI.isEditable();
    }

    boolean isLimitSupported() {
        return this.supportsLimit;
    }

    synchronized void disableButtons() {
        assert (this.dataViewUI != null);
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                DataView.this.dataViewUI.disableButtons();
            }
        });
        this.errMessages.clear();
    }

    synchronized void removeComponents() {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                DataView.this.dataViewUI.getParent().setVisible(false);
                DataView.this.dataViewUI.removeAll();
                DataView.this.dataViewUI.repaint();
                DataView.this.dataViewUI.revalidate();
            }
        });
    }

    void setInfoStatusText(String string) {
        if (string != null) {
            StatusDisplayer.getDefault().setStatusText(string);
        }
    }

    synchronized void setErrorStatusText(Throwable throwable) {
        if (throwable != null) {
            if (throwable instanceof DBException && throwable.getCause() instanceof SQLException) {
                this.errMessages.add(throwable.getCause());
            }
            this.errMessages.add(throwable);
            String string = NbBundle.getMessage(DataView.class, (String)"MSG_error");
            StatusDisplayer.getDefault().setStatusText(string + ": " + throwable.getMessage());
        }
    }

    synchronized void setErrorStatusText(String string, Throwable throwable) {
        if (throwable != null) {
            this.errMessages.add(throwable);
        }
        String string2 = NbBundle.getMessage(DataView.class, (String)"MSG_error");
        StatusDisplayer.getDefault().setStatusText(string2 + ": " + string);
    }

    void resetToolbar(final boolean bl) {
        assert (this.dataViewUI != null);
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                DataView.this.dataViewUI.resetToolbar(bl);
            }
        });
    }

    void setLimitSupported(boolean bl) {
        this.supportsLimit = bl;
    }

    void setRowsInTableModel() {
        assert (this.dataViewUI != null);
        assert (this.dataPage != null);
        if (this.dataPage.getCurrentRows() != null) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    DataView.this.dataViewUI.setDataRows(DataView.this.dataPage.getCurrentRows());
                    DataView.this.dataViewUI.setTotalCount(DataView.this.dataPage.getTotalRows());
                }
            });
        }
    }

    synchronized void incrementRowSize(int n) {
        assert (this.dataViewUI != null);
        this.dataPage.setTotalRows(this.dataPage.getTotalRows() + n);
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                DataView.this.dataViewUI.setTotalCount(DataView.this.dataPage.getTotalRows());
            }
        });
    }

    synchronized void decrementRowSize(int n) {
        assert (this.dataViewUI != null);
        this.dataPage.decrementRowSize(n);
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                DataView.this.dataViewUI.setTotalCount(DataView.this.dataPage.getTotalRows());
            }
        });
    }

    synchronized void syncPageWithTableModel() {
        this.dataViewUI.syncPageWithTableModel();
    }

    void setHasResultSet(boolean bl) {
        this.hasResultSet = bl;
    }

    void setUpdateCount(int n) {
        this.updateCount = n;
    }

    void setExecutionTime(long l) {
        this.executionTime = l;
    }

    void setDataViewDBTable(DataViewDBTable dataViewDBTable) {
        this.tblMeta = dataViewDBTable;
    }

    private DataView() {
    }

    public int getPageSize() {
        if (this.dataViewUI == null) {
            return -1;
        }
        return this.dataViewUI.getPageSize();
    }
}

