/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.meta;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBObject;
import org.netbeans.modules.db.dataview.meta.DBTable;
import org.netbeans.modules.db.dataview.util.DataViewUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DBPrimaryKey
extends DBObject<DBTable> {
    private static final String RS_COLUMN_NAME = "COLUMN_NAME";
    private static final String RS_KEY_NAME = "PK_NAME";
    private List<String> columnNames;
    private String name;
    private DBTable parent;

    public DBPrimaryKey(ResultSet resultSet) throws SQLException {
        assert (resultSet != null);
        this.columnNames = new ArrayList<String>();
        while (resultSet.next()) {
            this.name = resultSet.getString(RS_COLUMN_NAME);
            this.columnNames.add(resultSet.getString(RS_COLUMN_NAME));
            String string = resultSet.getString(RS_KEY_NAME);
            if (DataViewUtils.isNullString(string) || this.name != null) continue;
            this.name = string;
        }
    }

    public boolean contains(DBColumn dBColumn) {
        return this.contains(dBColumn.getName());
    }

    public boolean contains(String string) {
        return this.columnNames.contains(string);
    }

    public boolean equals(Object object) {
        boolean bl;
        if (this == object) {
            return true;
        }
        if (!(object instanceof DBPrimaryKey)) {
            return false;
        }
        DBPrimaryKey dBPrimaryKey = (DBPrimaryKey)object;
        boolean bl2 = this.getName() != null ? this.name.equals(dBPrimaryKey.name) : (bl = dBPrimaryKey.name == null);
        return bl &= this.columnNames != null ? ((Object)this.columnNames).equals(dBPrimaryKey.columnNames) : dBPrimaryKey.columnNames != null;
    }

    public int getColumnCount() {
        return this.columnNames.size();
    }

    public List<String> getColumnNames() {
        return Collections.unmodifiableList(this.columnNames);
    }

    public String getName() {
        if (this.name == null && this.parent != null) {
            this.name = "PK_" + this.parent.getName();
        }
        return this.name;
    }

    public int hashCode() {
        int n = this.getName() != null ? this.name.hashCode() : 0;
        return n += this.columnNames != null ? ((Object)this.columnNames).hashCode() : 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        for (int i = 0; i < this.columnNames.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.columnNames.get(i).trim());
        }
        return stringBuilder.toString();
    }
}

