/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.util.Hashtable;
import javax.swing.BoundedRangeModel;
import javax.swing.JProgressBar;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ProgressBarUI;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.Operator;

public class JProgressBarOperator
extends JComponentOperator
implements Timeoutable,
Outputable {
    public static final String MINIMUM_DPROP = "Minimum";
    public static final String MAXIMUM_DPROP = "Maximum";
    public static final String VALUE_DPROP = "Value";
    private static long WAIT_VALUE_TIMEOUT = 60000L;
    private Timeouts timeouts;
    private TestOut output;

    public JProgressBarOperator(JProgressBar b) {
        super(b);
    }

    public JProgressBarOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((JProgressBar)cont.waitSubComponent(new JProgressBarFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public JProgressBarOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public JProgressBarOperator(ContainerOperator cont, int index) {
        this((JProgressBar)JProgressBarOperator.waitComponent(cont, (ComponentChooser)new JProgressBarFinder(), index));
        this.copyEnvironment(cont);
    }

    public JProgressBarOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static JProgressBar findJProgressBar(Container cont, ComponentChooser chooser, int index) {
        return (JProgressBar)JProgressBarOperator.findComponent(cont, new JProgressBarFinder(chooser), index);
    }

    public static JProgressBar findJProgressBar(Container cont, ComponentChooser chooser) {
        return JProgressBarOperator.findJProgressBar(cont, chooser, 0);
    }

    public static JProgressBar findJProgressBar(Container cont, int index) {
        return JProgressBarOperator.findJProgressBar(cont, ComponentSearcher.getTrueChooser(Integer.toString(index) + "'th JProgressBar instance"), index);
    }

    public static JProgressBar findJProgressBar(Container cont) {
        return JProgressBarOperator.findJProgressBar(cont, 0);
    }

    public static JProgressBar waitJProgressBar(Container cont, ComponentChooser chooser, int index) {
        return (JProgressBar)JProgressBarOperator.waitComponent(cont, (ComponentChooser)new JProgressBarFinder(chooser), index);
    }

    public static JProgressBar waitJProgressBar(Container cont, ComponentChooser chooser) {
        return JProgressBarOperator.waitJProgressBar(cont, chooser, 0);
    }

    public static JProgressBar waitJProgressBar(Container cont, int index) {
        return JProgressBarOperator.waitJProgressBar(cont, ComponentSearcher.getTrueChooser(Integer.toString(index) + "'th JProgressBar instance"), index);
    }

    public static JProgressBar waitJProgressBar(Container cont) {
        return JProgressBarOperator.waitJProgressBar(cont, 0);
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        super.setTimeouts(timeouts);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut out) {
        this.output = out;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void waitValue(final ValueChooser chooser) {
        this.output.printLine("Wait \"" + chooser.getDescription() + "\" value in progressbar\n    : " + this.toStringSource());
        this.output.printGolden("Wait \"" + chooser.getDescription() + "\" value in progressbar");
        Waiter wt = new Waiter(new Waitable(){

            public Object actionProduced(Object obj) {
                return chooser.checkValue(((JProgressBar)JProgressBarOperator.this.getSource()).getValue()) ? "" : null;
            }

            public String getDescription() {
                return "\"" + chooser.getDescription() + "\" value";
            }
        });
        wt.setTimeouts(this.timeouts.cloneThis());
        wt.getTimeouts().setTimeout("Waiter.WaitingTime", this.getTimeouts().getTimeout("JProgressBarOperator.WaitValueTimeout"));
        wt.setOutput(this.output.createErrorOutput());
        try {
            wt.waitAction(null);
        }
        catch (InterruptedException e) {
            throw new JemmyException("Exception during progressbar value waiting", e);
        }
    }

    public void waitValue(final int value) {
        this.output.printLine("Wait \"" + value + "\" value in progressbar\n    : " + this.toStringSource());
        this.output.printGolden("Wait \"" + value + "\" value in progressbar");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return ((JProgressBar)comp).getValue() >= value;
            }

            public String getDescription() {
                return "greater then " + Integer.toString(value);
            }
        });
    }

    public void waitValue(final String value) {
        this.output.printLine("Wait \"" + value + "\" string in progressbar\n    : " + this.toStringSource());
        this.output.printGolden("Wait \"" + value + "\" string in progressbar");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return JProgressBarOperator.this.getComparator().equals(((JProgressBar)comp).getString(), value);
            }

            public String getDescription() {
                return "'" + value + "' string";
            }
        });
    }

    public Hashtable getDump() {
        Hashtable result = super.getDump();
        result.put(MINIMUM_DPROP, Integer.toString(((JProgressBar)this.getSource()).getMinimum()));
        result.put(MAXIMUM_DPROP, Integer.toString(((JProgressBar)this.getSource()).getMaximum()));
        result.put(VALUE_DPROP, Integer.toString(((JProgressBar)this.getSource()).getValue()));
        return result;
    }

    public void addChangeListener(final ChangeListener changeListener) {
        this.runMapping(new Operator.MapVoidAction("addChangeListener"){

            public void map() {
                ((JProgressBar)JProgressBarOperator.this.getSource()).addChangeListener(changeListener);
            }
        });
    }

    public int getMaximum() {
        return this.runMapping(new Operator.MapIntegerAction("getMaximum"){

            public int map() {
                return ((JProgressBar)JProgressBarOperator.this.getSource()).getMaximum();
            }
        });
    }

    public int getMinimum() {
        return this.runMapping(new Operator.MapIntegerAction("getMinimum"){

            public int map() {
                return ((JProgressBar)JProgressBarOperator.this.getSource()).getMinimum();
            }
        });
    }

    public BoundedRangeModel getModel() {
        return (BoundedRangeModel)this.runMapping(new Operator.MapAction("getModel"){

            public Object map() {
                return ((JProgressBar)JProgressBarOperator.this.getSource()).getModel();
            }
        });
    }

    public int getOrientation() {
        return this.runMapping(new Operator.MapIntegerAction("getOrientation"){

            public int map() {
                return ((JProgressBar)JProgressBarOperator.this.getSource()).getOrientation();
            }
        });
    }

    public double getPercentComplete() {
        return this.runMapping(new Operator.MapDoubleAction("getPercentComplete"){

            public double map() {
                return ((JProgressBar)JProgressBarOperator.this.getSource()).getPercentComplete();
            }
        });
    }

    public String getString() {
        return (String)this.runMapping(new Operator.MapAction("getString"){

            public Object map() {
                return ((JProgressBar)JProgressBarOperator.this.getSource()).getString();
            }
        });
    }

    public ProgressBarUI getUI() {
        return (ProgressBarUI)this.runMapping(new Operator.MapAction("getUI"){

            public Object map() {
                return ((JProgressBar)JProgressBarOperator.this.getSource()).getUI();
            }
        });
    }

    public int getValue() {
        return this.runMapping(new Operator.MapIntegerAction("getValue"){

            public int map() {
                return ((JProgressBar)JProgressBarOperator.this.getSource()).getValue();
            }
        });
    }

    public boolean isBorderPainted() {
        return this.runMapping(new Operator.MapBooleanAction("isBorderPainted"){

            public boolean map() {
                return ((JProgressBar)JProgressBarOperator.this.getSource()).isBorderPainted();
            }
        });
    }

    public boolean isStringPainted() {
        return this.runMapping(new Operator.MapBooleanAction("isStringPainted"){

            public boolean map() {
                return ((JProgressBar)JProgressBarOperator.this.getSource()).isStringPainted();
            }
        });
    }

    public void removeChangeListener(final ChangeListener changeListener) {
        this.runMapping(new Operator.MapVoidAction("removeChangeListener"){

            public void map() {
                ((JProgressBar)JProgressBarOperator.this.getSource()).removeChangeListener(changeListener);
            }
        });
    }

    public void setBorderPainted(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setBorderPainted"){

            public void map() {
                ((JProgressBar)JProgressBarOperator.this.getSource()).setBorderPainted(b);
            }
        });
    }

    public void setMaximum(final int i) {
        this.runMapping(new Operator.MapVoidAction("setMaximum"){

            public void map() {
                ((JProgressBar)JProgressBarOperator.this.getSource()).setMaximum(i);
            }
        });
    }

    public void setMinimum(final int i) {
        this.runMapping(new Operator.MapVoidAction("setMinimum"){

            public void map() {
                ((JProgressBar)JProgressBarOperator.this.getSource()).setMinimum(i);
            }
        });
    }

    public void setModel(final BoundedRangeModel boundedRangeModel) {
        this.runMapping(new Operator.MapVoidAction("setModel"){

            public void map() {
                ((JProgressBar)JProgressBarOperator.this.getSource()).setModel(boundedRangeModel);
            }
        });
    }

    public void setOrientation(final int i) {
        this.runMapping(new Operator.MapVoidAction("setOrientation"){

            public void map() {
                ((JProgressBar)JProgressBarOperator.this.getSource()).setOrientation(i);
            }
        });
    }

    public void setString(final String string) {
        this.runMapping(new Operator.MapVoidAction("setString"){

            public void map() {
                ((JProgressBar)JProgressBarOperator.this.getSource()).setString(string);
            }
        });
    }

    public void setStringPainted(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setStringPainted"){

            public void map() {
                ((JProgressBar)JProgressBarOperator.this.getSource()).setStringPainted(b);
            }
        });
    }

    public void setUI(final ProgressBarUI progressBarUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            public void map() {
                ((JProgressBar)JProgressBarOperator.this.getSource()).setUI(progressBarUI);
            }
        });
    }

    public void setValue(final int i) {
        this.runMapping(new Operator.MapVoidAction("setValue"){

            public void map() {
                ((JProgressBar)JProgressBarOperator.this.getSource()).setValue(i);
            }
        });
    }

    static {
        Timeouts.initDefault("JProgressBarOperator.WaitValueTimeout", WAIT_VALUE_TIMEOUT);
    }

    public static class JProgressBarFinder
    extends Operator.Finder {
        public JProgressBarFinder(ComponentChooser sf) {
            super(JProgressBar.class, sf);
        }

        public JProgressBarFinder() {
            super(JProgressBar.class);
        }
    }

    public static interface ValueChooser {
        public boolean checkValue(int var1);

        public String getDescription();
    }
}

