/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.image;

import java.awt.image.BufferedImage;
import org.netbeans.jemmy.image.ImageComparator;

public class RoughImageComparator
implements ImageComparator {
    double roughness = 0.0;

    public RoughImageComparator(double roughness) {
        this.roughness = roughness;
    }

    public boolean compare(BufferedImage image1, BufferedImage image2) {
        if (image1.getWidth() != image2.getWidth() || image1.getHeight() != image2.getHeight()) {
            return false;
        }
        double maxRoughPixels = (double)(image1.getWidth() * image1.getHeight()) * this.roughness;
        int errorCount = 0;
        for (int x = 0; x < image1.getWidth(); ++x) {
            for (int y = 0; y < image1.getHeight(); ++y) {
                if (image1.getRGB(x, y) == image2.getRGB(x, y) || !((double)(++errorCount) > maxRoughPixels)) continue;
                return false;
            }
        }
        return true;
    }
}

