/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.text;

import org.netbeans.jemmy.Timeout;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.KeyDriver;
import org.netbeans.jemmy.drivers.text.DownKey;
import org.netbeans.jemmy.drivers.text.EndKey;
import org.netbeans.jemmy.drivers.text.HomeKey;
import org.netbeans.jemmy.drivers.text.NavigationKey;
import org.netbeans.jemmy.drivers.text.TextKeyboardDriver;
import org.netbeans.jemmy.drivers.text.UpKey;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JEditorPaneOperator;
import org.netbeans.jemmy.operators.JTextAreaOperator;
import org.netbeans.jemmy.operators.JTextComponentOperator;

public class SwingTextKeyboardDriver
extends TextKeyboardDriver {
    public SwingTextKeyboardDriver() {
        super(new String[]{"org.netbeans.jemmy.operators.JTextComponentOperator"});
    }

    public void clearText(ComponentOperator oper) {
        if (oper instanceof JTextAreaOperator || oper instanceof JEditorPaneOperator) {
            DriverManager.getFocusDriver(oper).giveFocus(oper);
            KeyDriver kdriver = DriverManager.getKeyDriver(oper);
            this.selectText(oper, 0, this.getText(oper).length());
            kdriver.pushKey(oper, 127, 0, oper.getTimeouts().create("ComponentOperator.PushKeyTimeout"));
        } else {
            super.clearText(oper);
        }
    }

    public String getText(ComponentOperator oper) {
        return ((JTextComponentOperator)oper).getDisplayedText();
    }

    public int getCaretPosition(ComponentOperator oper) {
        return ((JTextComponentOperator)oper).getCaretPosition();
    }

    public int getSelectionStart(ComponentOperator oper) {
        return ((JTextComponentOperator)oper).getSelectionStart();
    }

    public int getSelectionEnd(ComponentOperator oper) {
        return ((JTextComponentOperator)oper).getSelectionEnd();
    }

    public NavigationKey[] getKeys(ComponentOperator oper) {
        boolean multiString = oper instanceof JTextAreaOperator || oper instanceof JEditorPaneOperator;
        NavigationKey[] result = new NavigationKey[multiString ? 8 : 4];
        result[0] = new UpKey(37, 0);
        result[1] = new DownKey(39, 0);
        ((UpKey)result[0]).setDownKey((DownKey)result[1]);
        ((DownKey)result[1]).setUpKey((UpKey)result[0]);
        if (multiString) {
            result[2] = new UpKey(38, 0);
            result[3] = new DownKey(40, 0);
            ((UpKey)result[2]).setDownKey((DownKey)result[3]);
            ((DownKey)result[3]).setUpKey((UpKey)result[2]);
            result[4] = new UpKey(33, 0);
            result[5] = new DownKey(34, 0);
            ((UpKey)result[4]).setDownKey((DownKey)result[5]);
            ((DownKey)result[5]).setUpKey((UpKey)result[4]);
            result[6] = new HomeKey(36, 2);
            result[7] = new EndKey(35, 2, this, oper);
        } else {
            result[2] = new HomeKey(36, 0);
            result[3] = new EndKey(35, 0, this, oper);
        }
        return result;
    }

    public Timeout getBetweenTimeout(ComponentOperator oper) {
        return oper.getTimeouts().create("TextComponentOperator.BetweenKeysTimeout");
    }
}

