/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.lang.model.element.Element;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.api.lexer.Token;
import org.netbeans.modules.java.editor.javadoc.JavadocImports;
import org.netbeans.modules.java.editor.semantic.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindLocalUsagesQuery
extends CancellableTreePathScanner<Void, Stack<Tree>> {
    private CompilationInfo info;
    private Set<Token> usages;
    private Element toFind;
    private Document doc;
    private boolean instantRename;

    public FindLocalUsagesQuery() {
        this(false);
    }

    public FindLocalUsagesQuery(boolean bl) {
        this.instantRename = bl;
    }

    public Set<Token> findUsages(Element element, CompilationInfo compilationInfo, Document document) {
        this.info = compilationInfo;
        this.usages = new HashSet<Token>();
        this.toFind = element;
        this.doc = document;
        this.scan(compilationInfo.getCompilationUnit(), null);
        return this.usages;
    }

    private void handlePotentialVariable(TreePath treePath) {
        Token<JavaTokenId> token;
        Element element = this.info.getTrees().getElement(treePath);
        if (((Object)this.toFind).equals(element) && (token = Utilities.getToken(this.info, this.doc, treePath)) != null) {
            this.usages.add(token);
        }
    }

    private void handleJavadoc(Element element) {
        List<Token> list = JavadocImports.computeTokensOfReferencedElements(this.info, element, this.toFind);
        this.usages.addAll(list);
    }

    public Void visitIdentifier(IdentifierTree identifierTree, Stack<Tree> stack) {
        this.handlePotentialVariable(this.getCurrentPath());
        super.visitIdentifier(identifierTree, stack);
        return null;
    }

    public Void visitMethod(MethodTree methodTree, Stack<Tree> stack) {
        this.handlePotentialVariable(this.getCurrentPath());
        Element element = this.info.getTrees().getElement(this.getCurrentPath());
        this.handleJavadoc(element);
        super.visitMethod(methodTree, stack);
        return null;
    }

    public Void visitMemberSelect(MemberSelectTree memberSelectTree, Stack<Tree> stack) {
        this.handlePotentialVariable(this.getCurrentPath());
        super.visitMemberSelect(memberSelectTree, stack);
        return null;
    }

    public Void visitVariable(VariableTree variableTree, Stack<Tree> stack) {
        this.handlePotentialVariable(this.getCurrentPath());
        Element element = this.info.getTrees().getElement(this.getCurrentPath());
        if (element != null && element.getKind().isField()) {
            this.handleJavadoc(element);
        }
        super.visitVariable(variableTree, stack);
        return null;
    }

    public Void visitClass(ClassTree classTree, Stack<Tree> stack) {
        this.handlePotentialVariable(this.getCurrentPath());
        Element element = this.info.getTrees().getElement(this.getCurrentPath());
        this.handleJavadoc(element);
        super.visitClass(classTree, stack);
        return null;
    }

    public Void visitTypeParameter(TypeParameterTree typeParameterTree, Stack<Tree> stack) {
        this.handlePotentialVariable(this.getCurrentPath());
        super.visitTypeParameter(typeParameterTree, stack);
        return null;
    }

    public Void visitNewClass(NewClassTree newClassTree, Stack<Tree> stack) {
        if (this.instantRename) {
            return (Void)super.visitNewClass(newClassTree, stack);
        }
        Element element = this.info.getTrees().getElement(this.getCurrentPath());
        if (((Object)this.toFind).equals(element) && newClassTree.getIdentifier() != null) {
            Token<JavaTokenId> token = Utilities.getToken(this.info, this.doc, new TreePath(this.getCurrentPath(), newClassTree.getIdentifier()));
            if (token != null) {
                this.usages.add(token);
            }
            return null;
        }
        if (element != null && ((Object)this.toFind).equals(element.getEnclosingElement())) {
            return null;
        }
        return (Void)super.visitNewClass(newClassTree, stack);
    }
}

