/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.model.impl.resolver;

import java.util.Collection;
import java.util.Set;
import org.netbeans.modules.xml.schema.model.Import;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.schema.model.impl.SchemaImpl;
import org.netbeans.modules.xml.schema.model.impl.SchemaModelImpl;
import org.netbeans.modules.xml.schema.model.impl.Util;
import org.netbeans.modules.xml.schema.model.impl.resolver.IncludeResolver;
import org.netbeans.modules.xml.schema.model.impl.resolver.ResolveSession;
import org.netbeans.modules.xml.xam.NamedReferenceable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportResolver {
    public static <T extends NamedReferenceable> T resole(SchemaModelImpl schemaModelImpl, String string, String string2, Class<T> clazz) {
        ResolveSession resolveSession = new ResolveSession(schemaModelImpl, string);
        T t = null;
        t = ImportResolver.findInImports(schemaModelImpl, string, string2, clazz, resolveSession);
        if (t != null) {
            return t;
        }
        ImportResolver.populateRecursivelyIncludedImports(schemaModelImpl, string, resolveSession);
        t = ImportResolver.findInIncludedImportsDown(string, string2, clazz, resolveSession, false);
        if (t != null) {
            return t;
        }
        ImportResolver.populateMegaIncludedImports(schemaModelImpl, string, resolveSession);
        t = ImportResolver.findInIncludedImportsDown(string, string2, clazz, resolveSession, true);
        if (t != null) {
            return t;
        }
        t = ImportResolver.findInIncludedImportsUpwards(string, string2, clazz, resolveSession, false);
        if (t != null) {
            return t;
        }
        t = ImportResolver.findInIncludedImportsUpwards(string, string2, clazz, resolveSession, true);
        if (t != null) {
            return t;
        }
        return null;
    }

    static <T extends NamedReferenceable> T findInImports(SchemaModelImpl schemaModelImpl, String string, String string2, Class<T> clazz, ResolveSession resolveSession) {
        SchemaImpl schemaImpl = schemaModelImpl.getSchema();
        if (schemaImpl == null) {
            return null;
        }
        Collection<Import> collection = schemaImpl.getImports();
        for (Import import_ : collection) {
            SchemaModelImpl schemaModelImpl2;
            String string3 = import_.getNamespace();
            if (!Util.equal(string3, string) || (schemaModelImpl2 = schemaModelImpl.resolve(import_)) == null) continue;
            resolveSession.getImported().add(schemaModelImpl2);
            ResolveSession.Checked checked = resolveSession.getChecked(schemaModelImpl2);
            if (checked.itself) continue;
            T t = schemaModelImpl2.findByNameAndType(string2, clazz);
            checked.itself = true;
            if (t == null) continue;
            return t;
        }
        return null;
    }

    static <T extends NamedReferenceable> T findInIncludedImportsDown(String string, String string2, Class<T> clazz, ResolveSession resolveSession, boolean bl) {
        Set<SchemaModelImpl> set = bl ? resolveSession.getMegaImported() : resolveSession.getImported();
        for (SchemaModelImpl schemaModelImpl : set) {
            assert (schemaModelImpl.getSchema() != null);
            assert (Util.equal(schemaModelImpl.getSchema().getTargetNamespace(), string));
            T t = IncludeResolver.resolveRecursiveDown(schemaModelImpl, string2, clazz, resolveSession);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    static <T extends NamedReferenceable> T findInIncludedImportsUpwards(String string, String string2, Class<T> clazz, ResolveSession resolveSession, boolean bl) {
        Set<SchemaModelImpl> set = bl ? resolveSession.getMegaImported() : resolveSession.getImported();
        for (SchemaModelImpl schemaModelImpl : set) {
            assert (schemaModelImpl.getSchema() != null);
            assert (Util.equal(schemaModelImpl.getSchema().getTargetNamespace(), string));
            T t = IncludeResolver.resolveUpwards(schemaModelImpl, string, string2, clazz, resolveSession);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    static void populateRecursivelyIncludedImports(SchemaModelImpl schemaModelImpl, String string, ResolveSession resolveSession) {
        SchemaImpl schemaImpl = schemaModelImpl.getSchema();
        if (schemaImpl == null) {
            return;
        }
        Set<SchemaModelImpl> set = resolveSession.getImported();
        Collection<SchemaModelReference> collection = schemaModelImpl.getNotImportRefrences();
        for (SchemaModelReference schemaModelReference : collection) {
            SchemaModelImpl schemaModelImpl2 = schemaModelImpl.resolve(schemaModelReference);
            if (schemaModelImpl2 == null) continue;
            ResolveSession.Checked checked = resolveSession.getChecked(schemaModelImpl2);
            if (checked.imports) continue;
            checked.imports = true;
            SchemaImpl schemaImpl2 = schemaModelImpl2.getSchema();
            if (schemaImpl2 == null) continue;
            Collection<Import> collection2 = schemaImpl2.getImports();
            for (Import import_ : collection2) {
                SchemaModelImpl schemaModelImpl3;
                String string2 = import_.getNamespace();
                if (!Util.equal(string, string2) || (schemaModelImpl3 = schemaModelImpl2.resolve(import_)) == null) continue;
                set.add(schemaModelImpl3);
            }
            ImportResolver.populateRecursivelyIncludedImports(schemaModelImpl2, string, resolveSession);
        }
    }

    static void populateMegaIncludedImports(SchemaModelImpl schemaModelImpl, String string, ResolveSession resolveSession) {
        Set<SchemaModelImpl> set = resolveSession.getImported();
        Set<SchemaModelImpl> set2 = resolveSession.getMegaImported();
        SchemaImpl schemaImpl = schemaModelImpl.getSchema();
        if (schemaImpl == null) {
            return;
        }
        Set<SchemaModelImpl> set3 = IncludeResolver.getMegaIncludedModels(schemaModelImpl, schemaImpl.getTargetNamespace(), resolveSession);
        for (SchemaModelImpl schemaModelImpl2 : set3) {
            ResolveSession.Checked checked = resolveSession.getChecked(schemaModelImpl2);
            if (schemaModelImpl2 == null || checked.imports) continue;
            checked.imports = true;
            SchemaImpl schemaImpl2 = schemaModelImpl2.getSchema();
            if (schemaImpl2 == null) continue;
            Collection<Import> collection = schemaImpl2.getImports();
            for (Import import_ : collection) {
                SchemaModelImpl schemaModelImpl3;
                String string2 = import_.getNamespace();
                if (!Util.equal(string, string2) || (schemaModelImpl3 = schemaModelImpl2.resolve(import_)) == null || set.contains(schemaModelImpl3)) continue;
                set2.add(schemaModelImpl3);
            }
        }
    }
}

