/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PresenterEvent;
import org.netbeans.modules.vmd.api.properties.DesignPropertyDescriptor;
import org.netbeans.modules.vmd.api.properties.PropertiesPresenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesPresenterForwarder
extends PropertiesPresenter {
    private String propertyName;
    private String[] propertyNames;

    public static Presenter createByReference(String string) {
        return new PropertiesPresenterForwarder(string, new String[0]);
    }

    public static Presenter createByNames(String string, String ... stringArray) {
        return new PropertiesPresenterForwarder(string, stringArray);
    }

    private PropertiesPresenterForwarder(String string, String ... stringArray) {
        this.propertyName = string;
        this.propertyNames = stringArray;
    }

    @Override
    public List<DesignPropertyDescriptor> getDesignPropertyDescriptors() {
        DesignComponent designComponent = this.getComponent().readProperty(this.propertyName).getComponent();
        if (designComponent == null) {
            return Collections.emptyList();
        }
        ArrayList<DesignPropertyDescriptor> arrayList = new ArrayList<DesignPropertyDescriptor>();
        Collection collection = designComponent.getPresenters(PropertiesPresenter.class);
        if (collection == null) {
            return Collections.emptyList();
        }
        for (PropertiesPresenter propertiesPresenter : collection) {
            arrayList.addAll(this.filterDescriptors(propertiesPresenter.getDesignPropertyDescriptors()));
        }
        return arrayList;
    }

    @Override
    public List<String> getPropertiesCategories() {
        DesignComponent designComponent = this.getComponent().readProperty(this.propertyName).getComponent();
        if (designComponent == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PropertiesPresenter propertiesPresenter : designComponent.getPresenters(PropertiesPresenter.class)) {
            arrayList.addAll(propertiesPresenter.getPropertiesCategories());
        }
        return arrayList;
    }

    private List<DesignPropertyDescriptor> filterDescriptors(List<DesignPropertyDescriptor> list) {
        if (this.propertyNames == null || this.propertyNames.length == 0) {
            return list;
        }
        ArrayList<DesignPropertyDescriptor> arrayList = new ArrayList<DesignPropertyDescriptor>(list.size());
        for (DesignPropertyDescriptor designPropertyDescriptor : list) {
            for (String string : this.propertyNames) {
                if (!designPropertyDescriptor.getPropertyNames().contains(string)) continue;
                arrayList.add(designPropertyDescriptor);
            }
        }
        return arrayList;
    }

    protected void notifyDetached(DesignComponent designComponent) {
    }

    protected DesignEventFilter getEventFilter() {
        return null;
    }

    protected void designChanged(DesignEvent designEvent) {
    }

    protected void presenterChanged(PresenterEvent presenterEvent) {
    }

    protected void notifyAttached(DesignComponent designComponent) {
    }
}

