/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.event.ActionEvent;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.editor.Utilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class BaseAction
extends TextAction {
    public static final String POPUP_MENU_TEXT = "PopupMenuText";
    public static final String LOCALE_DESC_PREFIX = "desc-";
    public static final String LOCALE_POPUP_PREFIX = "popup-";
    public static final String ICON_RESOURCE_PROPERTY = "IconResource";
    public static final int SELECTION_REMOVE = 1;
    public static final int MAGIC_POSITION_RESET = 2;
    public static final int ABBREV_RESET = 4;
    public static final int UNDO_MERGE_RESET = 8;
    public static final int WORD_MATCH_RESET = 16;
    public static final int CLEAR_STATUS_TEXT = 32;
    public static final int NO_RECORDING = 64;
    public static final int SAVE_POSITION = 128;
    public static final String NO_KEYBINDING = "no-keybinding";
    private static Logger UILOG = Logger.getLogger("org.netbeans.ui.actions.editor");
    protected int updateMask;
    private static boolean recording;
    private static StringBuffer macroBuffer;
    private static StringBuffer textBuffer;
    static final long serialVersionUID = -4255521122272110786L;

    public BaseAction() {
        this(null);
    }

    public BaseAction(int n) {
        this(null, n);
    }

    public BaseAction(String string) {
        this(string, 0);
    }

    public BaseAction(String string, int n) {
        super(string);
        this.updateMask = n;
    }

    protected Object findValue(String string) {
        return LocaleSupport.getString(string);
    }

    public Object getValue(String string) {
        Object object = super.getValue(string);
        if (object == null && (object = this.createDefaultValue(string)) != null) {
            this.putValue(string, object);
        }
        return object;
    }

    public void putValue(String string, Object object) {
        super.putValue(string, object);
        if ("Name".equals(string) && object instanceof String) {
            this.actionNameUpdate((String)object);
        }
    }

    protected void actionNameUpdate(String string) {
    }

    protected Object createDefaultValue(String string) {
        String string2;
        Object object = null;
        if ("ShortDescription".equals(string)) {
            Class clazz = this.getShortDescriptionBundleClass();
            if (clazz != null) {
                String string3 = (String)this.getValue("Name");
                try {
                    object = NbBundle.getBundle((Class)clazz).getString(string3);
                }
                catch (MissingResourceException missingResourceException) {
                    MissingResourceException missingResourceException2 = new MissingResourceException("Can't find SHORT_DESCRIPTION for " + this + "; bundleClass=" + clazz + "; bundleKey=" + string3, clazz.getName(), string3);
                    missingResourceException2.initCause(missingResourceException);
                    throw missingResourceException2;
                }
            } else {
                object = this.getDefaultShortDescription();
            }
        } else if (POPUP_MENU_TEXT.equals(string) && (object = this.findValue(string2 = LOCALE_POPUP_PREFIX + this.getValue("Name"))) == null) {
            object = this.getValue("ShortDescription");
        }
        return object;
    }

    protected Class getShortDescriptionBundleClass() {
        return null;
    }

    protected Object getDefaultShortDescription() {
        String string = (String)this.getValue("Name");
        String string2 = LOCALE_DESC_PREFIX + string;
        Object object = this.findValue(string2);
        if (object == null && (object = this.findValue(string)) == null) {
            object = string;
        }
        return object;
    }

    public final void actionPerformed(final ActionEvent actionEvent) {
        final JTextComponent jTextComponent = this.getTextComponent(actionEvent);
        if (jTextComponent == null || !(jTextComponent.getDocument() instanceof BaseDocument)) {
            return;
        }
        if (recording && 0 == (this.updateMask & 0x40)) {
            this.recordAction(jTextComponent, actionEvent);
        }
        this.updateComponent(jTextComponent);
        if (UILOG.isLoggable(Level.FINE)) {
            String string;
            String string2 = string = this.getValue("Name") != null ? this.getValue("Name").toString().toLowerCase() : null;
            if (string != null && !"default-typed".equals(string) && -1 == string.indexOf("caret") && -1 == string.indexOf("delete") && -1 == string.indexOf("selection") && -1 == string.indexOf("build-tool-tip") && -1 == string.indexOf("build-popup-menu") && -1 == string.indexOf("page-up") && -1 == string.indexOf("page-down") && -1 == string.indexOf("-kit-install")) {
                LogRecord logRecord = new LogRecord(Level.FINE, "UI_ACTION_EDITOR");
                logRecord.setResourceBundle(NbBundle.getBundle(BaseAction.class));
                if (actionEvent != null) {
                    logRecord.setParameters(new Object[]{actionEvent, actionEvent.toString(), this, this.toString(), this.getValue("Name")});
                } else {
                    logRecord.setParameters(new Object[]{"no-ActionEvent", "no-ActionEvent", this, this.toString(), this.getValue("Name")});
                }
                logRecord.setLoggerName(UILOG.getName());
                UILOG.log(logRecord);
            }
        }
        if (this.asynchonous()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    BaseAction.this.actionPerformed(actionEvent, jTextComponent);
                }
            });
        } else {
            this.actionPerformed(actionEvent, jTextComponent);
        }
    }

    private void recordAction(JTextComponent jTextComponent, ActionEvent actionEvent) {
        if (this == jTextComponent.getKeymap().getDefaultAction()) {
            textBuffer.append(this.getFilteredActionCommand(actionEvent.getActionCommand()));
        } else {
            if (textBuffer.length() > 0) {
                if (macroBuffer.length() > 0) {
                    macroBuffer.append(' ');
                }
                macroBuffer.append(this.encodeText(textBuffer.toString()));
                textBuffer.setLength(0);
            }
            if (macroBuffer.length() > 0) {
                macroBuffer.append(' ');
            }
            String string = (String)this.getValue("Name");
            macroBuffer.append(this.encodeActionName(string));
        }
    }

    private String getFilteredActionCommand(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        char c = string.charAt(0);
        if (c >= ' ' && c != '\u007f') {
            return string;
        }
        return "";
    }

    boolean startRecording(JTextComponent jTextComponent) {
        if (recording) {
            return false;
        }
        recording = true;
        macroBuffer.setLength(0);
        textBuffer.setLength(0);
        Utilities.setStatusText(jTextComponent, NbBundle.getBundle(BaseAction.class).getString("macro-recording"));
        return true;
    }

    String stopRecording(JTextComponent jTextComponent) {
        if (!recording) {
            return null;
        }
        if (textBuffer.length() > 0) {
            if (macroBuffer.length() > 0) {
                macroBuffer.append(' ');
            }
            macroBuffer.append(this.encodeText(textBuffer.toString()));
        }
        String string = macroBuffer.toString();
        recording = false;
        Utilities.setStatusText(jTextComponent, "");
        return string;
    }

    private String encodeText(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer("\"");
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '\"' || c == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        return stringBuffer.append('\"').toString();
    }

    private String encodeActionName(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (Character.isWhitespace(c) || c == '\\') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public abstract void actionPerformed(ActionEvent var1, JTextComponent var2);

    protected boolean asynchonous() {
        return false;
    }

    public JMenuItem getPopupMenuItem(JTextComponent jTextComponent) {
        return null;
    }

    public String getPopupMenuText(JTextComponent jTextComponent) {
        String string = (String)this.getValue(POPUP_MENU_TEXT);
        if (string == null) {
            string = (String)this.getValue("Name");
        }
        return string;
    }

    public void updateComponent(JTextComponent jTextComponent) {
        this.updateComponent(jTextComponent, this.updateMask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateComponent(JTextComponent jTextComponent, int n) {
        if (jTextComponent != null && jTextComponent.getDocument() instanceof BaseDocument) {
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            boolean bl = false;
            try {
                if ((n & 1) != 0) {
                    bl = true;
                    baseDocument.extWriteLock();
                    Caret caret = jTextComponent.getCaret();
                    if (caret != null && Utilities.isSelectionShowing(caret)) {
                        int n2;
                        int n3 = caret.getDot();
                        if (n3 < (n2 = caret.getMark())) {
                            int n4 = n3;
                            n3 = n2;
                            n2 = n4;
                        }
                        try {
                            jTextComponent.getDocument().remove(n2, n3 - n2);
                        }
                        catch (BadLocationException badLocationException) {
                            Utilities.annotateLoggable(badLocationException);
                        }
                    }
                }
                if ((n & 2) != 0 && jTextComponent.getCaret() != null) {
                    jTextComponent.getCaret().setMagicCaretPosition(null);
                }
                if ((n & 8) != 0) {
                    baseDocument.resetUndoMerge();
                }
                if ((n & 0x10) != 0) {
                    ((BaseTextUI)jTextComponent.getUI()).getEditorUI().getWordMatch().clear();
                }
                if (!recording && (n & 0x20) != 0) {
                    Utilities.clearStatusText(jTextComponent);
                }
                if ((n & 0x80) != 0) {
                    JumpList.checkAddEntry(jTextComponent);
                }
            }
            finally {
                if (bl) {
                    baseDocument.extWriteUnlock();
                }
            }
        }
    }

    static {
        macroBuffer = new StringBuffer();
        textBuffer = new StringBuffer();
    }
}

