/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo.options;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.xml.VersionException;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoderStream;
import org.netbeans.modules.cnd.gizmo.options.GizmoOptionsImpl;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.xml.sax.Attributes;

public class GizmoOptionsXMLCodec
extends XMLDecoder
implements XMLEncoder {
    private final Logger log = DLightLogger.getLogger(GizmoOptionsXMLCodec.class);
    private GizmoOptionsImpl gizmoOptions;
    private static final String PROFILE_ON_RUN_ELEMENT = "profileOnRun";
    private static final String CONFIGURATION_NAME_ELEMENT = "configurationname";
    public static final String TRUE_VALUE = "true";
    public static final String FALSE_VALUE = "false";
    private static final int thisversion = 3;
    private int version = 0;

    public GizmoOptionsXMLCodec(GizmoOptionsImpl gizmoOptionsImpl) {
        this.gizmoOptions = gizmoOptionsImpl;
    }

    public static int getVersion() {
        return 3;
    }

    public String tag() {
        return "gizmo_options";
    }

    public void start(Attributes attributes) throws VersionException {
        String string = "gizmo options";
        int n = GizmoOptionsXMLCodec.getVersion();
        this.version = this.getVersion(attributes);
        this.checkVersion(attributes, string, n);
    }

    public void end() {
        this.gizmoOptions.clearChanged();
    }

    public void startElement(String string, Attributes attributes) {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "start element with the name " + string);
        }
    }

    public void endElement(String string, String string2) {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "end element with the name " + string);
        }
        if (string.equals(PROFILE_ON_RUN_ELEMENT)) {
            boolean bl = string2.equals(TRUE_VALUE);
            this.gizmoOptions.getProfileOnRun().setValue(bl);
        } else if (string.equals(CONFIGURATION_NAME_ELEMENT)) {
            String string3 = string2;
            this.gizmoOptions.setPreferredDLightConfiguration(string3);
        }
    }

    private static void encode(XMLEncoderStream xMLEncoderStream, GizmoOptionsImpl gizmoOptionsImpl) {
        xMLEncoderStream.elementOpen("gizmo_options", GizmoOptionsXMLCodec.getVersion());
        if (gizmoOptionsImpl.getProfileOnRun().getModified()) {
            xMLEncoderStream.element(PROFILE_ON_RUN_ELEMENT, "" + gizmoOptionsImpl.getProfileOnRun().getValue());
        }
        if (gizmoOptionsImpl.getDLightConfiguration() != null) {
            xMLEncoderStream.element(CONFIGURATION_NAME_ELEMENT, "" + gizmoOptionsImpl.getDLightConfiguration().getConfigurationName());
        }
        xMLEncoderStream.elementClose("gizmo_options");
    }

    public void encode(XMLEncoderStream xMLEncoderStream) {
        GizmoOptionsXMLCodec.encode(xMLEncoderStream, this.gizmoOptions);
    }
}

