/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.projects;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.CatalogUtils;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class JaxWsCatalogPanel
extends JPanel {
    static final String GENERATE_JAXWS_CATALOG = "generate_jax_ws_catalog";
    private JCheckBox notAskAgain;
    private JLabel textLabel;

    public JaxWsCatalogPanel() {
        this.initComponents();
    }

    boolean notAskAgain() {
        return this.notAskAgain.isSelected();
    }

    private static boolean generateJaxWsCatalog(String string) {
        Preferences preferences = NbPreferences.forModule(JaxWsCatalogPanel.class);
        if (preferences == null || preferences.get(GENERATE_JAXWS_CATALOG, null) == null) {
            JaxWsCatalogPanel jaxWsCatalogPanel = new JaxWsCatalogPanel();
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jaxWsCatalogPanel, NbBundle.getMessage(JaxWsCatalogPanel.class, (String)"TTL_GenerateJaxWsCatalog", (Object)string), true, 0, null, null);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (jaxWsCatalogPanel.notAskAgain() && preferences != null) {
                if (NotifyDescriptor.YES_OPTION.equals(object)) {
                    preferences.put(GENERATE_JAXWS_CATALOG, "true");
                } else if (NotifyDescriptor.NO_OPTION.equals(object)) {
                    preferences.put(GENERATE_JAXWS_CATALOG, "false");
                }
            }
            return NotifyDescriptor.YES_OPTION.equals(object);
        }
        return "true".equals(preferences.get(GENERATE_JAXWS_CATALOG, null));
    }

    static void generateJaxWsCatalog(Project project, JAXWSClientSupport jAXWSClientSupport) throws IOException {
        FileObject fileObject;
        if (JaxWsCatalogPanel.generateJaxWsCatalog(project.getProjectDirectory().getName()) && (fileObject = jAXWSClientSupport.getWsdlFolder(true)) != null) {
            JaxWsModel jaxWsModel;
            FileObject fileObject2 = WSUtils.retrieveJaxWsCatalogFromResource((FileObject)fileObject.getParent());
            FileObject fileObject3 = project.getProjectDirectory().getFileObject("catalog.xml");
            if (fileObject3 != null && (jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class)) != null) {
                CatalogUtils.copyCatalogEntriesForAllClients((FileObject)fileObject3, (FileObject)fileObject2, (JaxWsModel)jaxWsModel);
                for (Client client : jaxWsModel.getClients()) {
                    FileObject fileObject4 = jAXWSClientSupport.getLocalWsdlFolderForClient(client.getName(), false);
                    if (fileObject4 == null) continue;
                    WSUtils.copyFiles((FileObject)fileObject4, (FileObject)fileObject);
                }
            }
        }
    }

    private void initComponents() {
        this.textLabel = new JLabel();
        this.notAskAgain = new JCheckBox();
        this.textLabel.setText(NbBundle.getMessage(JaxWsCatalogPanel.class, (String)"MSG_CreateJaxWs"));
        this.notAskAgain.setText(NbBundle.getMessage(JaxWsCatalogPanel.class, (String)"MSG_DontAskAgain"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(26, 26, 26).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.notAskAgain).add((Component)this.textLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(21, 21, 21).add((Component)this.textLabel).add(18, 18, 18).add((Component)this.notAskAgain).addContainerGap(17, Short.MAX_VALUE)));
    }
}

