/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.websvc.core.WsWsdlCookie;
import org.netbeans.modules.websvc.project.api.WebService;
import org.netbeans.modules.websvc.project.api.WebServiceData;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class JaxWsExplorerPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private DialogDescriptor descriptor;
    private ExplorerManager manager = new ExplorerManager();
    private BeanTreeView treeView;
    private Node selectedServiceNode = null;
    private JLabel jLblTreeView;

    public JaxWsExplorerPanel() {
        this.initComponents();
        this.initUserComponents();
    }

    private void initComponents() {
        this.jLblTreeView = new JLabel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLblTreeView, (String)NbBundle.getMessage(JaxWsExplorerPanel.class, (String)"LBL_AvailableWebServices"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.jLblTreeView, gridBagConstraints);
    }

    private void initUserComponents() {
        this.treeView = new BeanTreeView();
        this.treeView.setRootVisible(false);
        this.treeView.setPopupAllowed(false);
        this.treeView.setBorder((Border)new EtchedBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.treeView, gridBagConstraints);
        this.jLblTreeView.setLabelFor(this.treeView.getViewport().getView());
        this.treeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JaxWsExplorerPanel.class, (String)"ACSD_WebServicesTreeView"));
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JaxWsExplorerPanel.class, (String)"ACSD_WebServicesTreeView"));
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void addNotify() {
        super.addNotify();
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        Children.Array array = new Children.Array();
        AbstractNode abstractNode = new AbstractNode((Children)array);
        ArrayList<ProjectNode> arrayList = new ArrayList<ProjectNode>();
        block0: for (Project project : projectArray) {
            LogicalViewProvider logicalViewProvider;
            Children children;
            Children.Array array2;
            List list;
            WebServiceData webServiceData = WebServiceData.getWebServiceData((Project)project);
            if (webServiceData != null) {
                WebService webService2;
                list = webServiceData.getServiceProviders();
                if (list.size() <= 0) continue;
                array2 = new Children.Array();
                children = new ArrayList();
                boolean bl = false;
                for (WebService webService2 : list) {
                    Node node = webService2.createNode();
                    if (node == null) continue;
                    children.add(new ServiceNode(node));
                }
                LogicalViewProvider logicalViewProvider2 = (LogicalViewProvider)project.getLookup().lookup(LogicalViewProvider.class);
                if (logicalViewProvider2 == null) continue;
                array2.add(children.toArray(new Node[children.size()]));
                webService2 = logicalViewProvider2.createLogicalView();
                arrayList.add(new ProjectNode((Children)array2, (Node)webService2));
                continue;
            }
            list = (LogicalViewProvider)project.getLookup().lookup(LogicalViewProvider.class);
            if (list == null || (children = (array2 = list.createLogicalView()).getChildren()).getNodesCount() <= 0) continue;
            for (LogicalViewProvider logicalViewProvider3 : logicalViewProvider = children.getNodes()) {
                if (logicalViewProvider3.getValue("is_web_service_root") == null) continue;
                Children.Array array3 = new Children.Array();
                Children children2 = logicalViewProvider3.getChildren();
                if (children2.getNodesCount() <= 0) continue block0;
                Node[] nodeArray = children2.getNodes();
                Node[] nodeArray2 = new Node[nodeArray.length];
                for (int i = 0; i < nodeArray.length; ++i) {
                    nodeArray2[i] = new ServiceNode(nodeArray[i]);
                }
                array3.add(nodeArray2);
                arrayList.add(new ProjectNode((Children)array3, (Node)array2));
                continue block0;
            }
        }
        Project[] projectArray2 = new Node[arrayList.size()];
        arrayList.toArray(projectArray2);
        array.add((Node[])projectArray2);
        this.manager.setRootContext((Node)abstractNode);
        this.descriptor.setValid(false);
    }

    public void removeNotify() {
        this.manager.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    public void setDescriptor(DialogDescriptor dialogDescriptor) {
        this.descriptor = dialogDescriptor;
    }

    public Node getSelectedService() {
        return this.selectedServiceNode;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Node[] nodeArray;
        if (propertyChangeEvent.getSource() == this.manager && "selectedNodes".equals(propertyChangeEvent.getPropertyName()) && (nodeArray = this.manager.getSelectedNodes()) != null && nodeArray.length > 0) {
            Node node = nodeArray[0];
            if (node.getCookie(WsWsdlCookie.class) != null) {
                this.selectedServiceNode = node;
                this.descriptor.setValid(true);
            } else {
                this.selectedServiceNode = null;
                this.descriptor.setValid(false);
            }
        }
    }

    private class ServiceNode
    extends FilterNode
    implements WsWsdlCookie {
        private Node serviceNode;

        ServiceNode(Node node) {
            super(node);
            this.serviceNode = node;
        }

        public String getWsdlURL() {
            WsWsdlCookie wsWsdlCookie = (WsWsdlCookie)this.serviceNode.getLookup().lookup(WsWsdlCookie.class);
            if (wsWsdlCookie != null) {
                return wsWsdlCookie.getWsdlURL();
            }
            String string = (String)this.serviceNode.getValue("wsdl-url");
            if (string != null) {
                return string;
            }
            return null;
        }
    }

    private class ProjectNode
    extends AbstractNode {
        private Node rootNode;

        ProjectNode(Children children, Node node) {
            super(children);
            this.rootNode = node;
            this.setName(node.getDisplayName());
        }

        public Image getIcon(int n) {
            return this.rootNode.getIcon(n);
        }

        public Image getOpenedIcon(int n) {
            return this.rootNode.getOpenedIcon(n);
        }
    }
}

